/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analysis;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.util.Version;
import org.apache.solr.common.ResourceLoader;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.StrUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class BaseTokenStreamFactory {
    protected Map<String, String> args;
    protected Version luceneMatchVersion = null;

    BaseTokenStreamFactory() {
    }

    public void init(Map<String, String> args) {
        this.args = args;
        String matchVersion = args.get("luceneMatchVersion");
        if (matchVersion != null) {
            this.luceneMatchVersion = this.parseLuceneVersionString(matchVersion);
        }
    }

    public Map<String, String> getArgs() {
        return this.args;
    }

    protected final void assureMatchVersion() {
        if (this.luceneMatchVersion == null) {
            throw new RuntimeException("Configuration Error: Factory '" + this.getClass().getName() + "' needs a 'luceneMatchVersion' parameter");
        }
    }

    protected int getInt(String name) {
        return this.getInt(name, -1, false);
    }

    protected int getInt(String name, int defaultVal) {
        return this.getInt(name, defaultVal, true);
    }

    protected int getInt(String name, int defaultVal, boolean useDefault) {
        String s = this.args.get(name);
        if (s == null) {
            if (useDefault) {
                return defaultVal;
            }
            throw new RuntimeException("Configuration Error: missing parameter '" + name + "'");
        }
        return Integer.parseInt(s);
    }

    protected boolean getBoolean(String name, boolean defaultVal) {
        return this.getBoolean(name, defaultVal, true);
    }

    protected boolean getBoolean(String name, boolean defaultVal, boolean useDefault) {
        String s = this.args.get(name);
        if (s == null) {
            if (useDefault) {
                return defaultVal;
            }
            throw new RuntimeException("Configuration Error: missing parameter '" + name + "'");
        }
        return Boolean.parseBoolean(s);
    }

    protected CharArraySet getWordSet(ResourceLoader loader, String wordFiles, boolean ignoreCase) throws IOException {
        this.assureMatchVersion();
        List<String> files = StrUtils.splitFileNames(wordFiles);
        CharArraySet words = null;
        if (files.size() > 0) {
            words = new CharArraySet(files.size() * 10, ignoreCase);
            for (String file : files) {
                List<String> wlist = loader.getLines(file.trim());
                words.addAll((Collection)StopFilter.makeStopSet(wlist, (boolean)ignoreCase));
            }
        }
        return words;
    }

    private Version parseLuceneVersionString(String matchVersion) {
        Version version;
        String parsedMatchVersion = matchVersion.toUpperCase(Locale.ENGLISH);
        parsedMatchVersion = parsedMatchVersion.replaceFirst("^(\\d)\\.(\\d)$", "LUCENE_$1$2");
        try {
            version = Version.valueOf((String)parsedMatchVersion);
        }
        catch (IllegalArgumentException iae) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Invalid luceneMatchVersion '" + matchVersion + "', valid values are: " + Arrays.toString(Version.values()) + " or a string in format 'V.V'", (Throwable)iae, false);
        }
        return version;
    }
}

