/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ejb.util;

import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.InvalidNameException;
import javax.naming.NamingException;
import javax.naming.event.EventContext;
import javax.naming.event.NamespaceChangeListener;
import javax.naming.event.NamingEvent;
import javax.naming.event.NamingExceptionEvent;
import javax.naming.event.NamingListener;
import org.hibernate.ejb.Ejb3Configuration;
import org.hibernate.ejb.EntityManagerLogger;
import org.hibernate.internal.util.jndi.JndiHelper;
import org.jboss.logging.Logger;

public class NamingHelper {
    private static final EntityManagerLogger LOG = (EntityManagerLogger)Logger.getMessageLogger(EntityManagerLogger.class, (String)NamingHelper.class.getName());
    private static final NamingListener LISTENER = new NamespaceChangeListener(){

        @Override
        public void objectAdded(NamingEvent evt) {
            LOG.debugf("An Ejb3Configuration was successfully bound to name: %s", evt.getNewBinding().getName());
        }

        @Override
        public void objectRemoved(NamingEvent evt) {
            String name = evt.getOldBinding().getName();
            LOG.ejb3ConfigurationUnboundFromName(name);
        }

        @Override
        public void objectRenamed(NamingEvent evt) {
            String name = evt.getOldBinding().getName();
            LOG.ejb3ConfigurationRenamedFromName(name);
        }

        @Override
        public void namingExceptionThrown(NamingExceptionEvent evt) {
            LOG.unableToAccessEjb3Configuration(evt.getException());
        }
    };

    private NamingHelper() {
    }

    public static void bind(Ejb3Configuration cfg) {
        String name = cfg.getHibernateConfiguration().getProperty("hibernate.ejb.configuration_jndi_name");
        if (name == null) {
            LOG.debugf("No JNDI name configured for binding Ejb3Configuration", new Object[0]);
        } else {
            LOG.ejb3ConfigurationName(name);
            try {
                InitialContext ctx = JndiHelper.getInitialContext((Properties)cfg.getProperties());
                JndiHelper.bind((Context)ctx, (String)name, (Object)cfg);
                LOG.boundEjb3ConfigurationToJndiName(name);
                ((EventContext)((Object)ctx)).addNamingListener(name, 0, LISTENER);
            }
            catch (InvalidNameException ine) {
                LOG.invalidJndiName(name, ine);
            }
            catch (NamingException ne) {
                LOG.unableToBindEjb3ConfigurationToJndi(ne);
            }
            catch (ClassCastException cce) {
                LOG.initialContextDoesNotImplementEventContext();
            }
        }
    }
}

