/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal;

import java.io.Serializable;
import java.sql.Connection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.transaction.SystemException;
import org.hibernate.CacheMode;
import org.hibernate.Criteria;
import org.hibernate.EmptyInterceptor;
import org.hibernate.EntityMode;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.Interceptor;
import org.hibernate.LockMode;
import org.hibernate.MappingException;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.SessionException;
import org.hibernate.StatelessSession;
import org.hibernate.Transaction;
import org.hibernate.UnresolvableObjectException;
import org.hibernate.cache.spi.access.EntityRegionAccessStrategy;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.internal.SessionEventListenerManagerImpl;
import org.hibernate.engine.internal.StatefulPersistenceContext;
import org.hibernate.engine.internal.Versioning;
import org.hibernate.engine.jdbc.internal.JdbcCoordinatorImpl;
import org.hibernate.engine.jdbc.spi.JdbcCoordinator;
import org.hibernate.engine.query.spi.HQLQueryPlan;
import org.hibernate.engine.query.spi.NativeSQLQueryPlan;
import org.hibernate.engine.query.spi.sql.NativeSQLQuerySpecification;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.QueryParameters;
import org.hibernate.engine.spi.SessionEventListenerManager;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.transaction.internal.jta.JtaStatusHelper;
import org.hibernate.engine.transaction.jta.platform.spi.JtaPlatform;
import org.hibernate.id.IdentifierGeneratorHelper;
import org.hibernate.internal.AbstractSessionImpl;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.CriteriaImpl;
import org.hibernate.internal.SessionFactoryImpl;
import org.hibernate.loader.criteria.CriteriaLoader;
import org.hibernate.loader.custom.CustomLoader;
import org.hibernate.loader.custom.CustomQuery;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.OuterJoinLoadable;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.resource.jdbc.spi.JdbcSessionContext;
import org.hibernate.resource.jdbc.spi.StatementInspector;
import org.hibernate.resource.transaction.TransactionCoordinator;
import org.hibernate.resource.transaction.spi.TransactionStatus;

public class StatelessSessionImpl
extends AbstractSessionImpl
implements StatelessSession {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(StatelessSessionImpl.class);
    private TransactionCoordinator transactionCoordinator;
    private transient JdbcCoordinator jdbcCoordinator;
    private PersistenceContext temporaryPersistenceContext = new StatefulPersistenceContext(this);
    private long timestamp;
    private JdbcSessionContext jdbcSessionContext;
    private LoadQueryInfluencers statelessLoadQueryInfluencers = new LoadQueryInfluencers(null){

        @Override
        public String getInternalFetchProfile() {
            return null;
        }

        @Override
        public void setInternalFetchProfile(String internalFetchProfile) {
        }
    };
    private SessionEventListenerManagerImpl sessionEventsManager;

    StatelessSessionImpl(Connection connection, String tenantIdentifier, SessionFactoryImpl factory) {
        this(connection, tenantIdentifier, factory, factory.getSettings().getRegionFactory().nextTimestamp());
    }

    StatelessSessionImpl(Connection connection, String tenantIdentifier, SessionFactoryImpl factory, long timestamp) {
        super(factory, tenantIdentifier);
        this.jdbcSessionContext = new AbstractSessionImpl.JdbcSessionContextImpl(this, factory, new StatementInspector(){

            @Override
            public String inspect(String sql) {
                return null;
            }
        });
        this.jdbcCoordinator = new JdbcCoordinatorImpl(connection, this);
        this.transactionCoordinator = this.getTransactionCoordinatorBuilder().buildTransactionCoordinator(this.jdbcCoordinator, this);
        this.currentHibernateTransaction = this.getTransaction();
        this.timestamp = timestamp;
    }

    @Override
    public TransactionCoordinator getTransactionCoordinator() {
        return this.transactionCoordinator;
    }

    @Override
    public JdbcCoordinator getJdbcCoordinator() {
        return this.jdbcCoordinator;
    }

    @Override
    public boolean shouldAutoJoinTransaction() {
        return true;
    }

    @Override
    public Serializable insert(Object entity) {
        this.errorIfClosed();
        return this.insert(null, entity);
    }

    @Override
    public Serializable insert(String entityName, Object entity) {
        boolean substitute;
        this.errorIfClosed();
        EntityPersister persister = this.getEntityPersister(entityName, entity);
        Serializable id = persister.getIdentifierGenerator().generate(this, entity);
        Object[] state = persister.getPropertyValues(entity);
        if (persister.isVersioned() && (substitute = Versioning.seedVersion(state, persister.getVersionProperty(), persister.getVersionType(), this))) {
            persister.setPropertyValues(entity, state);
        }
        if (id == IdentifierGeneratorHelper.POST_INSERT_INDICATOR) {
            id = persister.insert(state, entity, this);
        } else {
            persister.insert(id, state, entity, this);
        }
        persister.setIdentifier(entity, id, this);
        return id;
    }

    @Override
    public void delete(Object entity) {
        this.errorIfClosed();
        this.delete(null, entity);
    }

    @Override
    public void delete(String entityName, Object entity) {
        this.errorIfClosed();
        EntityPersister persister = this.getEntityPersister(entityName, entity);
        Serializable id = persister.getIdentifier(entity, this);
        Object version = persister.getVersion(entity);
        persister.delete(id, version, entity, this);
    }

    @Override
    public void update(Object entity) {
        this.errorIfClosed();
        this.update(null, entity);
    }

    @Override
    public void update(String entityName, Object entity) {
        Object oldVersion;
        this.errorIfClosed();
        EntityPersister persister = this.getEntityPersister(entityName, entity);
        Serializable id = persister.getIdentifier(entity, this);
        Object[] state = persister.getPropertyValues(entity);
        if (persister.isVersioned()) {
            oldVersion = persister.getVersion(entity);
            Object newVersion = Versioning.increment(oldVersion, persister.getVersionType(), this);
            Versioning.setVersion(state, newVersion, persister);
            persister.setPropertyValues(entity, state);
        } else {
            oldVersion = null;
        }
        persister.update(id, state, null, false, null, oldVersion, entity, null, this);
    }

    @Override
    public Object get(Class entityClass, Serializable id) {
        return this.get(entityClass.getName(), id);
    }

    @Override
    public Object get(Class entityClass, Serializable id, LockMode lockMode) {
        return this.get(entityClass.getName(), id, lockMode);
    }

    @Override
    public Object get(String entityName, Serializable id) {
        return this.get(entityName, id, LockMode.NONE);
    }

    @Override
    public Object get(String entityName, Serializable id, LockMode lockMode) {
        this.errorIfClosed();
        Object result = this.getFactory().getEntityPersister(entityName).load(id, null, lockMode, (SessionImplementor)this);
        if (this.temporaryPersistenceContext.isLoadFinished()) {
            this.temporaryPersistenceContext.clear();
        }
        return result;
    }

    @Override
    public void refresh(Object entity) {
        this.refresh(this.bestGuessEntityName(entity), entity, LockMode.NONE);
    }

    @Override
    public void refresh(String entityName, Object entity) {
        this.refresh(entityName, entity, LockMode.NONE);
    }

    @Override
    public void refresh(Object entity, LockMode lockMode) {
        this.refresh(this.bestGuessEntityName(entity), entity, lockMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refresh(String entityName, Object entity, LockMode lockMode) {
        EntityPersister persister = this.getEntityPersister(entityName, entity);
        Serializable id = persister.getIdentifier(entity, this);
        if (LOG.isTraceEnabled()) {
            LOG.tracev("Refreshing transient {0}", MessageHelper.infoString(persister, id, this.getFactory()));
        }
        if (persister.hasCache()) {
            EntityRegionAccessStrategy cache = persister.getCacheAccessStrategy();
            Object ck = cache.generateCacheKey(id, persister, this.getFactory(), this.getTenantIdentifier());
            cache.evict(ck);
        }
        String previousFetchProfile = this.getLoadQueryInfluencers().getInternalFetchProfile();
        Object result = null;
        try {
            this.getLoadQueryInfluencers().setInternalFetchProfile("refresh");
            result = persister.load(id, entity, lockMode, (SessionImplementor)this);
        }
        finally {
            this.getLoadQueryInfluencers().setInternalFetchProfile(previousFetchProfile);
        }
        UnresolvableObjectException.throwIfNull(result, id, persister.getEntityName());
    }

    @Override
    public Object immediateLoad(String entityName, Serializable id) throws HibernateException {
        throw new SessionException("proxies cannot be fetched by a stateless session");
    }

    @Override
    public void initializeCollection(PersistentCollection collection, boolean writing) throws HibernateException {
        throw new SessionException("collections cannot be fetched by a stateless session");
    }

    @Override
    public Object instantiate(String entityName, Serializable id) throws HibernateException {
        this.errorIfClosed();
        return this.getFactory().getEntityPersister(entityName).instantiate(id, this);
    }

    @Override
    public Object internalLoad(String entityName, Serializable id, boolean eager, boolean nullable) throws HibernateException {
        this.errorIfClosed();
        EntityPersister persister = this.getFactory().getEntityPersister(entityName);
        Object loaded = this.temporaryPersistenceContext.getEntity(this.generateEntityKey(id, persister));
        if (loaded != null) {
            return loaded;
        }
        if (!eager && persister.hasProxy()) {
            return persister.createProxy(id, this);
        }
        return this.get(entityName, id);
    }

    @Override
    public Iterator iterate(String query, QueryParameters queryParameters) throws HibernateException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator iterateFilter(Object collection, String filter, QueryParameters queryParameters) throws HibernateException {
        throw new UnsupportedOperationException();
    }

    @Override
    public List listFilter(Object collection, String filter, QueryParameters queryParameters) throws HibernateException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isOpen() {
        return !this.isClosed();
    }

    @Override
    public void close() {
        this.managedClose();
    }

    @Override
    public boolean isAutoCloseSessionEnabled() {
        return this.factory.getSettings().isAutoCloseSessionEnabled();
    }

    @Override
    public boolean shouldAutoClose() {
        return this.isAutoCloseSessionEnabled() && !this.isClosed();
    }

    private boolean isFlushModeNever() {
        return false;
    }

    private void managedClose() {
        if (this.isClosed()) {
            throw new SessionException("Session was already closed!");
        }
        this.jdbcCoordinator.close();
        this.setClosed();
    }

    private void managedFlush() {
        this.errorIfClosed();
        this.jdbcCoordinator.executeBatch();
    }

    @Override
    public SessionEventListenerManager getEventListenerManager() {
        if (this.sessionEventsManager == null) {
            this.sessionEventsManager = new SessionEventListenerManagerImpl();
        }
        return this.sessionEventsManager;
    }

    @Override
    public String bestGuessEntityName(Object object) {
        if (object instanceof HibernateProxy) {
            object = ((HibernateProxy)object).getHibernateLazyInitializer().getImplementation();
        }
        return this.guessEntityName(object);
    }

    @Override
    public Connection connection() {
        this.errorIfClosed();
        return this.jdbcCoordinator.getLogicalConnection().getPhysicalConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate(String query, QueryParameters queryParameters) throws HibernateException {
        this.errorIfClosed();
        queryParameters.validateParameters();
        HQLQueryPlan plan = this.getHQLQueryPlan(query, false);
        boolean success = false;
        int result = 0;
        try {
            result = plan.performExecuteUpdate(queryParameters, this);
            success = true;
        }
        finally {
            this.afterOperation(success);
        }
        this.temporaryPersistenceContext.clear();
        return result;
    }

    @Override
    public CacheMode getCacheMode() {
        return CacheMode.IGNORE;
    }

    @Override
    public int getDontFlushFromFind() {
        return 0;
    }

    @Override
    public Serializable getContextEntityIdentifier(Object object) {
        this.errorIfClosed();
        return null;
    }

    public EntityMode getEntityMode() {
        return EntityMode.POJO;
    }

    @Override
    public EntityPersister getEntityPersister(String entityName, Object object) throws HibernateException {
        this.errorIfClosed();
        if (entityName == null) {
            return this.factory.getEntityPersister(this.guessEntityName(object));
        }
        return this.factory.getEntityPersister(entityName).getSubclassEntityPersister(object, this.getFactory());
    }

    @Override
    public Object getEntityUsingInterceptor(EntityKey key) throws HibernateException {
        this.errorIfClosed();
        return null;
    }

    @Override
    public FlushMode getFlushMode() {
        return FlushMode.COMMIT;
    }

    @Override
    public Interceptor getInterceptor() {
        return EmptyInterceptor.INSTANCE;
    }

    @Override
    public PersistenceContext getPersistenceContext() {
        return this.temporaryPersistenceContext;
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public String guessEntityName(Object entity) throws HibernateException {
        this.errorIfClosed();
        return entity.getClass().getName();
    }

    @Override
    public boolean isConnected() {
        return this.jdbcCoordinator.getLogicalConnection().isPhysicallyConnected();
    }

    @Override
    public boolean isTransactionInProgress() {
        return !this.isClosed() && this.transactionCoordinator.isJoined() && this.transactionCoordinator.getTransactionDriverControl().getStatus() == TransactionStatus.ACTIVE;
    }

    @Override
    public void setAutoClear(boolean enabled) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void disableTransactionAutoJoin() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setCacheMode(CacheMode cm) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setFlushMode(FlushMode fm) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Transaction beginTransaction() throws HibernateException {
        this.errorIfClosed();
        Transaction result = this.getTransaction();
        if (result.getStatus() != TransactionStatus.ACTIVE) {
            this.timestamp = this.factory.getSettings().getRegionFactory().nextTimestamp();
        }
        result.begin();
        return result;
    }

    @Override
    public boolean isEventSource() {
        return false;
    }

    public boolean isDefaultReadOnly() {
        return false;
    }

    public void setDefaultReadOnly(boolean readOnly) throws HibernateException {
        if (readOnly) {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List list(String query, QueryParameters queryParameters) throws HibernateException {
        this.errorIfClosed();
        queryParameters.validateParameters();
        HQLQueryPlan plan = this.getHQLQueryPlan(query, false);
        boolean success = false;
        List results = Collections.EMPTY_LIST;
        try {
            results = plan.performList(queryParameters, this);
            success = true;
        }
        finally {
            this.afterOperation(success);
        }
        this.temporaryPersistenceContext.clear();
        return results;
    }

    public void afterOperation(boolean success) {
        if (!this.isTransactionInProgress()) {
            this.jdbcCoordinator.afterTransaction();
        }
    }

    @Override
    public Criteria createCriteria(Class persistentClass, String alias) {
        this.errorIfClosed();
        return new CriteriaImpl(persistentClass.getName(), alias, this);
    }

    @Override
    public Criteria createCriteria(String entityName, String alias) {
        this.errorIfClosed();
        return new CriteriaImpl(entityName, alias, this);
    }

    @Override
    public Criteria createCriteria(Class persistentClass) {
        this.errorIfClosed();
        return new CriteriaImpl(persistentClass.getName(), this);
    }

    @Override
    public Criteria createCriteria(String entityName) {
        this.errorIfClosed();
        return new CriteriaImpl(entityName, this);
    }

    @Override
    public ScrollableResults scroll(Criteria criteria, ScrollMode scrollMode) {
        CriteriaImpl criteriaImpl = (CriteriaImpl)criteria;
        this.errorIfClosed();
        String entityName = criteriaImpl.getEntityOrClassName();
        CriteriaLoader loader = new CriteriaLoader(this.getOuterJoinLoadable(entityName), this.factory, criteriaImpl, entityName, this.getLoadQueryInfluencers());
        return loader.scroll(this, scrollMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List list(Criteria criteria) throws HibernateException {
        CriteriaImpl criteriaImpl = (CriteriaImpl)criteria;
        this.errorIfClosed();
        String[] implementors = this.factory.getImplementors(criteriaImpl.getEntityOrClassName());
        int size = implementors.length;
        CriteriaLoader[] loaders = new CriteriaLoader[size];
        for (int i = 0; i < size; ++i) {
            loaders[i] = new CriteriaLoader(this.getOuterJoinLoadable(implementors[i]), this.factory, criteriaImpl, implementors[i], this.getLoadQueryInfluencers());
        }
        List results = Collections.EMPTY_LIST;
        boolean success = false;
        try {
            for (int i = 0; i < size; ++i) {
                List currentResults = loaders[i].list(this);
                currentResults.addAll(results);
                results = currentResults;
            }
            success = true;
        }
        finally {
            this.afterOperation(success);
        }
        this.temporaryPersistenceContext.clear();
        return results;
    }

    private OuterJoinLoadable getOuterJoinLoadable(String entityName) throws MappingException {
        EntityPersister persister = this.factory.getEntityPersister(entityName);
        if (!(persister instanceof OuterJoinLoadable)) {
            throw new MappingException("class persister is not OuterJoinLoadable: " + entityName);
        }
        return (OuterJoinLoadable)persister;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List listCustomQuery(CustomQuery customQuery, QueryParameters queryParameters) throws HibernateException {
        List results;
        this.errorIfClosed();
        CustomLoader loader = new CustomLoader(customQuery, this.getFactory());
        boolean success = false;
        try {
            results = loader.list(this, queryParameters);
            success = true;
        }
        finally {
            this.afterOperation(success);
        }
        this.temporaryPersistenceContext.clear();
        return results;
    }

    @Override
    public ScrollableResults scrollCustomQuery(CustomQuery customQuery, QueryParameters queryParameters) throws HibernateException {
        this.errorIfClosed();
        CustomLoader loader = new CustomLoader(customQuery, this.getFactory());
        return loader.scroll(queryParameters, this);
    }

    @Override
    public ScrollableResults scroll(String query, QueryParameters queryParameters) throws HibernateException {
        this.errorIfClosed();
        HQLQueryPlan plan = this.getHQLQueryPlan(query, false);
        return plan.performScroll(queryParameters, this);
    }

    @Override
    public void afterScrollOperation() {
        this.temporaryPersistenceContext.clear();
    }

    @Override
    public void flush() {
    }

    @Override
    public LoadQueryInfluencers getLoadQueryInfluencers() {
        return this.statelessLoadQueryInfluencers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeNativeUpdate(NativeSQLQuerySpecification nativeSQLQuerySpecification, QueryParameters queryParameters) throws HibernateException {
        this.errorIfClosed();
        queryParameters.validateParameters();
        NativeSQLQueryPlan plan = this.getNativeSQLQueryPlan(nativeSQLQuerySpecification);
        boolean success = false;
        int result = 0;
        try {
            result = plan.performExecuteUpdate(queryParameters, this);
            success = true;
        }
        finally {
            this.afterOperation(success);
        }
        this.temporaryPersistenceContext.clear();
        return result;
    }

    @Override
    public JdbcSessionContext getJdbcSessionContext() {
        return this.jdbcSessionContext;
    }

    @Override
    public void afterTransactionBegin() {
    }

    @Override
    public void beforeTransactionCompletion() {
        this.flushBeforeTransactionCompletion();
    }

    @Override
    public void afterTransactionCompletion(boolean successful, boolean delayed) {
        if (this.shouldAutoClose() && !this.isClosed()) {
            this.managedClose();
        }
    }

    @Override
    public void flushBeforeTransactionCompletion() {
        boolean flush = false;
        try {
            flush = !this.isClosed() && !this.isFlushModeNever() && !JtaStatusHelper.isRollback(this.getJtaPlatform().getCurrentStatus());
        }
        catch (SystemException se) {
            throw new HibernateException("could not determine transaction status in beforeCompletion()", se);
        }
        if (flush) {
            this.managedFlush();
        }
    }

    private JtaPlatform getJtaPlatform() {
        return this.factory.getServiceRegistry().getService(JtaPlatform.class);
    }
}

