/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.internal;

import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import org.hibernate.engine.spi.SessionImplementor;

public class NonNullableTransientDependencies {
    private final Map<Object, Set<String>> propertyPathsByTransientEntity = new IdentityHashMap<Object, Set<String>>();

    void add(String propertyName, Object transientEntity) {
        Set<String> propertyPaths = this.propertyPathsByTransientEntity.get(transientEntity);
        if (propertyPaths == null) {
            propertyPaths = new HashSet<String>();
            this.propertyPathsByTransientEntity.put(transientEntity, propertyPaths);
        }
        propertyPaths.add(propertyName);
    }

    public Iterable<Object> getNonNullableTransientEntities() {
        return this.propertyPathsByTransientEntity.keySet();
    }

    public Iterable<String> getNonNullableTransientPropertyPaths(Object entity) {
        return this.propertyPathsByTransientEntity.get(entity);
    }

    public boolean isEmpty() {
        return this.propertyPathsByTransientEntity.isEmpty();
    }

    public void resolveNonNullableTransientEntity(Object entity) {
        if (this.propertyPathsByTransientEntity.remove(entity) == null) {
            throw new IllegalStateException("Attempt to resolve a non-nullable, transient entity that is not a dependency.");
        }
    }

    public String toLoggableString(SessionImplementor session) {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName()).append('[');
        for (Map.Entry<Object, Set<String>> entry : this.propertyPathsByTransientEntity.entrySet()) {
            sb.append("transientEntityName=").append(session.bestGuessEntityName(entry.getKey()));
            sb.append(" requiredBy=").append(entry.getValue());
        }
        sb.append(']');
        return sb.toString();
    }
}

