/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.sql;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.descriptor.sql.SqlTypeDescriptor;
import org.jboss.logging.Logger;

public abstract class BasicExtractor<J>
implements ValueExtractor<J> {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)BasicExtractor.class.getName());
    private final JavaTypeDescriptor<J> javaDescriptor;
    private final SqlTypeDescriptor sqlDescriptor;

    public BasicExtractor(JavaTypeDescriptor<J> javaDescriptor, SqlTypeDescriptor sqlDescriptor) {
        this.javaDescriptor = javaDescriptor;
        this.sqlDescriptor = sqlDescriptor;
    }

    public JavaTypeDescriptor<J> getJavaDescriptor() {
        return this.javaDescriptor;
    }

    public SqlTypeDescriptor getSqlDescriptor() {
        return this.sqlDescriptor;
    }

    @Override
    public J extract(ResultSet rs, String name, WrapperOptions options) throws SQLException {
        J value = this.doExtract(rs, name, options);
        if (value == null || rs.wasNull()) {
            LOG.trace("Found [null] as column [" + name + "]");
            return null;
        }
        LOG.trace("Found [" + this.getJavaDescriptor().extractLoggableRepresentation(value) + "] as column [" + name + "]");
        return value;
    }

    protected abstract J doExtract(ResultSet var1, String var2, WrapperOptions var3) throws SQLException;
}

