/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.service.internal.proxy.javassist;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javassist.util.proxy.MethodFilter;
import javassist.util.proxy.MethodHandler;
import javassist.util.proxy.ProxyFactory;
import javassist.util.proxy.ProxyObject;
import org.hibernate.service.Service;
import org.hibernate.service.internal.ServiceProxy;
import org.hibernate.service.internal.ServiceProxyGenerationException;
import org.hibernate.service.spi.proxy.ServiceProxyFactory;
import org.hibernate.service.spi.proxy.ServiceProxyTargetSource;

public class ServiceProxyFactoryImpl
implements ServiceProxyFactory {
    private final ServiceProxyTargetSource serviceRegistry;
    private static final MethodFilter FINALIZE_FILTER = new MethodFilter(){

        public boolean isHandled(Method m) {
            return m.getParameterTypes().length != 0 || !m.getName().equals("finalize");
        }
    };

    public ServiceProxyFactoryImpl(ServiceProxyTargetSource serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    @Override
    public <T extends Service> T makeProxy(Class<T> serviceRole) {
        try {
            ProxyFactory factory = new ProxyFactory();
            factory.setFilter(FINALIZE_FILTER);
            Class[] interfaces = new Class[]{serviceRole, ServiceProxy.class};
            factory.setInterfaces(interfaces);
            Class proxyClass = factory.createClass();
            ProxyObject proxyObject = (ProxyObject)proxyClass.newInstance();
            proxyObject.setHandler(new ServiceProxyMethodInterceptor((Service)proxyObject, serviceRole, this.serviceRegistry, null));
            return (T)((Service)proxyObject);
        }
        catch (Exception e) {
            throw new ServiceProxyGenerationException("Unable to make service proxy", e);
        }
    }

    private static class ServiceProxyMethodInterceptor<T extends Service>
    implements MethodHandler {
        private final T proxy;
        private final Class<T> serviceRole;
        private final ServiceProxyTargetSource serviceRegistry;

        private ServiceProxyMethodInterceptor(T proxy, Class<T> serviceRole, ServiceProxyTargetSource serviceRegistry) {
            this.proxy = proxy;
            this.serviceRole = serviceRole;
            this.serviceRegistry = serviceRegistry;
        }

        public Object invoke(Object object, Method method, Method method1, Object[] args) throws Exception {
            String name = method.getName();
            if ("toString".equals(name)) {
                return this.serviceRole.getName() + "_$$_Proxy@" + System.identityHashCode(object);
            }
            if ("equals".equals(name)) {
                return this.proxy == object ? Boolean.TRUE : Boolean.FALSE;
            }
            if ("hashCode".equals(name)) {
                return System.identityHashCode(object);
            }
            if ("getTargetInstance".equals(name) && ServiceProxy.class.equals(method.getDeclaringClass())) {
                return this.serviceRegistry.getServiceInternal(this.serviceRole);
            }
            try {
                T target = this.serviceRegistry.getServiceInternal(this.serviceRole);
                return method.invoke(target, args);
            }
            catch (InvocationTargetException e) {
                throw (Exception)e.getTargetException();
            }
        }

        /* synthetic */ ServiceProxyMethodInterceptor(Service x0, Class x1, ServiceProxyTargetSource x2, 1 x3) {
            this(x0, x1, x2);
        }
    }
}

