/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.service.internal;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.cfg.Configuration;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.service.Service;
import org.hibernate.service.StandardSessionFactoryServiceInitiators;
import org.hibernate.service.UnknownServiceException;
import org.hibernate.service.internal.AbstractServiceRegistryImpl;
import org.hibernate.service.spi.ServiceException;
import org.hibernate.service.spi.ServiceRegistryAwareService;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.service.spi.SessionFactoryServiceInitiator;
import org.hibernate.service.spi.SessionFactoryServiceRegistry;
import org.jboss.logging.Logger;

public class SessionFactoryServiceRegistryImpl
extends AbstractServiceRegistryImpl
implements SessionFactoryServiceRegistry {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)SessionFactoryServiceRegistryImpl.class.getName());
    private final Map<Class, SessionFactoryServiceInitiator> serviceInitiatorMap = SessionFactoryServiceRegistryImpl.toMap(StandardSessionFactoryServiceInitiators.LIST);
    private Configuration configuration;
    private final SessionFactoryImplementor sessionFactory;

    public SessionFactoryServiceRegistryImpl(ServiceRegistryImplementor parent, SessionFactoryImplementor sessionFactory, Configuration configuration) {
        super(parent);
        this.sessionFactory = sessionFactory;
        this.configuration = configuration;
        for (SessionFactoryServiceInitiator initiator : this.serviceInitiatorMap.values()) {
            this.createServiceBinding(initiator.getServiceInitiated());
        }
    }

    private static Map<Class, SessionFactoryServiceInitiator> toMap(List<SessionFactoryServiceInitiator> serviceInitiators) {
        HashMap<Class, SessionFactoryServiceInitiator> result = new HashMap<Class, SessionFactoryServiceInitiator>();
        for (SessionFactoryServiceInitiator initiator : serviceInitiators) {
            result.put(initiator.getServiceInitiated(), initiator);
        }
        return result;
    }

    @Override
    public void registerServiceInitiator(SessionFactoryServiceInitiator initiator) {
        ServiceRegistryImplementor.ServiceBinding<Object> serviceBinding = this.locateServiceBinding(initiator.getServiceInitiated(), false);
        if (serviceBinding != null) {
            serviceBinding.setTarget(null);
        } else {
            this.createServiceBinding(initiator.getServiceInitiated());
        }
        SessionFactoryServiceInitiator previous = this.serviceInitiatorMap.put(initiator.getServiceInitiated(), initiator);
        if (previous != null) {
            LOG.debugf("Over-wrote existing service initiator [role=%s]", initiator.getServiceInitiated().getName());
        }
    }

    @Override
    protected <T extends Service> T createService(Class<T> serviceRole) {
        SessionFactoryServiceInitiator initiator = this.serviceInitiatorMap.get(serviceRole);
        if (initiator == null) {
            throw new UnknownServiceException(serviceRole);
        }
        try {
            Object service = initiator.initiateService(this.sessionFactory, this.configuration, this);
            this.registerService(serviceRole, service);
            return (T)service;
        }
        catch (ServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServiceException("Unable to create requested service [" + serviceRole.getName() + "]", e);
        }
    }

    @Override
    protected <T extends Service> void configureService(T service) {
        this.applyInjections(service);
        if (ServiceRegistryAwareService.class.isInstance(service)) {
            ((ServiceRegistryAwareService)((Object)service)).injectServices(this);
        }
    }
}

