/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.service.internal;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.service.BasicServiceRegistry;
import org.hibernate.service.Service;
import org.hibernate.service.UnknownServiceException;
import org.hibernate.service.internal.AbstractServiceRegistryImpl;
import org.hibernate.service.internal.ProvidedService;
import org.hibernate.service.spi.BasicServiceInitiator;
import org.hibernate.service.spi.Configurable;
import org.hibernate.service.spi.ServiceException;
import org.hibernate.service.spi.ServiceRegistryAwareService;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.jboss.logging.Logger;

public class BasicServiceRegistryImpl
extends AbstractServiceRegistryImpl
implements BasicServiceRegistry {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)BasicServiceRegistryImpl.class.getName());
    private final Map<Class, BasicServiceInitiator> serviceInitiatorMap;
    private final Map configurationValues;

    public BasicServiceRegistryImpl(List<BasicServiceInitiator> serviceInitiators, List<ProvidedService> providedServices, Map configurationValues) {
        this.configurationValues = configurationValues;
        this.serviceInitiatorMap = BasicServiceRegistryImpl.toMap(serviceInitiators);
        for (BasicServiceInitiator initiator : this.serviceInitiatorMap.values()) {
            this.createServiceBinding(initiator.getServiceInitiated());
        }
        for (ProvidedService providedService : providedServices) {
            ServiceRegistryImplementor.ServiceBinding binding = this.locateOrCreateServiceBinding(providedService.getServiceRole(), false);
            binding.setTarget(providedService.getService());
        }
    }

    private static Map<Class, BasicServiceInitiator> toMap(List<BasicServiceInitiator> serviceInitiators) {
        HashMap<Class, BasicServiceInitiator> result = new HashMap<Class, BasicServiceInitiator>();
        for (BasicServiceInitiator initiator : serviceInitiators) {
            result.put(initiator.getServiceInitiated(), initiator);
        }
        return result;
    }

    @Override
    public void registerServiceInitiator(BasicServiceInitiator initiator) {
        ServiceRegistryImplementor.ServiceBinding<Object> serviceBinding = this.locateServiceBinding(initiator.getServiceInitiated(), false);
        if (serviceBinding != null) {
            serviceBinding.setTarget(null);
        } else {
            this.createServiceBinding(initiator.getServiceInitiated());
        }
        BasicServiceInitiator previous = this.serviceInitiatorMap.put(initiator.getServiceInitiated(), initiator);
        if (previous != null) {
            LOG.debugf("Over-wrote existing service initiator [role=%s]", initiator.getServiceInitiated().getName());
        }
    }

    @Override
    protected <T extends Service> T createService(Class<T> serviceRole) {
        BasicServiceInitiator initiator = this.serviceInitiatorMap.get(serviceRole);
        if (initiator == null) {
            throw new UnknownServiceException(serviceRole);
        }
        try {
            Object service = initiator.initiateService(this.configurationValues, this);
            this.registerService(serviceRole, service);
            return (T)service;
        }
        catch (ServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServiceException("Unable to create requested service [" + serviceRole.getName() + "]", e);
        }
    }

    @Override
    protected <T extends Service> void configureService(T service) {
        this.applyInjections(service);
        if (ServiceRegistryAwareService.class.isInstance(service)) {
            ((ServiceRegistryAwareService)((Object)service)).injectServices(this);
        }
        if (Configurable.class.isInstance(service)) {
            ((Configurable)((Object)service)).configure(this.configurationValues);
        }
    }
}

