/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.service.internal;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.ConcurrentHashMap;
import org.hibernate.HibernateException;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.service.Service;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.UnknownServiceException;
import org.hibernate.service.internal.ServiceDependencyException;
import org.hibernate.service.internal.proxy.javassist.ServiceProxyFactoryFactoryImpl;
import org.hibernate.service.jmx.spi.JmxService;
import org.hibernate.service.spi.InjectService;
import org.hibernate.service.spi.Manageable;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.service.spi.Startable;
import org.hibernate.service.spi.Stoppable;
import org.hibernate.service.spi.proxy.ServiceProxyFactory;
import org.jboss.logging.Logger;

public abstract class AbstractServiceRegistryImpl
implements ServiceRegistryImplementor {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)AbstractServiceRegistryImpl.class.getName());
    private final ServiceRegistryImplementor parent;
    private ServiceProxyFactory serviceProxyFactory = new ServiceProxyFactoryFactoryImpl().makeServiceProxyFactory(this);
    private ConcurrentHashMap<Class, ServiceRegistryImplementor.ServiceBinding> serviceBindingMap;
    private List<Service> serviceList = new ArrayList<Service>();

    protected AbstractServiceRegistryImpl() {
        this(null);
    }

    protected AbstractServiceRegistryImpl(ServiceRegistryImplementor parent) {
        this.parent = parent;
        this.serviceBindingMap = CollectionHelper.concurrentMap(20);
        this.serviceList = CollectionHelper.arrayList(20);
    }

    @Override
    public ServiceRegistry getParentServiceRegistry() {
        return this.parent;
    }

    @Override
    public <R extends Service> ServiceRegistryImplementor.ServiceBinding<R> locateServiceBinding(Class<R> serviceRole) {
        return this.locateServiceBinding(serviceRole, true);
    }

    protected <R extends Service> ServiceRegistryImplementor.ServiceBinding<R> locateServiceBinding(Class<R> serviceRole, boolean checkParent) {
        ServiceRegistryImplementor.ServiceBinding<R> serviceBinding = this.serviceBindingMap.get(serviceRole);
        if (serviceBinding == null && checkParent && this.parent != null) {
            serviceBinding = this.parent.locateServiceBinding(serviceRole);
        }
        return serviceBinding;
    }

    @Override
    public <R extends Service> R getService(Class<R> serviceRole) {
        return (R)((Service)this.locateOrCreateServiceBinding(serviceRole, true).getProxy());
    }

    protected <R extends Service> ServiceRegistryImplementor.ServiceBinding<R> locateOrCreateServiceBinding(Class<R> serviceRole, boolean checkParent) {
        ServiceRegistryImplementor.ServiceBinding<R> serviceBinding = this.locateServiceBinding(serviceRole, checkParent);
        if (serviceBinding == null) {
            this.createServiceBinding(serviceRole);
        }
        return serviceBinding;
    }

    protected <R extends Service> ServiceRegistryImplementor.ServiceBinding<R> createServiceBinding(Class<R> serviceRole) {
        R proxy = this.serviceProxyFactory.makeProxy(serviceRole);
        ServiceRegistryImplementor.ServiceBinding<R> serviceBinding = new ServiceRegistryImplementor.ServiceBinding<R>(proxy);
        this.serviceBindingMap.put(serviceRole, serviceBinding);
        return serviceBinding;
    }

    protected <R extends Service> void registerService(Class<R> serviceRole, R service) {
        ServiceRegistryImplementor.ServiceBinding<R> serviceBinding = this.locateOrCreateServiceBinding(serviceRole, false);
        Service priorServiceInstance = (Service)serviceBinding.getTarget();
        serviceBinding.setTarget(service);
        if (priorServiceInstance != null) {
            this.serviceList.remove(priorServiceInstance);
        }
        this.serviceList.add(service);
    }

    private <R extends Service> R initializeService(Class<R> serviceRole) {
        LOG.trace("Initializing service [role=" + serviceRole.getName() + "]");
        R service = this.createService(serviceRole);
        if (service == null) {
            return null;
        }
        this.configureService((Service)service);
        this.startService((Service)service, serviceRole);
        return service;
    }

    protected abstract <T extends Service> T createService(Class<T> var1);

    protected abstract <T extends Service> void configureService(T var1);

    protected <T extends Service> void applyInjections(T service) {
        try {
            for (Method method : service.getClass().getMethods()) {
                InjectService injectService = method.getAnnotation(InjectService.class);
                if (injectService == null) continue;
                this.applyInjection(service, method, injectService);
            }
        }
        catch (NullPointerException e) {
            LOG.error("NPE injecting service deps : " + service.getClass().getName());
        }
    }

    private <T extends Service> void applyInjection(T service, Method injectionMethod, InjectService injectService) {
        Object dependantService;
        if (injectionMethod.getParameterTypes() == null || injectionMethod.getParameterTypes().length != 1) {
            throw new ServiceDependencyException("Encountered @InjectService on method with unexpected number of parameters");
        }
        Class<?> dependentServiceRole = injectService.serviceRole();
        if (dependentServiceRole == null || dependentServiceRole.equals(Void.class)) {
            dependentServiceRole = injectionMethod.getParameterTypes()[0];
        }
        if ((dependantService = this.getService(dependentServiceRole)) == null) {
            if (injectService.required()) {
                throw new ServiceDependencyException("Dependency [" + dependentServiceRole + "] declared by service [" + service + "] not found");
            }
        } else {
            try {
                injectionMethod.invoke(service, dependantService);
            }
            catch (Exception e) {
                throw new ServiceDependencyException("Cannot inject dependency service", e);
            }
        }
    }

    protected <T extends Service> void startService(T service, Class serviceRole) {
        if (Startable.class.isInstance(service)) {
            ((Startable)((Object)service)).start();
        }
        if (Manageable.class.isInstance(service)) {
            this.getService(JmxService.class).registerService((Manageable)((Object)service), serviceRole);
        }
    }

    @Override
    public <R extends Service> R getServiceInternal(Class<R> serviceRole) {
        ServiceRegistryImplementor.ServiceBinding<Service> serviceBinding = this.locateServiceBinding(serviceRole, false);
        if (serviceBinding == null) {
            throw new HibernateException("Only proxies should invoke #getServiceInternal");
        }
        Service service = (Service)serviceBinding.getTarget();
        if (service == null) {
            service = this.initializeService(serviceRole);
            serviceBinding.setTarget(service);
        }
        if (service == null) {
            throw new UnknownServiceException(serviceRole);
        }
        return (R)service;
    }

    @Override
    public void destroy() {
        ListIterator<Service> serviceIterator = this.serviceList.listIterator(this.serviceList.size());
        while (serviceIterator.hasPrevious()) {
            Service service = serviceIterator.previous();
            if (!Stoppable.class.isInstance(service)) continue;
            try {
                ((Stoppable)((Object)service)).stop();
            }
            catch (Exception e) {
                LOG.unableToStopService(service.getClass(), e.toString());
            }
        }
        this.serviceList.clear();
        this.serviceList = null;
        this.serviceBindingMap.clear();
        this.serviceBindingMap = null;
    }
}

