/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.util;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.dom4j.Element;
import org.hibernate.internal.util.ReflectHelper;

public class MappingHelper {
    private MappingHelper() {
    }

    public static String extractAttributeValue(Element element, String attributeName) {
        return MappingHelper.extractAttributeValue(element, attributeName, null);
    }

    public static String extractAttributeValue(Element element, String attributeName, String defaultValue) {
        String attributeValue = element == null ? null : element.attributeValue(attributeName);
        return attributeValue == null ? defaultValue : attributeValue;
    }

    public static String getStringValue(String value, String defaultValue) {
        return value == null ? defaultValue : value;
    }

    public static int extractIntAttributeValue(Element element, String attributeName) {
        return MappingHelper.extractIntAttributeValue(element, attributeName, -1);
    }

    public static int extractIntAttributeValue(Element element, String attributeName, int defaultValue) {
        String attributeValue = element == null ? null : element.attributeValue(attributeName);
        return attributeValue == null ? defaultValue : Integer.valueOf(attributeValue);
    }

    public static int getIntValue(String value, int defaultValue) {
        return value == null ? defaultValue : Integer.parseInt(value);
    }

    public static boolean extractBooleanAttributeValue(Element element, String attributeName) {
        return MappingHelper.extractBooleanAttributeValue(element, attributeName, false);
    }

    public static boolean extractBooleanAttributeValue(Element element, String attributeName, boolean defaultValue) {
        String attributeValue = element == null ? null : element.attributeValue(attributeName);
        return attributeValue == null ? defaultValue : Boolean.valueOf(attributeValue);
    }

    public static boolean getBooleanValue(String value, boolean defaultValue) {
        return value == null ? defaultValue : Boolean.valueOf(value);
    }

    public static boolean getBooleanValue(Boolean value, boolean defaultValue) {
        return value == null ? defaultValue : value;
    }

    public static Class extractClassAttributeValue(Element element, String attributeName) throws ClassNotFoundException {
        String attributeValue = element == null ? null : element.attributeValue(attributeName);
        return attributeValue == null ? null : ReflectHelper.classForName(attributeValue);
    }

    public static Class getClassValue(String className) throws ClassNotFoundException {
        return className == null ? null : ReflectHelper.classForName(className);
    }

    public static Set<String> getStringValueTokens(String str, String delimiters) {
        if (str == null) {
            return Collections.emptySet();
        }
        StringTokenizer tokenizer = new StringTokenizer(str, delimiters);
        HashSet<String> tokens = new HashSet<String>();
        while (tokenizer.hasMoreTokens()) {
            tokens.add(tokenizer.nextToken());
        }
        return tokens;
    }
}

