/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.util;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.dom4j.Element;
import org.hibernate.internal.util.ReflectHelper;

public class DomHelper {
    private DomHelper() {
    }

    public static String extractAttributeValue(Element element, String attributeName) {
        return DomHelper.extractAttributeValue(element, attributeName, null);
    }

    public static String extractAttributeValue(Element element, String attributeName, String defaultValue) {
        String attributeValue = element == null ? null : element.attributeValue(attributeName);
        return attributeValue == null ? defaultValue : attributeValue;
    }

    public static int extractIntAttributeValue(Element element, String attributeName) {
        return DomHelper.extractIntAttributeValue(element, attributeName, -1);
    }

    public static int extractIntAttributeValue(Element element, String attributeName, int defaultValue) {
        String attributeValue = element == null ? null : element.attributeValue(attributeName);
        return attributeValue == null ? defaultValue : Integer.valueOf(attributeValue);
    }

    public static boolean extractBooleanAttributeValue(Element element, String attributeName) {
        return DomHelper.extractBooleanAttributeValue(element, attributeName, false);
    }

    public static boolean extractBooleanAttributeValue(Element element, String attributeName, boolean defaultValue) {
        String attributeValue = element == null ? null : element.attributeValue(attributeName);
        return attributeValue == null ? defaultValue : Boolean.valueOf(attributeValue);
    }

    public static Class extractClassAttributeValue(Element element, String attributeName) throws ClassNotFoundException {
        String attributeValue = element == null ? null : element.attributeValue(attributeName);
        return attributeValue == null ? null : ReflectHelper.classForName(attributeValue);
    }

    public static Set<String> extractUniqueAttributeValueTokens(Element element, String attributeName, String delimiters) {
        String attributeValue = element.attributeValue(attributeName);
        if (attributeValue == null) {
            return Collections.emptySet();
        }
        StringTokenizer tokenizer = new StringTokenizer(attributeValue, delimiters);
        HashSet<String> tokens = new HashSet<String>();
        while (tokenizer.hasMoreTokens()) {
            tokens.add(tokenizer.nextToken());
        }
        return tokens;
    }
}

