/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.DuplicateMappingException;
import org.hibernate.HibernateException;
import org.hibernate.cfg.NamingStrategy;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.mapping.MetadataSource;
import org.hibernate.metamodel.Metadata;
import org.hibernate.metamodel.MetadataSources;
import org.hibernate.metamodel.SourceProcessingOrder;
import org.hibernate.metamodel.binding.EntityBinding;
import org.hibernate.metamodel.binding.FetchProfile;
import org.hibernate.metamodel.binding.PluralAttributeBinding;
import org.hibernate.metamodel.relational.Database;
import org.hibernate.metamodel.source.annotation.xml.XMLEntityMappings;
import org.hibernate.metamodel.source.annotations.AnnotationBinder;
import org.hibernate.metamodel.source.annotations.xml.OrmXmlParser;
import org.hibernate.metamodel.source.hbm.HibernateXmlBinder;
import org.hibernate.metamodel.source.hbm.xml.mapping.XMLHibernateMapping;
import org.hibernate.metamodel.source.internal.EntityReferenceResolver;
import org.hibernate.metamodel.source.internal.JaxbRoot;
import org.hibernate.metamodel.source.internal.MetadataBuilderImpl;
import org.hibernate.metamodel.source.spi.MetadataImplementor;
import org.hibernate.service.BasicServiceRegistry;
import org.hibernate.service.classloading.spi.ClassLoaderService;
import org.jboss.jandex.Index;
import org.jboss.jandex.Indexer;
import org.jboss.logging.Logger;

public class MetadataImpl
implements Metadata,
MetadataImplementor,
Serializable {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)MetadataImpl.class.getName());
    private final BasicServiceRegistry serviceRegistry;
    private final NamingStrategy namingStrategy;
    private final Database database = new Database();
    private Map<String, EntityBinding> entityBindingMap = new HashMap<String, EntityBinding>();
    private Map<String, PluralAttributeBinding> collectionBindingMap = new HashMap<String, PluralAttributeBinding>();
    private Map<String, FetchProfile> fetchProfiles = new HashMap<String, FetchProfile>();
    private Map<String, String> imports;

    public MetadataImpl(MetadataBuilderImpl builder) {
        MetadataSources metadataSources = builder.getSources();
        this.serviceRegistry = metadataSources.getServiceRegistry();
        this.namingStrategy = builder.getNamingStrategy();
        ArrayList<String> processedEntityNames = new ArrayList<String>();
        if (builder.getSourceProcessingOrder() == SourceProcessingOrder.HBM_FIRST) {
            this.applyHibernateMappings(metadataSources, processedEntityNames);
            this.applyAnnotationMappings(metadataSources, processedEntityNames);
        } else {
            this.applyAnnotationMappings(metadataSources, processedEntityNames);
            this.applyHibernateMappings(metadataSources, processedEntityNames);
        }
        new EntityReferenceResolver(this).resolve();
    }

    private void applyHibernateMappings(MetadataSources metadataSources, List<String> processedEntityNames) {
        HibernateXmlBinder hibernateXmlBinder = new HibernateXmlBinder(this);
        for (JaxbRoot jaxbRoot : metadataSources.getJaxbRootList()) {
            if (!(jaxbRoot.getRoot() instanceof XMLHibernateMapping)) continue;
            hibernateXmlBinder.bindRoot(jaxbRoot);
        }
    }

    private void applyAnnotationMappings(MetadataSources metadataSources, List<String> processedEntityNames) {
        Indexer indexer = new Indexer();
        for (Class<?> clazz : metadataSources.getAnnotatedClasses()) {
            this.indexClass(indexer, clazz.getName().replace('.', '/') + ".class");
        }
        for (String packageName : metadataSources.getAnnotatedPackages()) {
            this.indexClass(indexer, packageName.replace('.', '/') + "/package-info.class");
        }
        Index index = indexer.complete();
        OrmXmlParser ormParser = new OrmXmlParser(this);
        ArrayList<JaxbRoot<XMLEntityMappings>> mappings = new ArrayList<JaxbRoot<XMLEntityMappings>>();
        for (JaxbRoot root : metadataSources.getJaxbRootList()) {
            if (!(root.getRoot() instanceof XMLEntityMappings)) continue;
            mappings.add(root);
        }
        index = ormParser.parseAndUpdateIndex(mappings, index);
        AnnotationBinder annotationBinder = new AnnotationBinder(this);
        annotationBinder.bindGlobalAnnotations(index);
        annotationBinder.bindMappedClasses(index);
    }

    private void indexClass(Indexer indexer, String className) {
        ClassLoaderService classLoaderService = this.serviceRegistry.getService(ClassLoaderService.class);
        InputStream stream = classLoaderService.locateResourceStream(className);
        try {
            indexer.index(stream);
        }
        catch (IOException e) {
            throw new HibernateException("Unable to open input stream for class " + className, e);
        }
    }

    @Override
    public BasicServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }

    @Override
    public Database getDatabase() {
        return this.database;
    }

    public NamingStrategy getNamingStrategy() {
        return this.namingStrategy;
    }

    @Override
    public EntityBinding getEntityBinding(String entityName) {
        return this.entityBindingMap.get(entityName);
    }

    @Override
    public Iterable<EntityBinding> getEntityBindings() {
        return this.entityBindingMap.values();
    }

    public void addEntity(EntityBinding entityBinding) {
        String entityName = entityBinding.getEntity().getName();
        if (this.entityBindingMap.containsKey(entityName)) {
            throw new DuplicateMappingException(DuplicateMappingException.Type.ENTITY, entityName);
        }
        this.entityBindingMap.put(entityName, entityBinding);
    }

    public PluralAttributeBinding getCollection(String collectionRole) {
        return this.collectionBindingMap.get(collectionRole);
    }

    public Iterable<PluralAttributeBinding> getCollections() {
        return this.collectionBindingMap.values();
    }

    public void addCollection(PluralAttributeBinding pluralAttributeBinding) {
        String owningEntityName = pluralAttributeBinding.getEntityBinding().getEntity().getName();
        String attributeName = pluralAttributeBinding.getAttribute().getName();
        String collectionRole = owningEntityName + '.' + attributeName;
        if (this.collectionBindingMap.containsKey(collectionRole)) {
            throw new DuplicateMappingException(DuplicateMappingException.Type.ENTITY, collectionRole);
        }
        this.collectionBindingMap.put(collectionRole, pluralAttributeBinding);
    }

    public void addImport(String importName, String entityName) {
        if (this.imports == null) {
            this.imports = new HashMap<String, String>();
        }
        LOG.trace("Import: " + importName + " -> " + entityName);
        String old = this.imports.put(importName, entityName);
        if (old != null) {
            LOG.debug("import name [" + importName + "] overrode previous [{" + old + "}]");
        }
    }

    public Iterable<FetchProfile> getFetchProfiles() {
        return this.fetchProfiles.values();
    }

    public FetchProfile findOrCreateFetchProfile(String profileName, MetadataSource source) {
        FetchProfile profile = this.fetchProfiles.get(profileName);
        if (profile == null) {
            profile = new FetchProfile(profileName, source);
            this.fetchProfiles.put(profileName, profile);
        }
        return profile;
    }
}

