/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.internal;

import org.hibernate.cfg.EJB3NamingStrategy;
import org.hibernate.cfg.NamingStrategy;
import org.hibernate.metamodel.Metadata;
import org.hibernate.metamodel.MetadataBuilder;
import org.hibernate.metamodel.MetadataSources;
import org.hibernate.metamodel.SourceProcessingOrder;
import org.hibernate.metamodel.source.internal.MetadataImpl;

public class MetadataBuilderImpl
implements MetadataBuilder {
    private final MetadataSources sources;
    private NamingStrategy namingStrategy = EJB3NamingStrategy.INSTANCE;
    private SourceProcessingOrder sourceProcessingOrder = SourceProcessingOrder.HBM_FIRST;

    public MetadataBuilderImpl(MetadataSources sources) {
        this.sources = sources;
    }

    public MetadataSources getSources() {
        return this.sources;
    }

    public NamingStrategy getNamingStrategy() {
        return this.namingStrategy;
    }

    public SourceProcessingOrder getSourceProcessingOrder() {
        return this.sourceProcessingOrder;
    }

    @Override
    public MetadataBuilder with(NamingStrategy namingStrategy) {
        this.namingStrategy = namingStrategy;
        return this;
    }

    @Override
    public MetadataBuilder with(SourceProcessingOrder sourceProcessingOrder) {
        this.sourceProcessingOrder = sourceProcessingOrder;
        return this;
    }

    @Override
    public Metadata buildMetadata() {
        return new MetadataImpl(this);
    }
}

