/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.internal;

import org.hibernate.MappingException;
import org.hibernate.metamodel.binding.AttributeBinding;
import org.hibernate.metamodel.binding.EntityBinding;
import org.hibernate.metamodel.binding.EntityReferencingAttributeBinding;
import org.hibernate.metamodel.source.spi.MetadataImplementor;

class EntityReferenceResolver {
    private final MetadataImplementor metadata;

    EntityReferenceResolver(MetadataImplementor metadata) {
        this.metadata = metadata;
    }

    void resolve() {
        for (EntityBinding entityBinding : this.metadata.getEntityBindings()) {
            for (EntityReferencingAttributeBinding attributeBinding : entityBinding.getEntityReferencingAttributeBindings()) {
                this.resolve(attributeBinding);
            }
        }
    }

    private void resolve(EntityReferencingAttributeBinding attributeBinding) {
        AttributeBinding referencedAttributeBinding;
        if (attributeBinding.getReferencedEntityName() == null) {
            throw new IllegalArgumentException("attributeBinding has null entityName: " + attributeBinding.getAttribute().getName());
        }
        EntityBinding entityBinding = this.metadata.getEntityBinding(attributeBinding.getReferencedEntityName());
        if (entityBinding == null) {
            throw new MappingException("Attribute [" + attributeBinding.getAttribute().getName() + "] refers to unknown entity: [" + attributeBinding.getReferencedEntityName() + "]");
        }
        AttributeBinding attributeBinding2 = referencedAttributeBinding = attributeBinding.isPropertyReference() ? entityBinding.getAttributeBinding(attributeBinding.getReferencedAttributeName()) : entityBinding.getEntityIdentifier().getValueBinding();
        if (referencedAttributeBinding == null) {
            throw new MappingException("Attribute [" + attributeBinding.getAttribute().getName() + "] refers to unknown attribute: [" + attributeBinding.getReferencedEntityName() + "]");
        }
        attributeBinding.resolveReference(referencedAttributeBinding);
        referencedAttributeBinding.addEntityReferencingAttributeBinding(attributeBinding);
    }
}

