/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.hbm.state.relational;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.hibernate.MappingException;
import org.hibernate.cfg.NamingStrategy;
import org.hibernate.metamodel.binding.AttributeBinding;
import org.hibernate.metamodel.binding.HibernateTypeDescriptor;
import org.hibernate.metamodel.binding.MappingDefaults;
import org.hibernate.metamodel.source.hbm.state.relational.HbmColumnRelationalState;
import org.hibernate.metamodel.source.hbm.state.relational.HbmDerivedValueRelationalState;
import org.hibernate.metamodel.source.hbm.xml.mapping.XMLColumnElement;
import org.hibernate.metamodel.source.hbm.xml.mapping.XMLHibernateMapping;
import org.hibernate.metamodel.source.hbm.xml.mapping.XMLManyToOneElement;
import org.hibernate.metamodel.source.hbm.xml.mapping.XMLPropertyElement;

public class HbmSimpleValueRelationalStateContainer
implements AttributeBinding.SimpleTupleRelationalState {
    private final MappingDefaults defaults;
    private final Set<String> propertyUniqueKeys;
    private final Set<String> propertyIndexes;
    private final List<AttributeBinding.SingleValueRelationalState> singleValueStates;
    private final HibernateTypeDescriptor hibernateTypeDescriptor = new HibernateTypeDescriptor();

    public NamingStrategy getNamingStrategy() {
        return this.defaults.getNamingStrategy();
    }

    public HbmSimpleValueRelationalStateContainer(MappingDefaults defaults, boolean autoColumnCreation, XMLHibernateMapping.XMLClass.XMLId id) {
        this(defaults, id.getColumn());
        if (this.singleValueStates.isEmpty()) {
            if (id.getColumn() == null && !autoColumnCreation) {
                throw new MappingException("No columns to map and auto column creation is disabled.");
            }
            this.singleValueStates.add(new HbmColumnRelationalState(id, this));
        } else if (id.getColumn() != null) {
            throw new MappingException("column attribute may not be used together with <column> subelement");
        }
        this.hibernateTypeDescriptor.setTypeName(id.getTypeAttribute());
    }

    public HbmSimpleValueRelationalStateContainer(MappingDefaults defaults, boolean autoColumnCreation, XMLHibernateMapping.XMLClass.XMLDiscriminator discriminator) {
        this(defaults, discriminator.getFormula(), discriminator.getColumn());
        if (this.singleValueStates.isEmpty()) {
            if (discriminator.getColumn() == null && discriminator.getFormula() == null && !autoColumnCreation) {
                throw new MappingException("No column or formula to map and auto column creation is disabled.");
            }
            this.singleValueStates.add(new HbmColumnRelationalState(discriminator, this));
        } else if (discriminator.getColumn() != null || discriminator.getFormula() != null) {
            throw new MappingException("column/formula attribute may not be used together with <column>/<formula> subelement");
        }
        this.hibernateTypeDescriptor.setTypeName(discriminator.getType() == null ? "string" : discriminator.getType());
    }

    public HbmSimpleValueRelationalStateContainer(MappingDefaults defaults, boolean autoColumnCreation, XMLHibernateMapping.XMLClass.XMLVersion version) {
        this(defaults, version.getColumn());
        if (this.singleValueStates.isEmpty()) {
            if (version.getColumn() == null && !autoColumnCreation) {
                throw new MappingException("No column or formula to map and auto column creation is disabled.");
            }
            this.singleValueStates.add(new HbmColumnRelationalState(version, this));
        } else if (version.getColumn() != null) {
            throw new MappingException("column attribute may not be used together with <column> subelement");
        }
        this.hibernateTypeDescriptor.setTypeName(version.getType() == null ? "integer" : version.getType());
    }

    public HbmSimpleValueRelationalStateContainer(MappingDefaults defaults, boolean autoColumnCreation, XMLHibernateMapping.XMLClass.XMLTimestamp timestamp) {
        this(defaults, null);
        if (this.singleValueStates.isEmpty()) {
            if (timestamp.getColumn() == null && !autoColumnCreation) {
                throw new MappingException("No columns to map and auto column creation is disabled.");
            }
            this.singleValueStates.add(new HbmColumnRelationalState(timestamp, this));
        } else if (timestamp.getColumn() != null) {
            throw new MappingException("column attribute may not be used together with <column> subelement");
        }
        this.hibernateTypeDescriptor.setTypeName("db".equals(timestamp.getSource()) ? "dbtimestamp" : "timestamp");
    }

    public HbmSimpleValueRelationalStateContainer(MappingDefaults defaults, boolean autoColumnCreation, XMLPropertyElement property) {
        this(defaults, property.getColumnOrFormula());
        if (this.singleValueStates.isEmpty()) {
            if (property.getColumn() == null && property.getFormula() == null && !autoColumnCreation) {
                throw new MappingException("No column or formula to map and auto column creation is disabled.");
            }
            this.singleValueStates.add(new HbmColumnRelationalState(property, this));
        } else if (property.getColumn() != null || property.getFormula() != null) {
            throw new MappingException("column/formula attribute may not be used together with <column>/<formula> subelement");
        }
        this.hibernateTypeDescriptor.setTypeName(property.getTypeAttribute());
    }

    public HbmSimpleValueRelationalStateContainer(MappingDefaults defaults, boolean autoColumnCreation, XMLManyToOneElement manyToOne) {
        this(defaults, manyToOne.getColumnOrFormula());
        if (this.singleValueStates.isEmpty()) {
            if (manyToOne.getColumn() == null && manyToOne.getFormula() == null && !autoColumnCreation) {
                throw new MappingException("No column or formula to map and auto column creation is disabled.");
            }
            this.singleValueStates.add(new HbmColumnRelationalState(manyToOne, this));
        } else if (manyToOne.getColumn() != null || manyToOne.getFormula() != null) {
            throw new MappingException("column/formula attribute may not be used together with <column>/<formula> subelement");
        }
    }

    private HbmSimpleValueRelationalStateContainer(MappingDefaults defaults, String formulaElement, XMLColumnElement columnElement) {
        this(defaults, formulaElement != null ? Collections.singletonList(formulaElement) : (columnElement != null ? Collections.singletonList(columnElement) : Collections.emptyList()));
    }

    private HbmSimpleValueRelationalStateContainer(MappingDefaults defaults, List mappedColumnsOrFormulas) {
        this.defaults = defaults;
        this.propertyUniqueKeys = Collections.emptySet();
        this.propertyIndexes = Collections.emptySet();
        this.singleValueStates = new ArrayList<AttributeBinding.SingleValueRelationalState>(mappedColumnsOrFormulas == null || mappedColumnsOrFormulas.isEmpty() ? 1 : mappedColumnsOrFormulas.size());
        if (mappedColumnsOrFormulas != null && !mappedColumnsOrFormulas.isEmpty()) {
            for (Object mappedColumnOrFormula : mappedColumnsOrFormulas) {
                this.singleValueStates.add(HbmSimpleValueRelationalStateContainer.createColumnOrFormulaRelationalState(this, mappedColumnOrFormula));
            }
        }
    }

    private static AttributeBinding.SingleValueRelationalState createColumnOrFormulaRelationalState(HbmSimpleValueRelationalStateContainer container, Object columnOrFormula) {
        if (XMLColumnElement.class.isInstance(columnOrFormula)) {
            return new HbmColumnRelationalState((XMLColumnElement)XMLColumnElement.class.cast(columnOrFormula), container);
        }
        if (String.class.isInstance(columnOrFormula)) {
            return new HbmDerivedValueRelationalState((String)String.class.cast(columnOrFormula));
        }
        throw new MappingException("unknown type of column or formula: " + columnOrFormula.getClass().getName());
    }

    @Override
    public List<AttributeBinding.SingleValueRelationalState> getRelationalStates() {
        return this.singleValueStates;
    }

    Set<String> getPropertyUniqueKeys() {
        return this.propertyUniqueKeys;
    }

    Set<String> getPropertyIndexes() {
        return this.propertyIndexes;
    }
}

