/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.hbm.state.domain;

import java.util.Map;
import org.hibernate.MappingException;
import org.hibernate.mapping.PropertyGeneration;
import org.hibernate.metamodel.binding.HibernateTypeDescriptor;
import org.hibernate.metamodel.binding.MappingDefaults;
import org.hibernate.metamodel.binding.SimpleAttributeBinding;
import org.hibernate.metamodel.domain.Attribute;
import org.hibernate.metamodel.domain.MetaAttribute;
import org.hibernate.metamodel.source.hbm.HbmHelper;
import org.hibernate.metamodel.source.hbm.state.domain.AbstractHbmAttributeDomainState;
import org.hibernate.metamodel.source.hbm.xml.mapping.XMLHibernateMapping;
import org.hibernate.metamodel.source.hbm.xml.mapping.XMLPropertyElement;
import org.hibernate.metamodel.source.util.MappingHelper;

public class HbmSimpleAttributeDomainState
extends AbstractHbmAttributeDomainState
implements SimpleAttributeBinding.DomainState {
    private final HibernateTypeDescriptor hibernateTypeDescriptor = new HibernateTypeDescriptor();
    private final boolean isLazy;
    private final PropertyGeneration propertyGeneration;
    private final boolean isInsertable;
    private final boolean isUpdateable;

    public HbmSimpleAttributeDomainState(MappingDefaults defaults, Attribute attribute, Map<String, MetaAttribute> entityMetaAttributes, XMLHibernateMapping.XMLClass.XMLId id) {
        super(defaults, attribute, id.getNode(), HbmHelper.extractMetas(id.getMeta(), entityMetaAttributes), HbmHelper.getPropertyAccessorName(id.getAccess(), false, defaults.getDefaultAccess()), true);
        this.isLazy = false;
        if (id.getType() != null) {
            this.hibernateTypeDescriptor.setTypeName(id.getType().getName());
        }
        this.propertyGeneration = PropertyGeneration.parse(null);
        this.isInsertable = true;
        this.isUpdateable = false;
    }

    public HbmSimpleAttributeDomainState(MappingDefaults defaults, Attribute attribute, Map<String, MetaAttribute> entityMetaAttributes, XMLHibernateMapping.XMLClass.XMLDiscriminator discriminator) {
        super(defaults, attribute, null, null, null, true);
        this.hibernateTypeDescriptor.setTypeName(discriminator.getType() == null ? "string" : discriminator.getType());
        this.isLazy = false;
        this.propertyGeneration = PropertyGeneration.NEVER;
        this.isInsertable = discriminator.isInsert();
        this.isUpdateable = false;
    }

    public HbmSimpleAttributeDomainState(MappingDefaults defaults, Attribute attribute, Map<String, MetaAttribute> entityMetaAttributes, XMLHibernateMapping.XMLClass.XMLVersion version) {
        super(defaults, attribute, version.getNode(), HbmHelper.extractMetas(version.getMeta(), entityMetaAttributes), HbmHelper.getPropertyAccessorName(version.getAccess(), false, defaults.getDefaultAccess()), true);
        this.hibernateTypeDescriptor.setTypeName(version.getType() == null ? "integer" : version.getType());
        this.isLazy = false;
        this.propertyGeneration = PropertyGeneration.parse(version.getGenerated().value());
        if (this.propertyGeneration == PropertyGeneration.INSERT) {
            throw new MappingException("'generated' attribute cannot be 'insert' for versioning property");
        }
        this.isInsertable = MappingHelper.getBooleanValue(version.isInsert(), true);
        this.isUpdateable = true;
    }

    public HbmSimpleAttributeDomainState(MappingDefaults defaults, Attribute attribute, Map<String, MetaAttribute> entityMetaAttributes, XMLHibernateMapping.XMLClass.XMLTimestamp timestamp) {
        super(defaults, attribute, timestamp.getNode(), HbmHelper.extractMetas(timestamp.getMeta(), entityMetaAttributes), HbmHelper.getPropertyAccessorName(timestamp.getAccess(), false, defaults.getDefaultAccess()), true);
        this.hibernateTypeDescriptor.setTypeName("db".equals(timestamp.getSource()) ? "dbtimestamp" : "timestamp");
        this.isLazy = false;
        this.propertyGeneration = PropertyGeneration.parse(timestamp.getGenerated().value());
        if (this.propertyGeneration == PropertyGeneration.INSERT) {
            throw new MappingException("'generated' attribute cannot be 'insert' for versioning property");
        }
        this.isInsertable = true;
        this.isUpdateable = true;
    }

    public HbmSimpleAttributeDomainState(MappingDefaults defaults, Attribute attribute, Map<String, MetaAttribute> entityMetaAttributes, XMLPropertyElement property) {
        super(defaults, attribute, property.getNode(), HbmHelper.extractMetas(property.getMeta(), entityMetaAttributes), HbmHelper.getPropertyAccessorName(property.getAccess(), false, defaults.getDefaultAccess()), property.isOptimisticLock());
        this.isLazy = property.isLazy();
        this.propertyGeneration = PropertyGeneration.parse(property.getGenerated());
        if (this.propertyGeneration == PropertyGeneration.ALWAYS || this.propertyGeneration == PropertyGeneration.INSERT) {
            if (property.isInsert() != null && property.isInsert().booleanValue()) {
                throw new MappingException("cannot specify both insert=\"true\" and generated=\"" + this.propertyGeneration.getName() + "\" for property: " + this.getAttribute().getName());
            }
            this.isInsertable = false;
        } else {
            this.isInsertable = MappingHelper.getBooleanValue(property.isInsert(), true);
        }
        if (this.propertyGeneration == PropertyGeneration.ALWAYS) {
            if (property.isUpdate() != null && property.isUpdate().booleanValue()) {
                throw new MappingException("cannot specify both update=\"true\" and generated=\"" + this.propertyGeneration.getName() + "\" for property: " + this.getAttribute().getName());
            }
            this.isUpdateable = false;
        } else {
            this.isUpdateable = MappingHelper.getBooleanValue(property.isUpdate(), true);
        }
    }

    protected boolean isEmbedded() {
        return false;
    }

    @Override
    public HibernateTypeDescriptor getHibernateTypeDescriptor() {
        return this.hibernateTypeDescriptor;
    }

    @Override
    public boolean isLazy() {
        return this.isLazy;
    }

    @Override
    public PropertyGeneration getPropertyGeneration() {
        return this.propertyGeneration;
    }

    @Override
    public boolean isInsertable() {
        return this.isInsertable;
    }

    @Override
    public boolean isUpdateable() {
        return this.isUpdateable;
    }

    @Override
    public String getCascade() {
        return null;
    }

    @Override
    public boolean isKeyCasadeDeleteEnabled() {
        return false;
    }

    @Override
    public String getUnsavedValue() {
        return null;
    }
}

