/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.hbm.state.domain;

import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.hibernate.FetchMode;
import org.hibernate.MappingException;
import org.hibernate.metamodel.binding.CollectionElement;
import org.hibernate.metamodel.binding.CustomSQL;
import org.hibernate.metamodel.binding.ElementCollectionElement;
import org.hibernate.metamodel.binding.HibernateTypeDescriptor;
import org.hibernate.metamodel.binding.MappingDefaults;
import org.hibernate.metamodel.binding.PluralAttributeBinding;
import org.hibernate.metamodel.domain.Attribute;
import org.hibernate.metamodel.domain.MetaAttribute;
import org.hibernate.metamodel.source.hbm.HbmHelper;
import org.hibernate.metamodel.source.hbm.state.domain.AbstractHbmAttributeDomainState;
import org.hibernate.metamodel.source.hbm.state.domain.HbmCollectionElementDomainState;
import org.hibernate.metamodel.source.hbm.xml.mapping.XMLBagElement;
import org.hibernate.metamodel.source.hbm.xml.mapping.XMLSqlDeleteAllElement;
import org.hibernate.metamodel.source.hbm.xml.mapping.XMLSqlDeleteElement;
import org.hibernate.metamodel.source.hbm.xml.mapping.XMLSqlInsertElement;
import org.hibernate.metamodel.source.hbm.xml.mapping.XMLSqlUpdateElement;
import org.hibernate.metamodel.source.hbm.xml.mapping.XMLSynchronizeElement;
import org.hibernate.metamodel.source.util.MappingHelper;

public class HbmPluralAttributeDomainState
extends AbstractHbmAttributeDomainState
implements PluralAttributeBinding.DomainState {
    private final XMLBagElement collection;
    private final HibernateTypeDescriptor hibernateTypeDescriptor = new HibernateTypeDescriptor();
    private final String cascade;

    public HbmPluralAttributeDomainState(MappingDefaults defaults, XMLBagElement collection, Map<String, MetaAttribute> entityMetaAttributes, Attribute attribute) {
        super(defaults, attribute, collection.getNode(), HbmHelper.extractMetas(collection.getMeta(), entityMetaAttributes), HbmHelper.getPropertyAccessorName(collection.getAccess(), collection.isEmbedXml(), defaults.getDefaultAccess()), collection.isOptimisticLock());
        this.collection = collection;
        this.hibernateTypeDescriptor.setTypeName(collection.getCollectionType());
        this.cascade = MappingHelper.getStringValue(collection.getCascade(), defaults.getDefaultCascade());
        this.hibernateTypeDescriptor.setTypeName(collection.getCollectionType());
    }

    @Override
    public FetchMode getFetchMode() {
        FetchMode fetchMode;
        if (this.collection.getFetch() != null) {
            fetchMode = "join".equals((Object)this.collection.getFetch()) ? FetchMode.JOIN : FetchMode.SELECT;
        } else {
            String jfNodeValue;
            String string = jfNodeValue = this.collection.getOuterJoin().value() == null ? "auto" : this.collection.getOuterJoin().value();
            fetchMode = "auto".equals(jfNodeValue) ? FetchMode.DEFAULT : ("true".equals(jfNodeValue) ? FetchMode.JOIN : FetchMode.SELECT);
        }
        return fetchMode;
    }

    @Override
    public boolean isLazy() {
        return this.isExtraLazy() || MappingHelper.getBooleanValue(this.collection.getLazy().value(), this.getDefaults().isDefaultLazy());
    }

    @Override
    public boolean isExtraLazy() {
        return "extra".equals((Object)this.collection.getLazy());
    }

    @Override
    public CollectionElement getCollectionElement(PluralAttributeBinding binding) {
        ElementCollectionElement collectionElement = new ElementCollectionElement(binding);
        collectionElement.initialize(new HbmCollectionElementDomainState(this.collection.getElement()));
        return collectionElement;
    }

    @Override
    public boolean isInverse() {
        return this.collection.isInverse();
    }

    @Override
    public boolean isMutable() {
        return this.collection.isMutable();
    }

    @Override
    public boolean isSubselectLoadable() {
        return "subselect".equals((Object)this.collection.getFetch());
    }

    @Override
    public String getCacheConcurrencyStrategy() {
        return this.collection.getCache() == null ? null : this.collection.getCache().getUsage();
    }

    @Override
    public String getCacheRegionName() {
        return this.collection.getCache() == null ? null : this.collection.getCache().getRegion();
    }

    @Override
    public String getOrderBy() {
        return this.collection.getOrderBy();
    }

    @Override
    public String getWhere() {
        return this.collection.getWhere();
    }

    @Override
    public String getReferencedPropertyName() {
        return this.collection.getKey().getPropertyRef();
    }

    @Override
    public boolean isSorted() {
        return !"unsorted".equals(this.getSortString());
    }

    @Override
    public Comparator getComparator() {
        return null;
    }

    @Override
    public String getComparatorClassName() {
        String sortString = this.getSortString();
        return this.isSorted() && !"natural".equals(sortString) ? sortString : null;
    }

    private String getSortString() {
        return "unsorted";
    }

    @Override
    public boolean isOrphanDelete() {
        return this.getCascade().indexOf("delete-orphan") >= 0;
    }

    @Override
    public int getBatchSize() {
        return MappingHelper.getIntValue(this.collection.getBatchSize(), 0);
    }

    @Override
    public boolean isEmbedded() {
        return this.collection.isEmbedXml();
    }

    @Override
    public boolean isOptimisticLocked() {
        return this.collection.isOptimisticLock();
    }

    @Override
    public Class getCollectionPersisterClass() {
        try {
            return MappingHelper.getClassValue(this.collection.getPersister());
        }
        catch (ClassNotFoundException cnfe) {
            throw new MappingException("Could not find collection persister class: " + this.collection.getPersister());
        }
    }

    @Override
    public HibernateTypeDescriptor getHibernateTypeDescriptor() {
        return this.hibernateTypeDescriptor;
    }

    @Override
    public Map getFilters() {
        return new HashMap();
    }

    @Override
    public Set getSynchronizedTables() {
        HashSet<String> synchronizedTables = new HashSet<String>();
        for (XMLSynchronizeElement sync : this.collection.getSynchronize()) {
            synchronizedTables.add(sync.getTable());
        }
        return synchronizedTables;
    }

    @Override
    public CustomSQL getCustomSQLInsert() {
        XMLSqlInsertElement sqlInsert = this.collection.getSqlInsert();
        return sqlInsert == null ? null : HbmHelper.getCustomSql(this.collection.getSqlInsert().getValue(), this.collection.getSqlInsert().isCallable(), this.collection.getSqlInsert().getCheck().value());
    }

    @Override
    public CustomSQL getCustomSQLUpdate() {
        XMLSqlUpdateElement sqlUpdate = this.collection.getSqlUpdate();
        return sqlUpdate == null ? null : HbmHelper.getCustomSql(this.collection.getSqlUpdate().getValue(), this.collection.getSqlUpdate().isCallable(), this.collection.getSqlUpdate().getCheck().value());
    }

    @Override
    public CustomSQL getCustomSQLDelete() {
        XMLSqlDeleteElement sqlDelete = this.collection.getSqlDelete();
        return sqlDelete == null ? null : HbmHelper.getCustomSql(this.collection.getSqlDelete().getValue(), this.collection.getSqlDelete().isCallable(), this.collection.getSqlDelete().getCheck().value());
    }

    @Override
    public CustomSQL getCustomSQLDeleteAll() {
        XMLSqlDeleteAllElement sqlDeleteAll = this.collection.getSqlDeleteAll();
        return sqlDeleteAll == null ? null : HbmHelper.getCustomSql(this.collection.getSqlDeleteAll().getValue(), this.collection.getSqlDeleteAll().isCallable(), this.collection.getSqlDeleteAll().getCheck().value());
    }

    @Override
    public String getLoaderName() {
        return this.collection.getLoader() == null ? null : this.collection.getLoader().getQueryRef();
    }

    @Override
    public String getCascade() {
        return this.cascade;
    }

    public boolean isKeyCasadeDeleteEnabled() {
        return false;
    }

    public String getUnsavedValue() {
        return null;
    }
}

