/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.hbm.state.domain;

import java.util.Map;
import org.hibernate.FetchMode;
import org.hibernate.metamodel.binding.HibernateTypeDescriptor;
import org.hibernate.metamodel.binding.ManyToOneAttributeBinding;
import org.hibernate.metamodel.binding.MappingDefaults;
import org.hibernate.metamodel.domain.Attribute;
import org.hibernate.metamodel.domain.MetaAttribute;
import org.hibernate.metamodel.source.hbm.HbmHelper;
import org.hibernate.metamodel.source.hbm.state.domain.AbstractHbmAttributeDomainState;
import org.hibernate.metamodel.source.hbm.xml.mapping.XMLManyToOneElement;
import org.hibernate.metamodel.source.util.MappingHelper;

public class HbmManyToOneAttributeDomainState
extends AbstractHbmAttributeDomainState
implements ManyToOneAttributeBinding.DomainState {
    private final HibernateTypeDescriptor hibernateTypeDescriptor = new HibernateTypeDescriptor();
    private final FetchMode fetchMode;
    private final boolean isUnwrapProxy;
    private final boolean isLazy;
    private final String cascade;
    private final boolean isEmbedded;
    private final String referencedPropertyName;
    private final String referencedEntityName;
    private final boolean ignoreNotFound;
    private final boolean isInsertable;
    private final boolean isUpdateable;

    public HbmManyToOneAttributeDomainState(MappingDefaults defaults, Attribute attribute, Map<String, MetaAttribute> entityMetaAttributes, XMLManyToOneElement manyToOne) {
        super(defaults, attribute, manyToOne.getNode(), HbmHelper.extractMetas(manyToOne.getMeta(), entityMetaAttributes), HbmHelper.getPropertyAccessorName(manyToOne.getAccess(), manyToOne.isEmbedXml(), defaults.getDefaultAccess()), manyToOne.isOptimisticLock());
        this.fetchMode = HbmManyToOneAttributeDomainState.getFetchMode(manyToOne);
        this.isUnwrapProxy = manyToOne.getLazy() != null && "no-proxy".equals(manyToOne.getLazy().value());
        this.isLazy = manyToOne.getLazy() == null || this.isUnwrapProxy || "proxy".equals(manyToOne.getLazy().value());
        this.cascade = MappingHelper.getStringValue(manyToOne.getCascade(), defaults.getDefaultCascade());
        this.isEmbedded = manyToOne.isEmbedXml();
        this.hibernateTypeDescriptor.setTypeName(this.getReferencedEntityName());
        this.referencedPropertyName = manyToOne.getPropertyRef();
        this.referencedEntityName = manyToOne.getEntityName() == null ? HbmHelper.getClassName(manyToOne.getClazz(), this.getDefaults().getPackageName()) : manyToOne.getEntityName().intern();
        this.ignoreNotFound = "ignore".equals(manyToOne.getNotFound().value());
        this.isInsertable = manyToOne.isInsert();
        this.isUpdateable = manyToOne.isUpdate();
    }

    protected boolean isEmbedded() {
        return this.isEmbedded;
    }

    @Override
    public HibernateTypeDescriptor getHibernateTypeDescriptor() {
        return this.hibernateTypeDescriptor;
    }

    private static FetchMode getFetchMode(XMLManyToOneElement manyToOne) {
        FetchMode fetchMode;
        if (manyToOne.getFetch() != null) {
            fetchMode = "join".equals(manyToOne.getFetch().value()) ? FetchMode.JOIN : FetchMode.SELECT;
        } else {
            String jfNodeValue;
            String string = jfNodeValue = manyToOne.getOuterJoin() == null ? "auto" : manyToOne.getOuterJoin().value();
            fetchMode = "auto".equals(jfNodeValue) ? FetchMode.DEFAULT : ("true".equals(jfNodeValue) ? FetchMode.JOIN : FetchMode.SELECT);
        }
        return fetchMode;
    }

    public FetchMode getFetchMode() {
        return this.fetchMode;
    }

    @Override
    public boolean isLazy() {
        return this.isLazy;
    }

    @Override
    public boolean isUnwrapProxy() {
        return this.isUnwrapProxy;
    }

    @Override
    public String getReferencedAttributeName() {
        return this.referencedPropertyName;
    }

    @Override
    public String getReferencedEntityName() {
        return this.referencedEntityName;
    }

    @Override
    public String getCascade() {
        return this.cascade;
    }

    @Override
    public boolean ignoreNotFound() {
        return this.ignoreNotFound;
    }

    @Override
    public boolean isInsertable() {
        return this.isInsertable;
    }

    @Override
    public boolean isUpdateable() {
        return this.isUpdateable;
    }

    @Override
    public boolean isKeyCasadeDeleteEnabled() {
        return false;
    }

    @Override
    public String getUnsavedValue() {
        return null;
    }
}

