/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.hbm;

import org.hibernate.InvalidMappingException;
import org.hibernate.MappingException;
import org.hibernate.metamodel.binding.Caching;
import org.hibernate.metamodel.binding.EntityBinding;
import org.hibernate.metamodel.binding.SimpleAttributeBinding;
import org.hibernate.metamodel.relational.Column;
import org.hibernate.metamodel.relational.Identifier;
import org.hibernate.metamodel.relational.InLineView;
import org.hibernate.metamodel.relational.Schema;
import org.hibernate.metamodel.relational.Table;
import org.hibernate.metamodel.source.hbm.AbstractEntityBinder;
import org.hibernate.metamodel.source.hbm.HibernateMappingBinder;
import org.hibernate.metamodel.source.hbm.xml.mapping.XMLCacheElement;
import org.hibernate.metamodel.source.hbm.xml.mapping.XMLHibernateMapping;

class RootEntityBinder
extends AbstractEntityBinder {
    RootEntityBinder(HibernateMappingBinder hibernateMappingBinder, XMLHibernateMapping.XMLClass xmlClazz) {
        super(hibernateMappingBinder, xmlClazz);
    }

    public void process(XMLHibernateMapping.XMLClass xmlClazz) {
        String entityName = this.getHibernateMappingBinder().extractEntityName(xmlClazz);
        if (entityName == null) {
            throw new MappingException("Unable to determine entity name");
        }
        EntityBinding entityBinding = new EntityBinding();
        this.basicEntityBinding(xmlClazz, entityBinding, null);
        this.basicTableBinding(xmlClazz, entityBinding);
        entityBinding.setMutable(xmlClazz.isMutable());
        if (xmlClazz.getWhere() != null) {
            entityBinding.setWhereFilter(xmlClazz.getWhere());
        }
        if (xmlClazz.getPolymorphism() != null) {
            entityBinding.setExplicitPolymorphism("explicit".equals(xmlClazz.getPolymorphism()));
        }
        if (xmlClazz.getRowid() != null) {
            entityBinding.setRowId(xmlClazz.getRowid());
        }
        this.bindIdentifier(xmlClazz, entityBinding);
        this.bindDiscriminator(xmlClazz, entityBinding);
        this.bindVersion(xmlClazz, entityBinding);
        this.bindCaching(xmlClazz, entityBinding);
        this.buildAttributeBindings(xmlClazz, entityBinding);
        this.getHibernateXmlBinder().getMetadata().addEntity(entityBinding);
    }

    private void basicTableBinding(XMLHibernateMapping.XMLClass xmlClazz, EntityBinding entityBinding) {
        String subSelect;
        Schema schema = this.getHibernateXmlBinder().getMetadata().getDatabase().getSchema(this.getSchemaName());
        String string = subSelect = xmlClazz.getSubselectAttribute() == null ? xmlClazz.getSubselect() : xmlClazz.getSubselectAttribute();
        if (subSelect != null) {
            String logicalName = entityBinding.getEntity().getName();
            InLineView inLineView = schema.getInLineView(logicalName);
            if (inLineView == null) {
                inLineView = schema.createInLineView(logicalName, subSelect);
            }
            entityBinding.setBaseTable(inLineView);
        } else {
            String check;
            Identifier tableName = Identifier.toIdentifier(this.getClassTableName(xmlClazz, entityBinding, null));
            Table table = schema.getTable(tableName);
            if (table == null) {
                table = schema.createTable(tableName);
            }
            entityBinding.setBaseTable(table);
            String comment = xmlClazz.getComment();
            if (comment != null) {
                table.addComment(comment.trim());
            }
            if ((check = xmlClazz.getCheck()) != null) {
                table.addCheckConstraint(check);
            }
        }
    }

    private void bindIdentifier(XMLHibernateMapping.XMLClass xmlClazz, EntityBinding entityBinding) {
        if (xmlClazz.getId() != null) {
            this.bindSimpleId(xmlClazz.getId(), entityBinding);
            return;
        }
        if (xmlClazz.getCompositeId() != null) {
            RootEntityBinder.bindCompositeId(xmlClazz.getCompositeId(), entityBinding);
        }
        throw new InvalidMappingException("Entity [" + entityBinding.getEntity().getName() + "] did not contain identifier mapping", this.getHibernateMappingBinder().getOrigin());
    }

    private void bindSimpleId(XMLHibernateMapping.XMLClass.XMLId id, EntityBinding entityBinding) {
        String explicitName = id.getName();
        String attributeName = explicitName == null ? "id" : explicitName;
        SimpleAttributeBinding idBinding = entityBinding.makeSimplePrimaryKeyAttributeBinding(attributeName);
        this.bindSimpleAttribute(id, idBinding, entityBinding, attributeName);
        if (!Column.class.isInstance(idBinding.getValue())) {
            throw new MappingException("Unanticipated situation");
        }
        entityBinding.getBaseTable().getPrimaryKey().addColumn((Column)Column.class.cast(idBinding.getValue()));
    }

    private static void bindCompositeId(XMLHibernateMapping.XMLClass.XMLCompositeId compositeId, EntityBinding entityBinding) {
        String explicitName = compositeId.getName();
    }

    private void bindDiscriminator(XMLHibernateMapping.XMLClass xmlEntityClazz, EntityBinding entityBinding) {
        if (xmlEntityClazz.getDiscriminator() == null) {
            return;
        }
        SimpleAttributeBinding discriminatorBinding = entityBinding.makeEntityDiscriminatorBinding("class");
        this.bindSimpleAttribute(xmlEntityClazz.getDiscriminator(), discriminatorBinding, entityBinding, "class");
        entityBinding.getEntityDiscriminator().setForced(xmlEntityClazz.getDiscriminator().isForce());
    }

    private void bindVersion(XMLHibernateMapping.XMLClass xmlEntityClazz, EntityBinding entityBinding) {
        String explicitName;
        if (xmlEntityClazz.getVersion() == null && xmlEntityClazz.getTimestamp() == null) {
            return;
        }
        boolean isVersion = xmlEntityClazz.getVersion() != null;
        String string = explicitName = isVersion ? xmlEntityClazz.getVersion().getName() : xmlEntityClazz.getTimestamp().getName();
        if (explicitName == null) {
            throw new MappingException("Missing property name for version/timestamp mapping [" + entityBinding.getEntity().getName() + "]");
        }
        SimpleAttributeBinding versionBinding = entityBinding.makeVersionBinding(explicitName);
        if (isVersion) {
            this.bindSimpleAttribute(xmlEntityClazz.getVersion(), versionBinding, entityBinding, explicitName);
        } else {
            this.bindSimpleAttribute(xmlEntityClazz.getTimestamp(), versionBinding, entityBinding, explicitName);
        }
    }

    private void bindCaching(XMLHibernateMapping.XMLClass xmlClazz, EntityBinding entityBinding) {
        XMLCacheElement cache = xmlClazz.getCache();
        if (cache == null) {
            return;
        }
        String region = cache.getRegion() != null ? cache.getRegion() : entityBinding.getEntity().getName();
        String strategy = cache.getUsage();
        boolean cacheLazyProps = !"non-lazy".equals(cache.getInclude());
        entityBinding.setCaching(new Caching(region, strategy, cacheLazyProps));
    }
}

