/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.hbm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dom4j.Element;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.collections.JoinedIterator;
import org.hibernate.internal.util.xml.XmlDocument;
import org.hibernate.metamodel.domain.MetaAttribute;
import org.hibernate.metamodel.source.hbm.HbmHelper;
import org.hibernate.metamodel.source.hbm.HibernateMappingBinder;
import org.hibernate.metamodel.source.hbm.xml.mapping.XMLHibernateMapping;
import org.hibernate.metamodel.source.internal.JaxbRoot;
import org.hibernate.metamodel.source.internal.MetadataImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HibernateXmlBinder {
    private static final Logger log = LoggerFactory.getLogger(HibernateXmlBinder.class);
    private final MetadataImpl metadata;
    private final Map<String, MetaAttribute> globalMetas;

    public HibernateXmlBinder(MetadataImpl metadata) {
        this(metadata, Collections.emptyMap());
    }

    public HibernateXmlBinder(MetadataImpl metadata, Map<String, MetaAttribute> globalMetas) {
        this.metadata = metadata;
        this.globalMetas = globalMetas;
    }

    public void bindRoot(JaxbRoot<XMLHibernateMapping> jaxbRoot) {
        log.debug(jaxbRoot.toString());
        this.bindRoot(jaxbRoot, Collections.<String>emptySet());
    }

    public void bindRoot(JaxbRoot<XMLHibernateMapping> jaxbRoot, Set<String> entityNames) {
        HibernateMappingBinder mappingBinder = new HibernateMappingBinder(this, jaxbRoot);
        mappingBinder.processHibernateMapping();
    }

    MetadataImpl getMetadata() {
        return this.metadata;
    }

    Map<String, MetaAttribute> getGlobalMetas() {
        return this.globalMetas;
    }

    private List<String> locateEntityNamesAwaitingExtends(XmlDocument metadataXml, HibernateMappingBinder mappingBinder) {
        final String unqualifiedPackageName = mappingBinder.getPackageName();
        Element rootElement = metadataXml.getDocumentTree().getRootElement();
        ArrayList<String> awaitingExtends = new ArrayList<String>();
        Iterator[] subclasses = new Iterator[]{rootElement.elementIterator("subclass"), rootElement.elementIterator("joined-subclass"), rootElement.elementIterator("union-subclass")};
        JoinedIterator iterator = new JoinedIterator(subclasses);
        while (iterator.hasNext()) {
            Element element = (Element)iterator.next();
            String extendsName = element.attributeValue("extends");
            if (this.getMetadata().getEntityBinding(extendsName) != null || this.getMetadata().getEntityBinding(HbmHelper.getClassName(extendsName, unqualifiedPackageName)) != null) continue;
            awaitingExtends.add(extendsName);
        }
        if (!awaitingExtends.isEmpty()) {
            final HashSet<String> set = new HashSet<String>(awaitingExtends);
            EntityElementHandler handler = new EntityElementHandler(){

                @Override
                public void handleEntity(String entityName, String className) {
                    if (entityName != null) {
                        set.remove(entityName);
                    } else {
                        String fqn = HbmHelper.getClassName(className, unqualifiedPackageName);
                        set.remove(fqn);
                        if (unqualifiedPackageName != null) {
                            set.remove(StringHelper.unqualify(fqn));
                        }
                    }
                }
            };
            HibernateXmlBinder.recognizeEntities(rootElement, handler);
            awaitingExtends.clear();
            awaitingExtends.addAll(set);
        }
        return awaitingExtends;
    }

    private static void recognizeEntities(Element startNode, EntityElementHandler handler) {
        Iterator[] classes = new Iterator[]{startNode.elementIterator("class"), startNode.elementIterator("subclass"), startNode.elementIterator("joined-subclass"), startNode.elementIterator("union-subclass")};
        JoinedIterator classIterator = new JoinedIterator(classes);
        while (classIterator.hasNext()) {
            Element element = (Element)classIterator.next();
            handler.handleEntity(element.attributeValue("entity-name"), element.attributeValue("name"));
            HibernateXmlBinder.recognizeEntities(element, handler);
        }
    }

    private static interface EntityElementHandler {
        public void handleEntity(String var1, String var2);
    }
}

