/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.hbm;

import java.util.List;
import java.util.Map;
import org.dom4j.Attribute;
import org.hibernate.MappingException;
import org.hibernate.cfg.NamingStrategy;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.MetadataSource;
import org.hibernate.metamodel.binding.FetchProfile;
import org.hibernate.metamodel.binding.MappingDefaults;
import org.hibernate.metamodel.domain.MetaAttribute;
import org.hibernate.metamodel.source.Origin;
import org.hibernate.metamodel.source.hbm.HbmHelper;
import org.hibernate.metamodel.source.hbm.HibernateXmlBinder;
import org.hibernate.metamodel.source.hbm.RootEntityBinder;
import org.hibernate.metamodel.source.hbm.xml.mapping.XMLFetchProfileElement;
import org.hibernate.metamodel.source.hbm.xml.mapping.XMLHibernateMapping;
import org.hibernate.metamodel.source.hbm.xml.mapping.XMLJoinedSubclassElement;
import org.hibernate.metamodel.source.hbm.xml.mapping.XMLQueryElement;
import org.hibernate.metamodel.source.hbm.xml.mapping.XMLSqlQueryElement;
import org.hibernate.metamodel.source.hbm.xml.mapping.XMLSubclassElement;
import org.hibernate.metamodel.source.hbm.xml.mapping.XMLUnionSubclassElement;
import org.hibernate.metamodel.source.internal.JaxbRoot;
import org.hibernate.metamodel.source.util.MappingHelper;

class HibernateMappingBinder
implements MappingDefaults {
    private final HibernateXmlBinder hibernateXmlBinder;
    private final JaxbRoot<XMLHibernateMapping> jaxbRoot;
    private final XMLHibernateMapping hibernateMapping;
    private final String defaultSchemaName;
    private final String defaultCatalogName;
    private final String defaultCascade;
    private final String defaultAccess;
    private final boolean defaultLazy;
    private final String packageName;
    private final boolean autoImport;
    private Map<String, MetaAttribute> mappingMetas;

    HibernateMappingBinder(HibernateXmlBinder hibernateXmlBinder, JaxbRoot<XMLHibernateMapping> jaxbRoot) {
        this.hibernateXmlBinder = hibernateXmlBinder;
        this.jaxbRoot = jaxbRoot;
        this.hibernateMapping = jaxbRoot.getRoot();
        this.defaultSchemaName = this.hibernateMapping.getSchema();
        this.defaultCatalogName = this.hibernateMapping.getCatalog();
        this.defaultCascade = MappingHelper.getStringValue(this.hibernateMapping.getDefaultCascade(), "none");
        this.defaultAccess = MappingHelper.getStringValue(this.hibernateMapping.getDefaultAccess(), "property");
        this.defaultLazy = this.hibernateMapping.isDefaultLazy();
        this.packageName = this.hibernateMapping.getPackage();
        this.autoImport = this.hibernateMapping.isAutoImport();
        this.mappingMetas = HbmHelper.extractMetas(this.hibernateMapping.getMeta(), true, hibernateXmlBinder.getGlobalMetas());
    }

    HibernateXmlBinder getHibernateXmlBinder() {
        return this.hibernateXmlBinder;
    }

    XMLHibernateMapping getHibernateMapping() {
        return this.hibernateMapping;
    }

    Origin getOrigin() {
        return this.jaxbRoot.getOrigin();
    }

    @Override
    public String getDefaultSchemaName() {
        return this.defaultSchemaName;
    }

    @Override
    public String getDefaultCatalogName() {
        return this.defaultCatalogName;
    }

    @Override
    public String getDefaultCascade() {
        return this.defaultCascade;
    }

    @Override
    public String getDefaultAccess() {
        return this.defaultAccess;
    }

    @Override
    public boolean isDefaultLazy() {
        return this.defaultLazy;
    }

    @Override
    public NamingStrategy getNamingStrategy() {
        return this.hibernateXmlBinder.getMetadata().getNamingStrategy();
    }

    @Override
    public String getPackageName() {
        return this.packageName;
    }

    boolean isAutoImport() {
        return this.autoImport;
    }

    @Override
    public Map<String, MetaAttribute> getMappingMetas() {
        return this.mappingMetas;
    }

    void processHibernateMapping() {
        if (this.hibernateMapping.getFilterDef() != null) {
            // empty if block
        }
        if (this.hibernateMapping.getFetchProfile() != null) {
            this.parseFetchProfiles(this.hibernateMapping.getFetchProfile(), null);
        }
        if (this.hibernateMapping.getIdentifierGenerator() != null) {
            // empty if block
        }
        if (this.hibernateMapping.getTypedef() != null) {
            // empty if block
        }
        if (this.hibernateMapping.getClazzOrSubclassOrJoinedSubclass() != null) {
            for (Object clazzOrSubclass : this.hibernateMapping.getClazzOrSubclassOrJoinedSubclass()) {
                if (XMLHibernateMapping.XMLClass.class.isInstance(clazzOrSubclass)) {
                    XMLHibernateMapping.XMLClass clazz = (XMLHibernateMapping.XMLClass)XMLHibernateMapping.XMLClass.class.cast(clazzOrSubclass);
                    new RootEntityBinder(this, clazz).process(clazz);
                    continue;
                }
                if (XMLSubclassElement.class.isInstance(clazzOrSubclass) || XMLJoinedSubclassElement.class.isInstance(clazzOrSubclass) || XMLUnionSubclassElement.class.isInstance(clazzOrSubclass)) continue;
                throw new org.hibernate.metamodel.source.MappingException("unknown type of class or subclass: " + clazzOrSubclass.getClass().getName(), this.jaxbRoot.getOrigin());
            }
        }
        if (this.hibernateMapping.getQueryOrSqlQuery() != null) {
            for (Object queryOrSqlQuery : this.hibernateMapping.getQueryOrSqlQuery()) {
                if (XMLQueryElement.class.isInstance(queryOrSqlQuery) || XMLSqlQueryElement.class.isInstance(queryOrSqlQuery)) continue;
                throw new org.hibernate.metamodel.source.MappingException("unknown type of query: " + queryOrSqlQuery.getClass().getName(), this.jaxbRoot.getOrigin());
            }
        }
        if (this.hibernateMapping.getResultset() != null) {
            // empty if block
        }
        if (this.hibernateMapping.getImport() != null) {
            this.processImports(this.hibernateMapping.getImport());
        }
        if (this.hibernateMapping.getDatabaseObject() != null) {
            // empty if block
        }
    }

    private void processImports(List<XMLHibernateMapping.XMLImport> imports) {
        for (XMLHibernateMapping.XMLImport importValue : imports) {
            String className = this.getClassName(importValue.getClazz());
            String rename = importValue.getRename();
            rename = rename == null ? StringHelper.unqualify(className) : rename;
            this.hibernateXmlBinder.getMetadata().addImport(className, rename);
        }
    }

    protected void parseFetchProfiles(List<XMLFetchProfileElement> fetchProfiles, String containingEntityName) {
        for (XMLFetchProfileElement fetchProfile : fetchProfiles) {
            String profileName = fetchProfile.getName();
            FetchProfile profile = this.hibernateXmlBinder.getMetadata().findOrCreateFetchProfile(profileName, MetadataSource.HBM);
            for (XMLFetchProfileElement.XMLFetch fetch : fetchProfile.getFetch()) {
                String entityName;
                String string = entityName = fetch.getEntity() == null ? containingEntityName : fetch.getEntity();
                if (entityName == null) {
                    throw new MappingException("could not determine entity for fetch-profile fetch [" + profileName + "]:[" + fetch.getAssociation() + "]");
                }
                profile.addFetch(entityName, fetch.getAssociation(), fetch.getStyle());
            }
        }
    }

    String extractEntityName(XMLHibernateMapping.XMLClass entityClazz) {
        return HbmHelper.extractEntityName(entityClazz, this.packageName);
    }

    String getClassName(Attribute attribute) {
        return HbmHelper.getClassName(attribute, this.packageName);
    }

    String getClassName(String unqualifiedName) {
        return HbmHelper.getClassName(unqualifiedName, this.packageName);
    }
}

