/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.hbm;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.hibernate.MappingException;
import org.hibernate.engine.spi.ExecuteUpdateResultCheckStyle;
import org.hibernate.metamodel.binding.CustomSQL;
import org.hibernate.metamodel.domain.MetaAttribute;
import org.hibernate.metamodel.source.hbm.xml.mapping.XMLHibernateMapping;
import org.hibernate.metamodel.source.hbm.xml.mapping.XMLMetaElement;
import org.hibernate.metamodel.source.util.DomHelper;
import org.hibernate.metamodel.source.util.MappingHelper;

public class HbmHelper {
    public static boolean isCallable(Element e) {
        return HbmHelper.isCallable(e, true);
    }

    public static boolean isCallable(Element element, boolean supportsCallable) {
        Attribute attrib = element.attribute("callable");
        if (attrib != null && "true".equals(attrib.getValue())) {
            if (!supportsCallable) {
                throw new MappingException("callable attribute not supported yet!");
            }
            return true;
        }
        return false;
    }

    public static ExecuteUpdateResultCheckStyle getResultCheckStyle(String check, boolean callable) {
        if (check == null) {
            return ExecuteUpdateResultCheckStyle.COUNT;
        }
        return ExecuteUpdateResultCheckStyle.fromExternalName(check);
    }

    public static final Map<String, MetaAttribute> extractMetas(List<XMLMetaElement> meta, Map<String, MetaAttribute> baseline) {
        return HbmHelper.extractMetas(meta, false, baseline);
    }

    public static final Map<String, MetaAttribute> extractMetas(List<XMLMetaElement> metaList, boolean onlyInheritable, Map<String, MetaAttribute> baseline) {
        HashMap<String, MetaAttribute> extractedMetas = new HashMap<String, MetaAttribute>();
        extractedMetas.putAll(baseline);
        for (XMLMetaElement meta : metaList) {
            boolean inheritable = meta.isInherit();
            if (onlyInheritable & !inheritable) continue;
            String name = meta.getAttribute();
            MetaAttribute inheritedMetaAttribute = baseline.get(name);
            MetaAttribute metaAttribute = (MetaAttribute)extractedMetas.get(name);
            if (metaAttribute == null || metaAttribute == inheritedMetaAttribute) {
                metaAttribute = new MetaAttribute(name);
                extractedMetas.put(name, metaAttribute);
            }
            metaAttribute.addValue(meta.getValue());
        }
        return extractedMetas;
    }

    public static String extractEntityName(XMLHibernateMapping.XMLClass entityClazz, String unqualifiedPackageName) {
        return HbmHelper.extractEntityName(entityClazz.getEntityName(), entityClazz.getName(), unqualifiedPackageName);
    }

    public static String extractEntityName(String entityName, String entityClassName, String unqualifiedPackageName) {
        return entityName == null ? HbmHelper.getClassName(entityClassName, unqualifiedPackageName) : entityName;
    }

    public static String getClassName(Attribute att, String unqualifiedPackageName) {
        if (att == null) {
            return null;
        }
        return HbmHelper.getClassName(att.getValue(), unqualifiedPackageName);
    }

    public static String getClassName(String unqualifiedName, String unqualifiedPackageName) {
        if (unqualifiedName == null) {
            return null;
        }
        if (unqualifiedName.indexOf(46) < 0 && unqualifiedPackageName != null) {
            return unqualifiedPackageName + '.' + unqualifiedName;
        }
        return unqualifiedName;
    }

    public static CustomSQL getCustomSql(String sql, boolean isCallable, String check) {
        return new CustomSQL(sql.trim(), isCallable, HbmHelper.getResultCheckStyle(check, isCallable));
    }

    public static String getPropertyAccessorName(Element element, boolean isEmbedded, String defaultAccess) {
        return DomHelper.extractAttributeValue(element, "access", isEmbedded ? "embedded" : defaultAccess);
    }

    public static String getPropertyAccessorName(String access, boolean isEmbedded, String defaultAccess) {
        return MappingHelper.getStringValue(access, isEmbedded ? "embedded" : defaultAccess);
    }
}

