/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.hbm;

import org.hibernate.EntityMode;
import org.hibernate.MappingException;
import org.hibernate.cfg.NamingStrategy;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.metamodel.binding.AbstractAttributeBinding;
import org.hibernate.metamodel.binding.BagBinding;
import org.hibernate.metamodel.binding.EntityBinding;
import org.hibernate.metamodel.binding.ManyToOneAttributeBinding;
import org.hibernate.metamodel.binding.MappingDefaults;
import org.hibernate.metamodel.binding.PluralAttributeBinding;
import org.hibernate.metamodel.binding.SimpleAttributeBinding;
import org.hibernate.metamodel.domain.Attribute;
import org.hibernate.metamodel.domain.Entity;
import org.hibernate.metamodel.domain.Hierarchical;
import org.hibernate.metamodel.domain.PluralAttributeNature;
import org.hibernate.metamodel.relational.Schema;
import org.hibernate.metamodel.relational.Table;
import org.hibernate.metamodel.relational.TableSpecification;
import org.hibernate.metamodel.relational.UniqueKey;
import org.hibernate.metamodel.source.hbm.HibernateMappingBinder;
import org.hibernate.metamodel.source.hbm.HibernateXmlBinder;
import org.hibernate.metamodel.source.hbm.state.domain.HbmManyToOneAttributeDomainState;
import org.hibernate.metamodel.source.hbm.state.domain.HbmPluralAttributeDomainState;
import org.hibernate.metamodel.source.hbm.state.domain.HbmSimpleAttributeDomainState;
import org.hibernate.metamodel.source.hbm.state.relational.HbmManyToOneRelationalStateContainer;
import org.hibernate.metamodel.source.hbm.state.relational.HbmSimpleValueRelationalStateContainer;
import org.hibernate.metamodel.source.hbm.xml.mapping.XMLAnyElement;
import org.hibernate.metamodel.source.hbm.xml.mapping.XMLBagElement;
import org.hibernate.metamodel.source.hbm.xml.mapping.XMLComponentElement;
import org.hibernate.metamodel.source.hbm.xml.mapping.XMLDynamicComponentElement;
import org.hibernate.metamodel.source.hbm.xml.mapping.XMLFilterElement;
import org.hibernate.metamodel.source.hbm.xml.mapping.XMLHibernateMapping;
import org.hibernate.metamodel.source.hbm.xml.mapping.XMLIdbagElement;
import org.hibernate.metamodel.source.hbm.xml.mapping.XMLJoinElement;
import org.hibernate.metamodel.source.hbm.xml.mapping.XMLJoinedSubclassElement;
import org.hibernate.metamodel.source.hbm.xml.mapping.XMLListElement;
import org.hibernate.metamodel.source.hbm.xml.mapping.XMLManyToOneElement;
import org.hibernate.metamodel.source.hbm.xml.mapping.XMLMapElement;
import org.hibernate.metamodel.source.hbm.xml.mapping.XMLOneToOneElement;
import org.hibernate.metamodel.source.hbm.xml.mapping.XMLPropertiesElement;
import org.hibernate.metamodel.source.hbm.xml.mapping.XMLPropertyElement;
import org.hibernate.metamodel.source.hbm.xml.mapping.XMLQueryElement;
import org.hibernate.metamodel.source.hbm.xml.mapping.XMLResultsetElement;
import org.hibernate.metamodel.source.hbm.xml.mapping.XMLSetElement;
import org.hibernate.metamodel.source.hbm.xml.mapping.XMLSqlQueryElement;
import org.hibernate.metamodel.source.hbm.xml.mapping.XMLSubclassElement;
import org.hibernate.metamodel.source.hbm.xml.mapping.XMLTuplizerElement;
import org.hibernate.metamodel.source.hbm.xml.mapping.XMLUnionSubclassElement;
import org.hibernate.metamodel.source.internal.MetadataImpl;

abstract class AbstractEntityBinder {
    private final HibernateMappingBinder hibernateMappingBinder;
    private final Schema.Name schemaName;

    AbstractEntityBinder(HibernateMappingBinder hibernateMappingBinder, XMLHibernateMapping.XMLClass entityClazz) {
        this.hibernateMappingBinder = hibernateMappingBinder;
        this.schemaName = new Schema.Name(entityClazz.getSchema() == null ? hibernateMappingBinder.getDefaultSchemaName() : entityClazz.getSchema(), entityClazz.getCatalog() == null ? hibernateMappingBinder.getDefaultCatalogName() : entityClazz.getCatalog());
    }

    protected HibernateMappingBinder getHibernateMappingBinder() {
        return this.hibernateMappingBinder;
    }

    protected HibernateXmlBinder getHibernateXmlBinder() {
        return this.hibernateMappingBinder.getHibernateXmlBinder();
    }

    protected MetadataImpl getMetadata() {
        return this.hibernateMappingBinder.getHibernateXmlBinder().getMetadata();
    }

    protected Schema.Name getSchemaName() {
        return this.schemaName;
    }

    protected NamingStrategy getNamingStrategy() {
        return this.getMetadata().getNamingStrategy();
    }

    protected void basicEntityBinding(XMLHibernateMapping.XMLClass entityClazz, EntityBinding entityBinding, Hierarchical superType) {
        entityBinding.fromHbmXml(this.hibernateMappingBinder, entityClazz, new Entity(this.hibernateMappingBinder.extractEntityName(entityClazz), superType));
        this.bindPojoRepresentation(entityClazz, entityBinding);
        this.bindDom4jRepresentation(entityClazz, entityBinding);
        this.bindMapRepresentation(entityClazz, entityBinding);
        String entityName = entityBinding.getEntity().getName();
        if (entityClazz.getFetchProfile() != null) {
            this.hibernateMappingBinder.parseFetchProfiles(entityClazz.getFetchProfile(), entityName);
        }
        this.getMetadata().addImport(entityName, entityName);
        if (this.hibernateMappingBinder.isAutoImport() && entityName.indexOf(46) > 0) {
            this.getMetadata().addImport(StringHelper.unqualify(entityName), entityName);
        }
    }

    protected String getDefaultAccess() {
        return this.hibernateMappingBinder.getDefaultAccess();
    }

    private void bindPojoRepresentation(XMLHibernateMapping.XMLClass entityClazz, EntityBinding entityBinding) {
        String className = this.hibernateMappingBinder.getClassName(entityClazz.getName());
        String proxyName = this.hibernateMappingBinder.getClassName(entityClazz.getProxy());
        entityBinding.getEntity().getPojoEntitySpecifics().setClassName(className);
        if (proxyName != null) {
            entityBinding.getEntity().getPojoEntitySpecifics().setProxyInterfaceName(proxyName);
            entityBinding.setLazy(true);
        } else if (entityBinding.isLazy()) {
            entityBinding.getEntity().getPojoEntitySpecifics().setProxyInterfaceName(className);
        }
        XMLTuplizerElement tuplizer = AbstractEntityBinder.locateTuplizerDefinition(entityClazz, EntityMode.POJO);
        if (tuplizer != null) {
            entityBinding.getEntity().getPojoEntitySpecifics().setTuplizerClassName(tuplizer.getClazz());
        }
    }

    private void bindDom4jRepresentation(XMLHibernateMapping.XMLClass entityClazz, EntityBinding entityBinding) {
        String nodeName = entityClazz.getNode();
        if (nodeName == null) {
            nodeName = StringHelper.unqualify(entityBinding.getEntity().getName());
        }
        entityBinding.getEntity().getDom4jEntitySpecifics().setNodeName(nodeName);
        XMLTuplizerElement tuplizer = AbstractEntityBinder.locateTuplizerDefinition(entityClazz, EntityMode.DOM4J);
        if (tuplizer != null) {
            entityBinding.getEntity().getDom4jEntitySpecifics().setTuplizerClassName(tuplizer.getClazz());
        }
    }

    private void bindMapRepresentation(XMLHibernateMapping.XMLClass entityClazz, EntityBinding entityBinding) {
        XMLTuplizerElement tuplizer = AbstractEntityBinder.locateTuplizerDefinition(entityClazz, EntityMode.MAP);
        if (tuplizer != null) {
            entityBinding.getEntity().getMapEntitySpecifics().setTuplizerClassName(tuplizer.getClazz());
        }
    }

    private static XMLTuplizerElement locateTuplizerDefinition(XMLHibernateMapping.XMLClass container, EntityMode entityMode) {
        for (XMLTuplizerElement tuplizer : container.getTuplizer()) {
            if (!entityMode.toString().equals(tuplizer.getEntityMode())) continue;
            return tuplizer;
        }
        return null;
    }

    int getOptimisticLockMode(org.dom4j.Attribute olAtt) throws MappingException {
        if (olAtt == null) {
            return 0;
        }
        String olMode = olAtt.getValue();
        if (olMode == null || "version".equals(olMode)) {
            return 0;
        }
        if ("dirty".equals(olMode)) {
            return 1;
        }
        if ("all".equals(olMode)) {
            return 2;
        }
        if ("none".equals(olMode)) {
            return -1;
        }
        throw new MappingException("Unsupported optimistic-lock style: " + olMode);
    }

    protected String getClassTableName(XMLHibernateMapping.XMLClass entityClazz, EntityBinding entityBinding, Table denormalizedSuperTable) {
        String physicalTableName;
        String entityName = entityBinding.getEntity().getName();
        if (entityClazz.getTable() == null) {
            String logicalTableName = StringHelper.unqualify(entityName);
            physicalTableName = this.getHibernateXmlBinder().getMetadata().getNamingStrategy().classToTableName(entityName);
        } else {
            String logicalTableName = entityClazz.getTable();
            physicalTableName = this.getHibernateXmlBinder().getMetadata().getNamingStrategy().tableName(logicalTableName);
        }
        return physicalTableName;
    }

    protected void buildAttributeBindings(XMLHibernateMapping.XMLClass entityClazz, EntityBinding entityBinding) {
        this.buildAttributeBindings(entityClazz, entityBinding, null, true, true);
    }

    protected void buildAttributeBindings(XMLHibernateMapping.XMLClass entityClazz, EntityBinding entityBinding, UniqueKey uniqueKey, boolean mutable, boolean nullable) {
        boolean naturalId = uniqueKey != null;
        String entiytName = entityBinding.getEntity().getName();
        TableSpecification tabe = entityBinding.getBaseTable();
        AbstractAttributeBinding attributeBinding = null;
        for (Object object : entityClazz.getPropertyOrManyToOneOrOneToOne()) {
            Object collection;
            if (XMLBagElement.class.isInstance(object)) {
                collection = (XMLBagElement)XMLBagElement.class.cast(object);
                BagBinding collectionBinding = entityBinding.makeBagAttributeBinding(((XMLBagElement)collection).getName());
                this.bindBag((XMLBagElement)collection, collectionBinding, entityBinding);
                this.hibernateMappingBinder.getHibernateXmlBinder().getMetadata().addCollection(collectionBinding);
                attributeBinding = collectionBinding;
                continue;
            }
            if (XMLIdbagElement.class.isInstance(object)) {
                collection = (XMLIdbagElement)XMLIdbagElement.class.cast(object);
                continue;
            }
            if (XMLSetElement.class.isInstance(object)) {
                collection = (XMLSetElement)XMLSetElement.class.cast(object);
                continue;
            }
            if (XMLListElement.class.isInstance(object)) {
                collection = (XMLListElement)XMLListElement.class.cast(object);
                continue;
            }
            if (XMLMapElement.class.isInstance(object)) {
                collection = (XMLMapElement)XMLMapElement.class.cast(object);
                continue;
            }
            if (XMLManyToOneElement.class.isInstance(object)) {
                XMLManyToOneElement manyToOne = (XMLManyToOneElement)XMLManyToOneElement.class.cast(object);
                ManyToOneAttributeBinding manyToOneBinding = entityBinding.makeManyToOneAttributeBinding(manyToOne.getName());
                this.bindManyToOne(manyToOne, manyToOneBinding, entityBinding);
                attributeBinding = manyToOneBinding;
                continue;
            }
            if (XMLAnyElement.class.isInstance(object) || XMLOneToOneElement.class.isInstance(object)) continue;
            if (XMLPropertyElement.class.isInstance(object)) {
                XMLPropertyElement property = (XMLPropertyElement)XMLPropertyElement.class.cast(object);
                SimpleAttributeBinding binding = entityBinding.makeSimpleAttributeBinding(property.getName());
                this.bindSimpleAttribute(property, binding, entityBinding);
                attributeBinding = binding;
                continue;
            }
            if (!XMLComponentElement.class.isInstance(object) && !XMLDynamicComponentElement.class.isInstance(object) && !XMLPropertiesElement.class.isInstance(object)) continue;
        }
        for (XMLJoinElement xMLJoinElement : entityClazz.getJoin()) {
        }
        for (XMLSubclassElement xMLSubclassElement : entityClazz.getSubclass()) {
        }
        for (XMLJoinedSubclassElement xMLJoinedSubclassElement : entityClazz.getJoinedSubclass()) {
        }
        for (XMLUnionSubclassElement xMLUnionSubclassElement : entityClazz.getUnionSubclass()) {
        }
        for (XMLFilterElement xMLFilterElement : entityClazz.getFilter()) {
        }
        if (entityClazz.getNaturalId() != null) {
            // empty if block
        }
        if (entityClazz.getQueryOrSqlQuery() != null) {
            for (Object object : entityClazz.getQueryOrSqlQuery()) {
                if (!XMLQueryElement.class.isInstance(object) && !XMLSqlQueryElement.class.isInstance(object)) continue;
            }
        }
        if (entityClazz.getResultset() != null) {
            for (XMLResultsetElement xMLResultsetElement : entityClazz.getResultset()) {
            }
        }
    }

    protected void bindSimpleAttribute(XMLHibernateMapping.XMLClass.XMLId id, SimpleAttributeBinding attributeBinding, EntityBinding entityBinding, String attributeName) {
        if (attributeBinding.getAttribute() == null) {
            attributeBinding.initialize(new HbmSimpleAttributeDomainState((MappingDefaults)this.hibernateMappingBinder, (Attribute)entityBinding.getEntity().getOrCreateSingularAttribute(attributeName), entityBinding.getMetaAttributes(), id));
        }
        if (attributeBinding.getValue() == null) {
            attributeBinding.initializeSimpleTupleValue(new HbmSimpleValueRelationalStateContainer((MappingDefaults)this.getHibernateMappingBinder(), true, id));
        }
    }

    protected void bindSimpleAttribute(XMLHibernateMapping.XMLClass.XMLDiscriminator discriminator, SimpleAttributeBinding attributeBinding, EntityBinding entityBinding, String attributeName) {
        if (attributeBinding.getAttribute() == null) {
            attributeBinding.initialize(new HbmSimpleAttributeDomainState((MappingDefaults)this.hibernateMappingBinder, (Attribute)entityBinding.getEntity().getOrCreateSingularAttribute(attributeName), entityBinding.getMetaAttributes(), discriminator));
        }
        if (attributeBinding.getValue() == null) {
            attributeBinding.initializeSimpleTupleValue(new HbmSimpleValueRelationalStateContainer((MappingDefaults)this.getHibernateMappingBinder(), true, discriminator));
        }
    }

    protected void bindSimpleAttribute(XMLHibernateMapping.XMLClass.XMLVersion version, SimpleAttributeBinding attributeBinding, EntityBinding entityBinding, String attributeName) {
        if (attributeBinding.getAttribute() == null) {
            attributeBinding.initialize(new HbmSimpleAttributeDomainState((MappingDefaults)this.hibernateMappingBinder, (Attribute)entityBinding.getEntity().getOrCreateSingularAttribute(attributeName), entityBinding.getMetaAttributes(), version));
        }
        if (attributeBinding.getValue() == null) {
            attributeBinding.initializeSimpleTupleValue(new HbmSimpleValueRelationalStateContainer((MappingDefaults)this.getHibernateMappingBinder(), true, version));
        }
    }

    protected void bindSimpleAttribute(XMLHibernateMapping.XMLClass.XMLTimestamp timestamp, SimpleAttributeBinding attributeBinding, EntityBinding entityBinding, String attributeName) {
        if (attributeBinding.getAttribute() == null) {
            attributeBinding.initialize(new HbmSimpleAttributeDomainState((MappingDefaults)this.hibernateMappingBinder, (Attribute)entityBinding.getEntity().getOrCreateSingularAttribute(attributeName), entityBinding.getMetaAttributes(), timestamp));
        }
        if (attributeBinding.getValue() == null) {
            attributeBinding.initializeSimpleTupleValue(new HbmSimpleValueRelationalStateContainer((MappingDefaults)this.getHibernateMappingBinder(), true, timestamp));
        }
    }

    protected void bindSimpleAttribute(XMLPropertyElement property, SimpleAttributeBinding attributeBinding, EntityBinding entityBinding) {
        if (attributeBinding.getAttribute() == null) {
            attributeBinding.initialize(new HbmSimpleAttributeDomainState((MappingDefaults)this.hibernateMappingBinder, (Attribute)entityBinding.getEntity().getOrCreateSingularAttribute(property.getName()), entityBinding.getMetaAttributes(), property));
        }
        if (attributeBinding.getValue() == null) {
            attributeBinding.initializeSimpleTupleValue(new HbmSimpleValueRelationalStateContainer((MappingDefaults)this.getHibernateMappingBinder(), true, property));
        }
    }

    protected void bindBag(XMLBagElement collection, PluralAttributeBinding collectionBinding, EntityBinding entityBinding) {
        if (collectionBinding.getAttribute() == null) {
            collectionBinding.initialize(new HbmPluralAttributeDomainState(this.hibernateMappingBinder, collection, entityBinding.getMetaAttributes(), entityBinding.getEntity().getOrCreatePluralAttribute(collection.getName(), PluralAttributeNature.BAG)));
        }
        if (collectionBinding.getValue() == null) {
            // empty if block
        }
    }

    private void bindManyToOne(XMLManyToOneElement manyToOne, ManyToOneAttributeBinding attributeBinding, EntityBinding entityBinding) {
        if (attributeBinding.getAttribute() == null) {
            attributeBinding.initialize(new HbmManyToOneAttributeDomainState(this.hibernateMappingBinder, entityBinding.getEntity().getOrCreateSingularAttribute(manyToOne.getName()), entityBinding.getMetaAttributes(), manyToOne));
        }
        if (attributeBinding.getValue() == null) {
            attributeBinding.initialize(new HbmManyToOneRelationalStateContainer((MappingDefaults)this.getHibernateMappingBinder(), true, manyToOne));
        }
    }
}

