/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.annotations.state.relational;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.hibernate.AnnotationException;
import org.hibernate.AssertionFailure;
import org.hibernate.cfg.NamingStrategy;
import org.hibernate.metamodel.binding.AttributeBinding;
import org.hibernate.metamodel.relational.Size;
import org.hibernate.metamodel.source.annotations.ColumnValues;
import org.hibernate.metamodel.source.annotations.HibernateDotNames;
import org.hibernate.metamodel.source.annotations.MappedAttribute;
import org.hibernate.metamodel.source.internal.MetadataImpl;
import org.jboss.jandex.AnnotationInstance;

public class AttributeColumnRelationalState
implements AttributeBinding.ColumnRelationalState {
    private final NamingStrategy namingStrategy;
    private final String columnName;
    private final boolean unique;
    private final boolean nullable;
    private final Size size;
    private final String checkCondition;
    private final String customWriteFragment;
    private final String customReadFragment;
    private String defaultString;
    private String sqlType;
    private String comment;
    private Set<String> uniqueKeys = new HashSet<String>();
    private Set<String> indexes = new HashSet<String>();

    public AttributeColumnRelationalState(MappedAttribute attribute, MetadataImpl meta) {
        ColumnValues columnValues = attribute.getColumnValues();
        this.namingStrategy = meta.getNamingStrategy();
        this.columnName = columnValues.getName().isEmpty() ? attribute.getName() : columnValues.getName();
        this.unique = columnValues.isUnique();
        this.nullable = columnValues.isNullable();
        this.size = this.createSize(columnValues.getLength(), columnValues.getScale(), columnValues.getPrecision());
        List<AnnotationInstance> checkAnnotations = attribute.annotations(HibernateDotNames.CHECK);
        if (checkAnnotations.size() > 1) {
            throw new AssertionFailure("There cannot be more than one @Check annotation per mapped attribute");
        }
        this.checkCondition = checkAnnotations.size() == 1 ? checkAnnotations.get(0).value("constraints").toString() : null;
        List<AnnotationInstance> columnTransformerAnnotations = this.getAllColumnTransformerAnnotations(attribute);
        String[] readWrite = this.createCustomReadWrite(columnTransformerAnnotations);
        this.customReadFragment = readWrite[0];
        this.customWriteFragment = readWrite[1];
    }

    @Override
    public NamingStrategy getNamingStrategy() {
        return this.namingStrategy;
    }

    @Override
    public String getExplicitColumnName() {
        return this.columnName;
    }

    @Override
    public boolean isUnique() {
        return this.unique;
    }

    @Override
    public Size getSize() {
        return this.size;
    }

    @Override
    public boolean isNullable() {
        return this.nullable;
    }

    @Override
    public String getCheckCondition() {
        return this.checkCondition;
    }

    @Override
    public String getDefault() {
        return this.defaultString;
    }

    @Override
    public String getSqlType() {
        return this.sqlType;
    }

    @Override
    public String getCustomWriteFragment() {
        return this.customWriteFragment;
    }

    @Override
    public String getCustomReadFragment() {
        return this.customReadFragment;
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    @Override
    public Set<String> getUniqueKeys() {
        return this.uniqueKeys;
    }

    @Override
    public Set<String> getIndexes() {
        return this.indexes;
    }

    private Size createSize(int length, int scale, int precision) {
        Size size = new Size();
        size.setLength(length);
        size.setScale(scale);
        size.setPrecision(precision);
        return size;
    }

    private List<AnnotationInstance> getAllColumnTransformerAnnotations(MappedAttribute attribute) {
        List<AnnotationInstance> columnTransformerAnnotations;
        ArrayList<AnnotationInstance> allColumnTransformerAnnotations = new ArrayList<AnnotationInstance>();
        List<AnnotationInstance> columnTransformersAnnotations = attribute.annotations(HibernateDotNames.COLUMN_TRANSFORMERS);
        if (columnTransformersAnnotations.size() > 1) {
            throw new AssertionFailure("There cannot be more than one @ColumnTransformers annotation per mapped attribute");
        }
        if (columnTransformersAnnotations.size() == 1) {
            AnnotationInstance[] annotationInstances = ((AnnotationInstance)allColumnTransformerAnnotations.get(0)).value().asNestedArray();
            allColumnTransformerAnnotations.addAll(Arrays.asList(annotationInstances));
        }
        if ((columnTransformerAnnotations = attribute.annotations(HibernateDotNames.COLUMN_TRANSFORMER)).size() > 1) {
            throw new AssertionFailure("There cannot be more than one @ColumnTransformer annotation per mapped attribute");
        }
        if (columnTransformerAnnotations.size() == 1) {
            allColumnTransformerAnnotations.add(columnTransformerAnnotations.get(0));
        }
        return allColumnTransformerAnnotations;
    }

    private String[] createCustomReadWrite(List<AnnotationInstance> columnTransformerAnnotations) {
        String[] readWrite = new String[2];
        boolean alreadyProcessedForColumn = false;
        for (AnnotationInstance annotationInstance : columnTransformerAnnotations) {
            String forColumn;
            String string = forColumn = annotationInstance.value("forColumn") == null ? null : annotationInstance.value("forColumn").asString();
            if (forColumn != null && !forColumn.equals(this.columnName)) continue;
            if (alreadyProcessedForColumn) {
                throw new AnnotationException("Multiple definition of read/write conditions for column " + this.columnName);
            }
            readWrite[0] = annotationInstance.value("read") == null ? null : annotationInstance.value("read").asString();
            readWrite[1] = annotationInstance.value("write") == null ? null : annotationInstance.value("write").asString();
            alreadyProcessedForColumn = true;
        }
        return readWrite;
    }
}

