/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.annotations.global;

import java.util.Arrays;
import java.util.List;
import org.hibernate.MappingException;
import org.hibernate.annotations.FetchMode;
import org.hibernate.mapping.MetadataSource;
import org.hibernate.metamodel.binding.FetchProfile;
import org.hibernate.metamodel.source.annotations.HibernateDotNames;
import org.hibernate.metamodel.source.internal.MetadataImpl;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.Index;

public class FetchProfileBinder {
    private FetchProfileBinder() {
    }

    public static void bindFetchProfiles(MetadataImpl meta, Index index) {
        List fetchProfilesAnnotations = index.getAnnotations(HibernateDotNames.FETCH_PROFILES);
        for (AnnotationInstance fetchProfilesAnnotation : fetchProfilesAnnotations) {
            AnnotationInstance[] fetchProfiles = fetchProfilesAnnotation.value().asNestedArray();
            FetchProfileBinder.bindFetchProfileAnnotations(meta, Arrays.asList(fetchProfiles));
        }
        List fetchProfileAnnotations = index.getAnnotations(HibernateDotNames.FETCH_PROFILE);
        FetchProfileBinder.bindFetchProfileAnnotations(meta, fetchProfileAnnotations);
    }

    private static void bindFetchProfileAnnotations(MetadataImpl meta, List<AnnotationInstance> fetchProfileAnnotations) {
        for (AnnotationInstance fetchProfileAnnotation : fetchProfileAnnotations) {
            AnnotationInstance[] overrides;
            String name = fetchProfileAnnotation.value("name").asString();
            FetchProfile profile = meta.findOrCreateFetchProfile(name, MetadataSource.ANNOTATIONS);
            for (AnnotationInstance overrideAnnotation : overrides = fetchProfileAnnotation.value("fetchOverrides").asNestedArray()) {
                FetchMode fetchMode = Enum.valueOf(FetchMode.class, overrideAnnotation.value("mode").asEnum());
                if (!fetchMode.equals((Object)FetchMode.JOIN)) {
                    throw new MappingException("Only FetchMode.JOIN is currently supported");
                }
                String entityClassName = overrideAnnotation.value("entity").asClass().name().toString();
                String associationName = overrideAnnotation.value("association").asString();
                profile.addFetch(entityClassName, associationName, fetchMode.toString().toLowerCase());
            }
        }
    }
}

