/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.annotations;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.hibernate.AssertionFailure;
import org.hibernate.metamodel.source.annotations.ColumnValues;
import org.hibernate.metamodel.source.annotations.JPADotNames;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.DotName;

public class MappedAttribute
implements Comparable<MappedAttribute> {
    private final String name;
    private final Class<?> type;
    private final Map<DotName, List<AnnotationInstance>> annotations;
    private final ColumnValues columnValues;
    private final boolean isId;
    private final boolean isVersioned;

    MappedAttribute(String name, Class<?> type, Map<DotName, List<AnnotationInstance>> annotations) {
        this.name = name;
        this.type = type;
        this.annotations = annotations;
        List<AnnotationInstance> idAnnotations = annotations.get(JPADotNames.ID);
        this.isId = idAnnotations != null && !idAnnotations.isEmpty();
        List<AnnotationInstance> versionAnnotations = annotations.get(JPADotNames.VERSION);
        this.isVersioned = versionAnnotations != null && !versionAnnotations.isEmpty();
        List<AnnotationInstance> columnAnnotations = annotations.get(JPADotNames.COLUMN);
        if (columnAnnotations != null && columnAnnotations.size() > 1) {
            throw new AssertionFailure("There can only be one @Column annotation per mapped attribute");
        }
        AnnotationInstance columnAnnotation = columnAnnotations == null ? null : columnAnnotations.get(0);
        this.columnValues = new ColumnValues(columnAnnotation, this.isId);
    }

    public final String getName() {
        return this.name;
    }

    public final Class<?> getType() {
        return this.type;
    }

    public final ColumnValues getColumnValues() {
        return this.columnValues;
    }

    public boolean isId() {
        return this.isId;
    }

    public boolean isVersioned() {
        return this.isVersioned;
    }

    public final List<AnnotationInstance> annotations(DotName annotationDotName) {
        if (this.annotations.containsKey(annotationDotName)) {
            return this.annotations.get(annotationDotName);
        }
        return Collections.emptyList();
    }

    @Override
    public int compareTo(MappedAttribute mappedProperty) {
        return this.name.compareTo(mappedProperty.getName());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MappedProperty");
        sb.append("{name='").append(this.name).append('\'');
        sb.append(", type=").append(this.type);
        sb.append('}');
        return sb.toString();
    }
}

