/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.annotations;

import java.util.List;
import org.hibernate.AssertionFailure;
import org.hibernate.MappingException;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.metamodel.binding.EntityBinding;
import org.hibernate.metamodel.binding.SimpleAttributeBinding;
import org.hibernate.metamodel.domain.Entity;
import org.hibernate.metamodel.domain.Hierarchical;
import org.hibernate.metamodel.relational.Identifier;
import org.hibernate.metamodel.relational.Schema;
import org.hibernate.metamodel.relational.Table;
import org.hibernate.metamodel.source.annotations.ConfiguredClass;
import org.hibernate.metamodel.source.annotations.HibernateDotNames;
import org.hibernate.metamodel.source.annotations.JPADotNames;
import org.hibernate.metamodel.source.annotations.MappedAttribute;
import org.hibernate.metamodel.source.annotations.state.domain.AttributeDomainState;
import org.hibernate.metamodel.source.annotations.state.relational.AttributeColumnRelationalState;
import org.hibernate.metamodel.source.annotations.state.relational.AttributeTupleRelationalState;
import org.hibernate.metamodel.source.annotations.util.JandexHelper;
import org.hibernate.metamodel.source.internal.MetadataImpl;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;

public class EntityBinder {
    private final ConfiguredClass configuredClass;
    private final MetadataImpl meta;
    private final Schema.Name schemaName;

    public EntityBinder(MetadataImpl metadata, ConfiguredClass configuredClass) {
        this.configuredClass = configuredClass;
        this.meta = metadata;
        EntityBinding entityBinding = new EntityBinding();
        this.bindJpaEntityAnnotation(entityBinding);
        this.bindHibernateEntityAnnotation(entityBinding);
        this.bindWhereFilter(entityBinding);
        this.schemaName = this.createSchemaName();
        this.bindTable(entityBinding);
        if (configuredClass.isRoot()) {
            this.bindId(entityBinding);
        }
        this.bindAttributes(entityBinding);
        this.meta.addEntity(entityBinding);
    }

    private void bindWhereFilter(EntityBinding entityBinding) {
        AnnotationInstance whereAnnotation = JandexHelper.getSingleAnnotation(this.configuredClass.getClassInfo(), HibernateDotNames.WHERE);
        if (whereAnnotation != null) {
            String clause = whereAnnotation.value("clause").asString();
            entityBinding.setWhereFilter(clause);
        }
    }

    private Schema.Name createSchemaName() {
        String schema = null;
        String catalog = null;
        AnnotationInstance tableAnnotation = JandexHelper.getSingleAnnotation(this.configuredClass.getClassInfo(), JPADotNames.TABLE);
        if (tableAnnotation != null) {
            AnnotationValue schemaValue = tableAnnotation.value("schema");
            AnnotationValue catalogValue = tableAnnotation.value("catalog");
            schema = schemaValue != null ? schemaValue.asString() : null;
            catalog = catalogValue != null ? catalogValue.asString() : null;
        }
        return new Schema.Name(schema, catalog);
    }

    private void bindTable(EntityBinding entityBinding) {
        AnnotationInstance checkAnnotation;
        Identifier tableName;
        Schema schema = this.meta.getDatabase().getSchema(this.schemaName);
        Table table = schema.getTable(tableName = Identifier.toIdentifier(this.configuredClass.getPrimaryTableName()));
        if (table == null) {
            table = schema.createTable(tableName);
        }
        entityBinding.setBaseTable(table);
        AnnotationInstance hibernateTableAnnotation = JandexHelper.getSingleAnnotation(this.configuredClass.getClassInfo(), HibernateDotNames.TABLE);
        if (hibernateTableAnnotation != null && hibernateTableAnnotation.value("comment") != null) {
            table.addComment(hibernateTableAnnotation.value("comment").asString().trim());
        }
        if ((checkAnnotation = JandexHelper.getSingleAnnotation(this.configuredClass.getClassInfo(), HibernateDotNames.CHECK)) != null) {
            table.addCheckConstraint(checkAnnotation.value("constraints").asString());
        }
    }

    private void bindId(EntityBinding entityBinding) {
        switch (this.determineIdType()) {
            case SIMPLE: {
                this.bindSingleIdAnnotation(entityBinding);
                break;
            }
            case COMPOSED: {
                break;
            }
            case EMBEDDED: {
                break;
            }
        }
    }

    private void bindJpaEntityAnnotation(EntityBinding entityBinding) {
        AnnotationInstance jpaEntityAnnotation = JandexHelper.getSingleAnnotation(this.configuredClass.getClassInfo(), JPADotNames.ENTITY);
        String name = jpaEntityAnnotation.value("name") == null ? StringHelper.unqualify(this.configuredClass.getName()) : jpaEntityAnnotation.value("name").asString();
        entityBinding.setEntity(new Entity(name, this.getSuperType()));
    }

    private void bindSingleIdAnnotation(EntityBinding entityBinding) {
        AnnotationInstance idAnnotation = JandexHelper.getSingleAnnotation(this.configuredClass.getClassInfo(), JPADotNames.ID);
        String idName = JandexHelper.getPropertyName(idAnnotation.target());
        entityBinding.getEntity().getOrCreateSingularAttribute(idName);
        SimpleAttributeBinding idBinding = entityBinding.makeSimplePrimaryKeyAttributeBinding(idName);
        MappedAttribute idAttribute = this.configuredClass.getMappedProperty(idName);
        AttributeDomainState domainState = new AttributeDomainState(entityBinding, idAttribute);
        idBinding.initialize(domainState);
        AttributeColumnRelationalState columnRelationsState = new AttributeColumnRelationalState(idAttribute, this.meta);
        AttributeTupleRelationalState relationalState = new AttributeTupleRelationalState();
        relationalState.addValueState(columnRelationsState);
        idBinding.initializeSimpleTupleValue(relationalState);
    }

    private void bindAttributes(EntityBinding entityBinding) {
        for (MappedAttribute mappedAttribute : this.configuredClass.getMappedAttributes()) {
            if (mappedAttribute.isId()) continue;
            String attributeName = mappedAttribute.getName();
            entityBinding.getEntity().getOrCreateSingularAttribute(attributeName);
            SimpleAttributeBinding attributeBinding = mappedAttribute.isVersioned() ? entityBinding.makeVersionBinding(attributeName) : entityBinding.makeSimpleAttributeBinding(attributeName);
            AttributeDomainState domainState = new AttributeDomainState(entityBinding, mappedAttribute);
            attributeBinding.initialize(domainState);
            AttributeColumnRelationalState columnRelationsState = new AttributeColumnRelationalState(mappedAttribute, this.meta);
            AttributeTupleRelationalState relationalState = new AttributeTupleRelationalState();
            relationalState.addValueState(columnRelationsState);
            attributeBinding.initializeSimpleTupleValue(relationalState);
        }
    }

    private void bindHibernateEntityAnnotation(EntityBinding entityBinding) {
        AnnotationInstance hibernateEntityAnnotation = JandexHelper.getSingleAnnotation(this.configuredClass.getClassInfo(), HibernateDotNames.ENTITY);
    }

    private Hierarchical getSuperType() {
        ConfiguredClass parent = this.configuredClass.getParent();
        if (parent == null) {
            return null;
        }
        EntityBinding parentBinding = this.meta.getEntityBinding(parent.getName());
        if (parentBinding == null) {
            throw new AssertionFailure("Parent entity " + parent.getName() + " of entity " + this.configuredClass.getName() + "not yet created!");
        }
        return parentBinding.getEntity();
    }

    private IdType determineIdType() {
        List idAnnotations = (List)this.configuredClass.getClassInfo().annotations().get(JPADotNames.ENTITY);
        List embeddedIdAnnotations = (List)this.configuredClass.getClassInfo().annotations().get(JPADotNames.EMBEDDED_ID);
        if (idAnnotations != null && embeddedIdAnnotations != null) {
            throw new MappingException("@EmbeddedId and @Id cannot be used together. Check the configuration for " + this.configuredClass.getName() + ".");
        }
        if (embeddedIdAnnotations != null) {
            if (embeddedIdAnnotations.size() == 1) {
                return IdType.EMBEDDED;
            }
            throw new MappingException("Multiple @EmbeddedId annotations are not allowed");
        }
        if (idAnnotations != null) {
            if (idAnnotations.size() == 1) {
                return IdType.SIMPLE;
            }
            return IdType.COMPOSED;
        }
        return IdType.NONE;
    }

    static enum IdType {
        SIMPLE,
        COMPOSED,
        EMBEDDED,
        NONE;

    }
}

