/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.annotations;

import java.util.Set;
import org.hibernate.metamodel.source.annotations.ConfiguredClass;
import org.hibernate.metamodel.source.annotations.ConfiguredClassHierarchy;
import org.hibernate.metamodel.source.annotations.EntityBinder;
import org.hibernate.metamodel.source.annotations.global.FetchProfileBinder;
import org.hibernate.metamodel.source.annotations.util.ConfiguredClassHierarchyBuilder;
import org.hibernate.metamodel.source.internal.MetadataImpl;
import org.jboss.jandex.Index;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnotationBinder {
    private static final Logger log = LoggerFactory.getLogger(AnnotationBinder.class);
    private final MetadataImpl metadata;

    public AnnotationBinder(MetadataImpl metadata) {
        this.metadata = metadata;
    }

    public void bindGlobalAnnotations(Index annotationIndex) {
        FetchProfileBinder.bindFetchProfiles(this.metadata, annotationIndex);
    }

    public void bindMappedClasses(Index annotationIndex) {
        Set<ConfiguredClassHierarchy> hierarchies = ConfiguredClassHierarchyBuilder.createEntityHierarchies(annotationIndex, this.metadata.getServiceRegistry());
        for (ConfiguredClassHierarchy hierarchy : hierarchies) {
            for (ConfiguredClass entity : hierarchy) {
                this.bindEntity(entity);
            }
        }
    }

    public void bindEntity(ConfiguredClass entity) {
        log.info("Binding entity from annotated class: {}", (Object)entity.getName());
        EntityBinder entityBinder = new EntityBinder(this.metadata, entity);
    }
}

