/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.domain;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import org.hibernate.metamodel.domain.Attribute;
import org.hibernate.metamodel.domain.AttributeContainer;
import org.hibernate.metamodel.domain.Hierarchical;
import org.hibernate.metamodel.domain.IndexedPluralAttribute;
import org.hibernate.metamodel.domain.PluralAttribute;
import org.hibernate.metamodel.domain.PluralAttributeNature;
import org.hibernate.metamodel.domain.SingularAttribute;
import org.hibernate.metamodel.domain.Type;

public abstract class AbstractAttributeContainer
implements AttributeContainer,
Hierarchical {
    private final String name;
    private final Hierarchical superType;
    private LinkedHashSet<Attribute> attributeSet = new LinkedHashSet();
    private HashMap<String, Attribute> attributeMap = new HashMap();

    public AbstractAttributeContainer(String name, Hierarchical superType) {
        this.name = name;
        this.superType = superType;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Hierarchical getSuperType() {
        return this.superType;
    }

    @Override
    public Set<Attribute> getAttributes() {
        return Collections.unmodifiableSet(this.attributeSet);
    }

    @Override
    public Attribute getAttribute(String name) {
        return this.attributeMap.get(name);
    }

    @Override
    public SingularAttribute getOrCreateSingularAttribute(String name) {
        SingularAttribute attribute = (SingularAttribute)this.getAttribute(name);
        if (attribute == null) {
            attribute = new SingularAttributeImpl(name, this);
            this.addAttribute(attribute);
        }
        return attribute;
    }

    @Override
    public PluralAttribute getOrCreateBag(String name) {
        return this.getOrCreatePluralAttribute(name, PluralAttributeNature.BAG);
    }

    @Override
    public PluralAttribute getOrCreateSet(String name) {
        return this.getOrCreatePluralAttribute(name, PluralAttributeNature.SET);
    }

    @Override
    public IndexedPluralAttribute getOrCreateList(String name) {
        return (IndexedPluralAttribute)this.getOrCreatePluralAttribute(name, PluralAttributeNature.LIST);
    }

    @Override
    public IndexedPluralAttribute getOrCreateMap(String name) {
        return (IndexedPluralAttribute)this.getOrCreatePluralAttribute(name, PluralAttributeNature.MAP);
    }

    @Override
    public PluralAttribute getOrCreatePluralAttribute(String name, PluralAttributeNature nature) {
        PluralAttribute attribute = (PluralAttribute)this.getAttribute(name);
        if (attribute == null) {
            attribute = nature.isIndexed() ? new IndexedPluralAttributeImpl(name, nature, this) : new PluralAttributeImpl(name, nature, this);
            this.addAttribute(attribute);
        }
        return attribute;
    }

    protected void addAttribute(Attribute attribute) {
        if (this.attributeMap.put(attribute.getName(), attribute) != null) {
            throw new IllegalArgumentException("Attrtibute with name [" + attribute.getName() + "] already registered");
        }
        this.attributeSet.add(attribute);
    }

    public static class IndexedPluralAttributeImpl
    extends PluralAttributeImpl
    implements IndexedPluralAttribute {
        private Type indexType;

        public IndexedPluralAttributeImpl(String name, PluralAttributeNature nature, AttributeContainer attributeContainer) {
            super(name, nature, attributeContainer);
        }

        @Override
        public Type getIndexType() {
            return this.indexType;
        }

        @Override
        public void setIndexType(Type indexType) {
            this.indexType = indexType;
        }
    }

    public static class PluralAttributeImpl
    implements PluralAttribute {
        private final AttributeContainer attributeContainer;
        private final PluralAttributeNature nature;
        private final String name;
        private Type elementType;

        public PluralAttributeImpl(String name, PluralAttributeNature nature, AttributeContainer attributeContainer) {
            this.name = name;
            this.nature = nature;
            this.attributeContainer = attributeContainer;
        }

        @Override
        public AttributeContainer getAttributeContainer() {
            return this.attributeContainer;
        }

        @Override
        public boolean isSingular() {
            return false;
        }

        @Override
        public PluralAttributeNature getNature() {
            return this.nature;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Type getElementType() {
            return this.elementType;
        }

        @Override
        public void setElementType(Type elementType) {
            this.elementType = elementType;
        }
    }

    public static class SingularAttributeImpl
    implements SingularAttribute {
        private final AttributeContainer attributeContainer;
        private final String name;

        public SingularAttributeImpl(String name, AttributeContainer attributeContainer) {
            this.name = name;
            this.attributeContainer = attributeContainer;
        }

        @Override
        public Type getSingularAttributeType() {
            return null;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public AttributeContainer getAttributeContainer() {
            return this.attributeContainer;
        }

        @Override
        public boolean isSingular() {
            return true;
        }
    }
}

