/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.binding;

import java.util.Iterator;
import org.hibernate.MappingException;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.metamodel.binding.AttributeBinding;
import org.hibernate.metamodel.binding.EntityBinding;
import org.hibernate.metamodel.binding.EntityReferencingAttributeBinding;
import org.hibernate.metamodel.binding.SingularAttributeBinding;
import org.hibernate.metamodel.relational.Column;
import org.hibernate.metamodel.relational.ForeignKey;
import org.hibernate.metamodel.relational.SimpleValue;

public class ManyToOneAttributeBinding
extends SingularAttributeBinding
implements EntityReferencingAttributeBinding {
    private boolean isLogicalOneToOne;
    private boolean isPropertyReference;
    private String foreignKeyName;
    private String referencedAttributeName;
    private String referencedEntityName;
    private AttributeBinding referencedAttributeBinding;
    private boolean ignoreNotFound;

    ManyToOneAttributeBinding(EntityBinding entityBinding) {
        super(entityBinding, false, false);
    }

    public final void initialize(DomainState state) {
        super.initialize(state);
        this.isPropertyReference = state.getReferencedAttributeName() != null;
        this.referencedAttributeName = state.getReferencedAttributeName();
        this.referencedEntityName = state.getReferencedEntityName();
        if (this.referencedEntityName == null) {
            this.referencedEntityName = ReflectHelper.reflectedPropertyClass(this.getEntityBinding().getEntity().getName(), state.getAttribute().getName()).getName();
        }
    }

    public final void initialize(RelationalState state) {
        super.initialize(state);
        this.isLogicalOneToOne = state.isLogicalOneToOne();
        this.foreignKeyName = state.getForeignKeyName();
    }

    @Override
    public final boolean isPropertyReference() {
        return this.isPropertyReference;
    }

    @Override
    public final String getReferencedEntityName() {
        return this.referencedEntityName;
    }

    @Override
    public final String getReferencedAttributeName() {
        if (this.referencedAttributeName == null) {
            throw new IllegalStateException("Referenced attribute name is not available.");
        }
        return this.referencedAttributeName;
    }

    @Override
    public final boolean isReferenceResolved() {
        return this.referencedAttributeBinding != null;
    }

    @Override
    public final EntityBinding getReferencedEntityBinding() {
        if (!this.isReferenceResolved()) {
            throw new IllegalStateException("EntityBinding reference has not be referenced.");
        }
        return this.referencedAttributeBinding.getEntityBinding();
    }

    @Override
    public final void resolveReference(AttributeBinding referencedAttributeBinding) {
        if (!this.referencedEntityName.equals(referencedAttributeBinding.getEntityBinding().getEntity().getName())) {
            throw new IllegalStateException("attempt to set EntityBinding with name: [" + referencedAttributeBinding.getEntityBinding().getEntity().getName() + "; entity name should be: " + this.referencedEntityName);
        }
        if (this.referencedAttributeName == null) {
            this.referencedAttributeName = referencedAttributeBinding.getAttribute().getName();
        } else if (!this.referencedAttributeName.equals(referencedAttributeBinding.getAttribute().getName())) {
            throw new IllegalStateException("Inconsistent attribute name; expected: " + this.referencedAttributeName + "actual: " + referencedAttributeBinding.getAttribute().getName());
        }
        this.referencedAttributeBinding = referencedAttributeBinding;
        this.buildForeignKey();
    }

    private void buildForeignKey() {
        ForeignKey foreignKey = this.getTable().createForeignKey(this.referencedAttributeBinding.getTable(), this.foreignKeyName);
        Iterator<SimpleValue> referencingValueIterator = this.getValues().iterator();
        Iterator<SimpleValue> targetValueIterator = this.referencedAttributeBinding.getValues().iterator();
        while (referencingValueIterator.hasNext()) {
            if (!targetValueIterator.hasNext()) {
                throw new MappingException("number of values in many-to-one reference is greater than number of values in target");
            }
            SimpleValue referencingValue = referencingValueIterator.next();
            SimpleValue targetValue = targetValueIterator.next();
            if (Column.class.isInstance(referencingValue)) {
                if (!Column.class.isInstance(targetValue)) {
                    throw new MappingException("referencing value is a column, but target is not a column");
                }
                foreignKey.addColumnMapping((Column)Column.class.cast(referencingValue), (Column)Column.class.cast(targetValue));
                continue;
            }
            if (!Column.class.isInstance(targetValue)) continue;
            throw new MappingException("referencing value is not a column, but target is a column.");
        }
        if (targetValueIterator.hasNext()) {
            throw new MappingException("target value has more simple values than referencing value");
        }
    }

    @Override
    public boolean isSimpleValue() {
        return false;
    }

    @Override
    public void validate() {
        if (this.getCascade() != null && this.getCascade().indexOf("delete-orphan") >= 0 && !this.isLogicalOneToOne) {
            throw new MappingException("many-to-one attribute [" + this.getAttribute().getName() + "] does not support orphan delete as it is not unique");
        }
    }

    public static interface RelationalState
    extends AttributeBinding.RelationalState {
        public boolean isLogicalOneToOne();

        public String getForeignKeyName();
    }

    public static interface DomainState
    extends SingularAttributeBinding.DomainState {
        public boolean isUnwrapProxy();

        public String getReferencedAttributeName();

        public String getReferencedEntityName();

        public boolean ignoreNotFound();
    }
}

