/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.binding;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.MappingException;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.metamodel.binding.AttributeBinding;
import org.hibernate.metamodel.binding.BagBinding;
import org.hibernate.metamodel.binding.Caching;
import org.hibernate.metamodel.binding.CustomSQL;
import org.hibernate.metamodel.binding.EntityDiscriminator;
import org.hibernate.metamodel.binding.EntityIdentifier;
import org.hibernate.metamodel.binding.EntityReferencingAttributeBinding;
import org.hibernate.metamodel.binding.ManyToOneAttributeBinding;
import org.hibernate.metamodel.binding.MappingDefaults;
import org.hibernate.metamodel.binding.SimpleAttributeBinding;
import org.hibernate.metamodel.domain.Entity;
import org.hibernate.metamodel.domain.MetaAttribute;
import org.hibernate.metamodel.relational.Column;
import org.hibernate.metamodel.relational.TableSpecification;
import org.hibernate.metamodel.source.hbm.HbmHelper;
import org.hibernate.metamodel.source.hbm.xml.mapping.XMLHibernateMapping;
import org.hibernate.metamodel.source.hbm.xml.mapping.XMLSqlDeleteElement;
import org.hibernate.metamodel.source.hbm.xml.mapping.XMLSqlInsertElement;
import org.hibernate.metamodel.source.hbm.xml.mapping.XMLSqlUpdateElement;
import org.hibernate.metamodel.source.hbm.xml.mapping.XMLSynchronizeElement;
import org.hibernate.metamodel.source.util.MappingHelper;

public class EntityBinding {
    private final EntityIdentifier entityIdentifier = new EntityIdentifier(this);
    private EntityDiscriminator entityDiscriminator;
    private SimpleAttributeBinding versionBinding;
    private Entity entity;
    private TableSpecification baseTable;
    private Map<String, AttributeBinding> attributeBindingMap = new HashMap<String, AttributeBinding>();
    private Set<EntityReferencingAttributeBinding> entityReferencingAttributeBindings = new HashSet<EntityReferencingAttributeBinding>();
    private Caching caching;
    private Map<String, MetaAttribute> metaAttributes;
    private boolean lazy;
    private boolean mutable;
    private boolean explicitPolymorphism;
    private String whereFilter;
    private String rowId;
    private String discriminatorValue;
    private boolean dynamicUpdate;
    private boolean dynamicInsert;
    private int batchSize;
    private boolean selectBeforeUpdate;
    private boolean hasSubselectLoadableCollections;
    private int optimisticLockMode;
    private Class entityPersisterClass;
    private Boolean isAbstract;
    private CustomSQL customInsert;
    private CustomSQL customUpdate;
    private CustomSQL customDelete;
    private List<String> synchronizedTableNames;
    private String loaderName;

    public void fromHbmXml(MappingDefaults defaults, XMLHibernateMapping.XMLClass entityClazz, Entity entity) {
        XMLSqlUpdateElement sqlUpdate;
        XMLSqlDeleteElement sqlDelete;
        XMLSqlInsertElement sqlInsert;
        this.entity = entity;
        this.metaAttributes = HbmHelper.extractMetas(entityClazz.getMeta(), true, defaults.getMappingMetas());
        this.lazy = MappingHelper.getBooleanValue(entityClazz.isLazy(), defaults.isDefaultLazy());
        this.discriminatorValue = MappingHelper.getStringValue(entityClazz.getDiscriminatorValue(), entity.getName());
        this.dynamicUpdate = entityClazz.isDynamicUpdate();
        this.dynamicInsert = entityClazz.isDynamicInsert();
        this.batchSize = MappingHelper.getIntValue(entityClazz.getBatchSize(), 0);
        this.selectBeforeUpdate = entityClazz.isSelectBeforeUpdate();
        String optimisticLockModeString = MappingHelper.getStringValue(entityClazz.getOptimisticLock(), "version");
        if ("version".equals(optimisticLockModeString)) {
            this.optimisticLockMode = 0;
        } else if ("dirty".equals(optimisticLockModeString)) {
            this.optimisticLockMode = 1;
        } else if ("all".equals(optimisticLockModeString)) {
            this.optimisticLockMode = 2;
        } else if ("none".equals(optimisticLockModeString)) {
            this.optimisticLockMode = -1;
        } else {
            throw new MappingException("Unsupported optimistic-lock style: " + optimisticLockModeString);
        }
        if (entityClazz.getPersister() != null) {
            try {
                this.entityPersisterClass = ReflectHelper.classForName(entityClazz.getPersister());
            }
            catch (ClassNotFoundException cnfe) {
                throw new MappingException("Could not find persister class: " + entityClazz.getPersister());
            }
        }
        if ((sqlInsert = entityClazz.getSqlInsert()) != null) {
            this.customInsert = HbmHelper.getCustomSql(sqlInsert.getValue(), sqlInsert.isCallable(), sqlInsert.getCheck().value());
        }
        if ((sqlDelete = entityClazz.getSqlDelete()) != null) {
            this.customDelete = HbmHelper.getCustomSql(sqlDelete.getValue(), sqlDelete.isCallable(), sqlDelete.getCheck().value());
        }
        if ((sqlUpdate = entityClazz.getSqlUpdate()) != null) {
            this.customUpdate = HbmHelper.getCustomSql(sqlUpdate.getValue(), sqlUpdate.isCallable(), sqlUpdate.getCheck().value());
        }
        if (entityClazz.getSynchronize() != null) {
            for (XMLSynchronizeElement synchronize : entityClazz.getSynchronize()) {
                this.addSynchronizedTable(synchronize.getTable());
            }
        }
        this.isAbstract = entityClazz.isAbstract();
    }

    public Entity getEntity() {
        return this.entity;
    }

    public void setEntity(Entity entity) {
        this.entity = entity;
    }

    public TableSpecification getBaseTable() {
        return this.baseTable;
    }

    public void setBaseTable(TableSpecification baseTable) {
        this.baseTable = baseTable;
    }

    public EntityIdentifier getEntityIdentifier() {
        return this.entityIdentifier;
    }

    public void bindEntityIdentifier(SimpleAttributeBinding attributeBinding) {
        if (!Column.class.isInstance(attributeBinding.getValue())) {
            throw new MappingException("Identifier value must be a Column; instead it is: " + attributeBinding.getValue().getClass());
        }
        this.entityIdentifier.setValueBinding(attributeBinding);
        this.baseTable.getPrimaryKey().addColumn((Column)Column.class.cast(attributeBinding.getValue()));
    }

    public EntityDiscriminator getEntityDiscriminator() {
        return this.entityDiscriminator;
    }

    public void bindEntityDiscriminator(SimpleAttributeBinding attributeBinding) {
        if (!Column.class.isInstance(attributeBinding.getValue())) {
            throw new MappingException("Identifier value must be a Column; instead it is: " + attributeBinding.getValue().getClass());
        }
        this.entityDiscriminator.setValueBinding(attributeBinding);
        this.baseTable.getPrimaryKey().addColumn((Column)Column.class.cast(attributeBinding.getValue()));
    }

    public SimpleAttributeBinding getVersioningValueBinding() {
        return this.versionBinding;
    }

    public Iterable<AttributeBinding> getAttributeBindings() {
        return this.attributeBindingMap.values();
    }

    public AttributeBinding getAttributeBinding(String name) {
        return this.attributeBindingMap.get(name);
    }

    public Iterable<EntityReferencingAttributeBinding> getEntityReferencingAttributeBindings() {
        return this.entityReferencingAttributeBindings;
    }

    public SimpleAttributeBinding makeSimplePrimaryKeyAttributeBinding(String name) {
        SimpleAttributeBinding binding = this.makeSimpleAttributeBinding(name, true, true);
        this.getEntityIdentifier().setValueBinding(binding);
        return binding;
    }

    public SimpleAttributeBinding makeEntityDiscriminatorBinding(String name) {
        if (this.entityDiscriminator != null) {
            // empty if block
        }
        this.entityDiscriminator = new EntityDiscriminator(this);
        this.entityDiscriminator.setValueBinding(this.makeSimpleAttributeBinding(name, true, false));
        return this.entityDiscriminator.getValueBinding();
    }

    public SimpleAttributeBinding makeVersionBinding(String name) {
        this.versionBinding = this.makeSimpleAttributeBinding(name, true, false);
        return this.versionBinding;
    }

    public SimpleAttributeBinding makeSimpleAttributeBinding(String name) {
        return this.makeSimpleAttributeBinding(name, false, false);
    }

    private SimpleAttributeBinding makeSimpleAttributeBinding(String name, boolean forceNonNullable, boolean forceUnique) {
        SimpleAttributeBinding binding = new SimpleAttributeBinding(this, forceNonNullable, forceUnique);
        this.registerAttributeBinding(name, binding);
        binding.setAttribute(this.entity.getAttribute(name));
        return binding;
    }

    public ManyToOneAttributeBinding makeManyToOneAttributeBinding(String name) {
        ManyToOneAttributeBinding binding = new ManyToOneAttributeBinding(this);
        this.registerAttributeBinding(name, binding);
        binding.setAttribute(this.entity.getAttribute(name));
        return binding;
    }

    public BagBinding makeBagAttributeBinding(String name) {
        BagBinding binding = new BagBinding(this);
        this.registerAttributeBinding(name, binding);
        binding.setAttribute(this.entity.getAttribute(name));
        return binding;
    }

    private void registerAttributeBinding(String name, EntityReferencingAttributeBinding attributeBinding) {
        this.entityReferencingAttributeBindings.add(attributeBinding);
        this.registerAttributeBinding(name, (AttributeBinding)attributeBinding);
    }

    private void registerAttributeBinding(String name, AttributeBinding attributeBinding) {
        this.attributeBindingMap.put(name, attributeBinding);
    }

    public Caching getCaching() {
        return this.caching;
    }

    public void setCaching(Caching caching) {
        this.caching = caching;
    }

    public Map<String, MetaAttribute> getMetaAttributes() {
        return this.metaAttributes;
    }

    public void setMetaAttributes(Map<String, MetaAttribute> metaAttributes) {
        this.metaAttributes = metaAttributes;
    }

    public boolean isMutable() {
        return this.mutable;
    }

    public void setMutable(boolean mutable) {
        this.mutable = mutable;
    }

    public boolean isLazy() {
        return this.lazy;
    }

    public void setLazy(boolean lazy) {
        this.lazy = lazy;
    }

    public String getWhereFilter() {
        return this.whereFilter;
    }

    public void setWhereFilter(String whereFilter) {
        this.whereFilter = whereFilter;
    }

    public boolean isExplicitPolymorphism() {
        return this.explicitPolymorphism;
    }

    public void setExplicitPolymorphism(boolean explicitPolymorphism) {
        this.explicitPolymorphism = explicitPolymorphism;
    }

    public String getRowId() {
        return this.rowId;
    }

    public void setRowId(String rowId) {
        this.rowId = rowId;
    }

    public String getDiscriminatorValue() {
        return this.discriminatorValue;
    }

    public void setDiscriminatorValue(String discriminatorValue) {
        this.discriminatorValue = discriminatorValue;
    }

    public boolean isDynamicUpdate() {
        return this.dynamicUpdate;
    }

    public void setDynamicUpdate(boolean dynamicUpdate) {
        this.dynamicUpdate = dynamicUpdate;
    }

    public boolean isDynamicInsert() {
        return this.dynamicInsert;
    }

    public void setDynamicInsert(boolean dynamicInsert) {
        this.dynamicInsert = dynamicInsert;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public boolean isSelectBeforeUpdate() {
        return this.selectBeforeUpdate;
    }

    public void setSelectBeforeUpdate(Boolean selectBeforeUpdate) {
        this.selectBeforeUpdate = selectBeforeUpdate;
    }

    public boolean hasSubselectLoadableCollections() {
        return this.hasSubselectLoadableCollections;
    }

    void setSubselectLoadableCollections(boolean hasSubselectLoadableCollections) {
        this.hasSubselectLoadableCollections = hasSubselectLoadableCollections;
    }

    public int getOptimisticLockMode() {
        return this.optimisticLockMode;
    }

    public void setOptimisticLockMode(int optimisticLockMode) {
        this.optimisticLockMode = optimisticLockMode;
    }

    public Class getEntityPersisterClass() {
        return this.entityPersisterClass;
    }

    public void setEntityPersisterClass(Class entityPersisterClass) {
        this.entityPersisterClass = entityPersisterClass;
    }

    public Boolean isAbstract() {
        return this.isAbstract;
    }

    protected void addSynchronizedTable(String tablename) {
        if (this.synchronizedTableNames == null) {
            this.synchronizedTableNames = new ArrayList<String>();
        }
        this.synchronizedTableNames.add(tablename);
    }

    public String getLoaderName() {
        return this.loaderName;
    }

    public void setLoaderName(String loaderName) {
        this.loaderName = loaderName;
    }

    public CustomSQL getCustomInsert() {
        return this.customInsert;
    }

    public CustomSQL getCustomUpdate() {
        return this.customUpdate;
    }

    public CustomSQL getCustomDelete() {
        return this.customDelete;
    }
}

