/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.binding;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.hibernate.MappingException;
import org.hibernate.metamodel.binding.AttributeBinding;
import org.hibernate.metamodel.binding.EntityBinding;
import org.hibernate.metamodel.binding.EntityReferencingAttributeBinding;
import org.hibernate.metamodel.binding.HibernateTypeDescriptor;
import org.hibernate.metamodel.domain.Attribute;
import org.hibernate.metamodel.domain.MetaAttribute;
import org.hibernate.metamodel.relational.Column;
import org.hibernate.metamodel.relational.DerivedValue;
import org.hibernate.metamodel.relational.SimpleValue;
import org.hibernate.metamodel.relational.TableSpecification;
import org.hibernate.metamodel.relational.Tuple;
import org.hibernate.metamodel.relational.Value;

public abstract class AbstractAttributeBinding
implements AttributeBinding {
    private final HibernateTypeDescriptor hibernateTypeDescriptor = new HibernateTypeDescriptor();
    private final EntityBinding entityBinding;
    private final Set<EntityReferencingAttributeBinding> entityReferencingAttributeBindings = new HashSet<EntityReferencingAttributeBinding>();
    private Attribute attribute;
    private Value value;
    private boolean isLazy;
    private String propertyAccessorName;
    private boolean isAlternateUniqueKey;
    private String cascade;
    private boolean optimisticLockable;
    private String nodeName;
    private Map<String, MetaAttribute> metaAttributes;

    protected AbstractAttributeBinding(EntityBinding entityBinding) {
        this.entityBinding = entityBinding;
    }

    protected void initialize(DomainState state) {
        this.hibernateTypeDescriptor.initialize(state.getHibernateTypeDescriptor());
        this.attribute = state.getAttribute();
        this.isLazy = state.isLazy();
        this.propertyAccessorName = state.getPropertyAccessorName();
        this.isAlternateUniqueKey = state.isAlternateUniqueKey();
        this.cascade = state.getCascade();
        this.optimisticLockable = state.isOptimisticLockable();
        this.nodeName = state.getNodeName();
        this.metaAttributes = state.getMetaAttributes(this.entityBinding);
    }

    @Override
    public EntityBinding getEntityBinding() {
        return this.entityBinding;
    }

    @Override
    public Attribute getAttribute() {
        return this.attribute;
    }

    protected void setAttribute(Attribute attribute) {
        this.attribute = attribute;
    }

    protected boolean forceNonNullable() {
        return false;
    }

    protected boolean forceUnique() {
        return false;
    }

    protected void initializeColumnValue(AttributeBinding.ColumnRelationalState state) {
        this.value = this.createColumn(state);
    }

    private Column createColumn(AttributeBinding.ColumnRelationalState state) {
        String explicitName = state.getExplicitColumnName();
        String logicalColumnName = state.getNamingStrategy().logicalColumnName(explicitName, this.getAttribute().getName());
        TableSpecification table = this.getEntityBinding().getBaseTable();
        String columnName = explicitName == null ? state.getNamingStrategy().propertyToColumnName(this.getAttribute().getName()) : state.getNamingStrategy().columnName(explicitName);
        Column columnValue = table.createColumn(columnName);
        columnValue.getSize().initialize(state.getSize());
        columnValue.setNullable(!this.forceNonNullable() && state.isNullable());
        columnValue.setUnique(!this.forceUnique() && state.isUnique());
        columnValue.setCheckCondition(state.getCheckCondition());
        columnValue.setDefaultValue(state.getDefault());
        columnValue.setSqlType(state.getSqlType());
        columnValue.setWriteFragment(state.getCustomWriteFragment());
        columnValue.setReadFragment(state.getCustomReadFragment());
        columnValue.setComment(state.getComment());
        for (String uniqueKey : state.getUniqueKeys()) {
            table.getOrCreateUniqueKey(uniqueKey).addColumn(columnValue);
        }
        for (String index : state.getIndexes()) {
            table.getOrCreateIndex(index).addColumn(columnValue);
        }
        return columnValue;
    }

    protected void initialize(AttributeBinding.RelationalState state) {
        if (AttributeBinding.SingleValueRelationalState.class.isInstance(state)) {
            this.initializeSingleValue((AttributeBinding.SingleValueRelationalState)AttributeBinding.SingleValueRelationalState.class.cast(state));
        } else if (AttributeBinding.SimpleTupleRelationalState.class.isInstance(state)) {
            this.initializeSimpleTupleValue((AttributeBinding.SimpleTupleRelationalState)AttributeBinding.SimpleTupleRelationalState.class.cast(state));
        } else {
            throw new MappingException("Unexpected type of RelationalState" + state.getClass().getName());
        }
    }

    protected <T extends AttributeBinding.DerivedRelationalState> void initializeDerivedValue(T state) {
        this.value = this.createDerivedValue(state);
    }

    private DerivedValue createDerivedValue(AttributeBinding.DerivedRelationalState state) {
        return this.getEntityBinding().getBaseTable().createDerivedValue(state.getFormula());
    }

    private void initializeSingleValue(AttributeBinding.SingleValueRelationalState state) {
        this.value = this.createSingleValue(state);
    }

    private SimpleValue createSingleValue(AttributeBinding.SingleValueRelationalState state) {
        if (state instanceof AttributeBinding.ColumnRelationalState) {
            return this.createColumn((AttributeBinding.ColumnRelationalState)AttributeBinding.ColumnRelationalState.class.cast(state));
        }
        if (state instanceof AttributeBinding.DerivedRelationalState) {
            return this.createDerivedValue((AttributeBinding.DerivedRelationalState)AttributeBinding.DerivedRelationalState.class.cast(state));
        }
        throw new MappingException("unknown relational state:" + state.getClass().getName());
    }

    protected void initializeSimpleTupleValue(AttributeBinding.SimpleTupleRelationalState state) {
        if (state.getRelationalStates().size() == 0) {
            throw new MappingException("Tuple state does not contain any values.");
        }
        if (state.getRelationalStates().size() == 1) {
            this.initializeSingleValue((AttributeBinding.SingleValueRelationalState)state.getRelationalStates().iterator().next());
        } else {
            this.value = this.createSimpleTupleValue(state);
        }
    }

    private Tuple createSimpleTupleValue(AttributeBinding.SimpleTupleRelationalState state) {
        Tuple tuple = this.getEntityBinding().getBaseTable().createTuple("[" + this.getAttribute().getName() + "]");
        for (AttributeBinding.SingleValueRelationalState singleValueState : state.getRelationalStates()) {
            tuple.addValue(this.createSingleValue(singleValueState));
        }
        return tuple;
    }

    @Override
    public Value getValue() {
        return this.value;
    }

    @Override
    public HibernateTypeDescriptor getHibernateTypeDescriptor() {
        return this.hibernateTypeDescriptor;
    }

    public String getCascade() {
        return this.cascade;
    }

    public boolean isOptimisticLockable() {
        return this.optimisticLockable;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    @Override
    public Map<String, MetaAttribute> getMetaAttributes() {
        return this.metaAttributes;
    }

    @Override
    public Iterable<SimpleValue> getValues() {
        return this.value == null ? Collections.emptyList() : (this.value instanceof Tuple ? ((Tuple)this.value).values() : Collections.singletonList((SimpleValue)this.value));
    }

    @Override
    public TableSpecification getTable() {
        return this.getValue().getTable();
    }

    @Override
    public String getPropertyAccessorName() {
        return this.propertyAccessorName;
    }

    @Override
    public boolean hasFormula() {
        for (SimpleValue simpleValue : this.getValues()) {
            if (!(simpleValue instanceof DerivedValue)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isAlternateUniqueKey() {
        return this.isAlternateUniqueKey;
    }

    public void setAlternateUniqueKey(boolean alternateUniqueKey) {
        this.isAlternateUniqueKey = alternateUniqueKey;
    }

    @Override
    public boolean isNullable() {
        for (SimpleValue simpleValue : this.getValues()) {
            if (simpleValue instanceof DerivedValue) {
                return true;
            }
            Column column = (Column)simpleValue;
            if (!column.isNullable()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean[] getColumnInsertability() {
        ArrayList<Boolean> tmp = new ArrayList<Boolean>();
        for (SimpleValue simpleValue : this.getValues()) {
            tmp.add(!(simpleValue instanceof DerivedValue));
        }
        boolean[] rtn = new boolean[tmp.size()];
        int i = 0;
        for (Boolean insertable : tmp) {
            rtn[i++] = insertable;
        }
        return rtn;
    }

    @Override
    public boolean[] getColumnUpdateability() {
        return this.getColumnInsertability();
    }

    @Override
    public boolean isLazy() {
        return this.isLazy;
    }

    protected void setLazy(boolean isLazy) {
        this.isLazy = isLazy;
    }

    @Override
    public void addEntityReferencingAttributeBinding(EntityReferencingAttributeBinding referencingAttributeBinding) {
        this.entityReferencingAttributeBindings.add(referencingAttributeBinding);
    }

    @Override
    public Set<EntityReferencingAttributeBinding> getEntityReferencingAttributeBindings() {
        return Collections.unmodifiableSet(this.entityReferencingAttributeBindings);
    }

    @Override
    public void validate() {
        if (!this.entityReferencingAttributeBindings.isEmpty()) {
            // empty if block
        }
    }

    public static interface DomainState {
        public HibernateTypeDescriptor getHibernateTypeDescriptor();

        public Attribute getAttribute();

        public boolean isLazy();

        public String getPropertyAccessorName();

        public boolean isAlternateUniqueKey();

        public String getCascade();

        public boolean isOptimisticLockable();

        public String getNodeName();

        public Map<String, MetaAttribute> getMetaAttributes(EntityBinding var1);
    }
}

