/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal;

import java.io.Serializable;
import java.sql.Connection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.CacheMode;
import org.hibernate.ConnectionReleaseMode;
import org.hibernate.Criteria;
import org.hibernate.EmptyInterceptor;
import org.hibernate.EntityMode;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.Interceptor;
import org.hibernate.LockMode;
import org.hibernate.MappingException;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.SessionException;
import org.hibernate.StatelessSession;
import org.hibernate.Transaction;
import org.hibernate.UnresolvableObjectException;
import org.hibernate.cache.spi.CacheKey;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.internal.StatefulPersistenceContext;
import org.hibernate.engine.internal.Versioning;
import org.hibernate.engine.query.spi.HQLQueryPlan;
import org.hibernate.engine.query.spi.NativeSQLQueryPlan;
import org.hibernate.engine.query.spi.sql.NativeSQLQuerySpecification;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.NonFlushedChanges;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.QueryParameters;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.transaction.internal.TransactionCoordinatorImpl;
import org.hibernate.engine.transaction.spi.TransactionCoordinator;
import org.hibernate.engine.transaction.spi.TransactionEnvironment;
import org.hibernate.engine.transaction.spi.TransactionImplementor;
import org.hibernate.id.IdentifierGeneratorHelper;
import org.hibernate.internal.AbstractSessionImpl;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.CriteriaImpl;
import org.hibernate.internal.SessionFactoryImpl;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.loader.criteria.CriteriaLoader;
import org.hibernate.loader.custom.CustomLoader;
import org.hibernate.loader.custom.CustomQuery;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.OuterJoinLoadable;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.type.Type;
import org.jboss.logging.Logger;

public class StatelessSessionImpl
extends AbstractSessionImpl
implements StatelessSession {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)StatelessSessionImpl.class.getName());
    private TransactionCoordinator transactionCoordinator;
    private PersistenceContext temporaryPersistenceContext = new StatefulPersistenceContext(this);

    StatelessSessionImpl(Connection connection, String tenantIdentifier, SessionFactoryImpl factory) {
        super(factory, tenantIdentifier);
        this.transactionCoordinator = new TransactionCoordinatorImpl(connection, this);
    }

    @Override
    public TransactionCoordinator getTransactionCoordinator() {
        return this.transactionCoordinator;
    }

    @Override
    public TransactionEnvironment getTransactionEnvironment() {
        return this.factory.getTransactionEnvironment();
    }

    @Override
    public Serializable insert(Object entity) {
        this.errorIfClosed();
        return this.insert(null, entity);
    }

    @Override
    public Serializable insert(String entityName, Object entity) {
        boolean substitute;
        this.errorIfClosed();
        EntityPersister persister = this.getEntityPersister(entityName, entity);
        Serializable id = persister.getIdentifierGenerator().generate(this, entity);
        Object[] state = persister.getPropertyValues(entity, EntityMode.POJO);
        if (persister.isVersioned() && (substitute = Versioning.seedVersion(state, persister.getVersionProperty(), persister.getVersionType(), this))) {
            persister.setPropertyValues(entity, state, EntityMode.POJO);
        }
        if (id == IdentifierGeneratorHelper.POST_INSERT_INDICATOR) {
            id = persister.insert(state, entity, this);
        } else {
            persister.insert(id, state, entity, this);
        }
        persister.setIdentifier(entity, id, this);
        return id;
    }

    @Override
    public void delete(Object entity) {
        this.errorIfClosed();
        this.delete(null, entity);
    }

    @Override
    public void delete(String entityName, Object entity) {
        this.errorIfClosed();
        EntityPersister persister = this.getEntityPersister(entityName, entity);
        Serializable id = persister.getIdentifier(entity, this);
        Object version = persister.getVersion(entity, EntityMode.POJO);
        persister.delete(id, version, entity, this);
    }

    @Override
    public void update(Object entity) {
        this.errorIfClosed();
        this.update(null, entity);
    }

    @Override
    public void update(String entityName, Object entity) {
        Object oldVersion;
        this.errorIfClosed();
        EntityPersister persister = this.getEntityPersister(entityName, entity);
        Serializable id = persister.getIdentifier(entity, this);
        Object[] state = persister.getPropertyValues(entity, EntityMode.POJO);
        if (persister.isVersioned()) {
            oldVersion = persister.getVersion(entity, EntityMode.POJO);
            Object newVersion = Versioning.increment(oldVersion, persister.getVersionType(), this);
            Versioning.setVersion(state, newVersion, persister);
            persister.setPropertyValues(entity, state, EntityMode.POJO);
        } else {
            oldVersion = null;
        }
        persister.update(id, state, null, false, null, oldVersion, entity, null, this);
    }

    @Override
    public Object get(Class entityClass, Serializable id) {
        return this.get(entityClass.getName(), id);
    }

    @Override
    public Object get(Class entityClass, Serializable id, LockMode lockMode) {
        return this.get(entityClass.getName(), id, lockMode);
    }

    @Override
    public Object get(String entityName, Serializable id) {
        return this.get(entityName, id, LockMode.NONE);
    }

    @Override
    public Object get(String entityName, Serializable id, LockMode lockMode) {
        this.errorIfClosed();
        Object result = this.getFactory().getEntityPersister(entityName).load(id, null, lockMode, (SessionImplementor)this);
        if (this.temporaryPersistenceContext.isLoadFinished()) {
            this.temporaryPersistenceContext.clear();
        }
        return result;
    }

    @Override
    public void refresh(Object entity) {
        this.refresh(this.bestGuessEntityName(entity), entity, LockMode.NONE);
    }

    @Override
    public void refresh(String entityName, Object entity) {
        this.refresh(entityName, entity, LockMode.NONE);
    }

    @Override
    public void refresh(Object entity, LockMode lockMode) {
        this.refresh(this.bestGuessEntityName(entity), entity, lockMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refresh(String entityName, Object entity, LockMode lockMode) {
        EntityPersister persister = this.getEntityPersister(entityName, entity);
        Serializable id = persister.getIdentifier(entity, this);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Refreshing transient " + MessageHelper.infoString(persister, id, this.getFactory()));
        }
        if (persister.hasCache()) {
            CacheKey ck = this.generateCacheKey(id, persister.getIdentifierType(), persister.getRootEntityName());
            persister.getCacheAccessStrategy().evict(ck);
        }
        String previousFetchProfile = this.getFetchProfile();
        Object result = null;
        try {
            this.setFetchProfile("refresh");
            result = persister.load(id, entity, lockMode, (SessionImplementor)this);
        }
        finally {
            this.setFetchProfile(previousFetchProfile);
        }
        UnresolvableObjectException.throwIfNull(result, id, persister.getEntityName());
    }

    @Override
    public Object immediateLoad(String entityName, Serializable id) throws HibernateException {
        throw new SessionException("proxies cannot be fetched by a stateless session");
    }

    @Override
    public void initializeCollection(PersistentCollection collection, boolean writing) throws HibernateException {
        throw new SessionException("collections cannot be fetched by a stateless session");
    }

    @Override
    public Object instantiate(String entityName, Serializable id) throws HibernateException {
        this.errorIfClosed();
        return this.getFactory().getEntityPersister(entityName).instantiate(id, this);
    }

    @Override
    public Object internalLoad(String entityName, Serializable id, boolean eager, boolean nullable) throws HibernateException {
        this.errorIfClosed();
        EntityPersister persister = this.getFactory().getEntityPersister(entityName);
        Object loaded = this.temporaryPersistenceContext.getEntity(this.generateEntityKey(id, persister));
        if (loaded != null) {
            return loaded;
        }
        if (!eager && persister.hasProxy()) {
            return persister.createProxy(id, this);
        }
        return this.get(entityName, id);
    }

    @Override
    public Iterator iterate(String query, QueryParameters queryParameters) throws HibernateException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator iterateFilter(Object collection, String filter, QueryParameters queryParameters) throws HibernateException {
        throw new UnsupportedOperationException();
    }

    @Override
    public List listFilter(Object collection, String filter, QueryParameters queryParameters) throws HibernateException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isOpen() {
        return !this.isClosed();
    }

    @Override
    public void close() {
        this.managedClose();
    }

    @Override
    public ConnectionReleaseMode getConnectionReleaseMode() {
        return this.factory.getSettings().getConnectionReleaseMode();
    }

    @Override
    public boolean shouldAutoJoinTransaction() {
        return true;
    }

    @Override
    public boolean isAutoCloseSessionEnabled() {
        return this.factory.getSettings().isAutoCloseSessionEnabled();
    }

    @Override
    public boolean isFlushBeforeCompletionEnabled() {
        return true;
    }

    @Override
    public boolean isFlushModeNever() {
        return false;
    }

    @Override
    public void managedClose() {
        if (this.isClosed()) {
            throw new SessionException("Session was already closed!");
        }
        this.transactionCoordinator.close();
        this.setClosed();
    }

    @Override
    public void managedFlush() {
        this.errorIfClosed();
        this.getTransactionCoordinator().getJdbcCoordinator().executeBatch();
    }

    @Override
    public boolean shouldAutoClose() {
        return this.isAutoCloseSessionEnabled() && !this.isClosed();
    }

    @Override
    public void afterTransactionBegin(TransactionImplementor hibernateTransaction) {
    }

    @Override
    public void beforeTransactionCompletion(TransactionImplementor hibernateTransaction) {
    }

    @Override
    public void afterTransactionCompletion(TransactionImplementor hibernateTransaction, boolean successful) {
    }

    @Override
    public String bestGuessEntityName(Object object) {
        if (object instanceof HibernateProxy) {
            object = ((HibernateProxy)object).getHibernateLazyInitializer().getImplementation();
        }
        return this.guessEntityName(object);
    }

    @Override
    public Connection connection() {
        this.errorIfClosed();
        return this.transactionCoordinator.getJdbcCoordinator().getLogicalConnection().getDistinctConnectionProxy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate(String query, QueryParameters queryParameters) throws HibernateException {
        this.errorIfClosed();
        queryParameters.validateParameters();
        HQLQueryPlan plan = this.getHQLQueryPlan(query, false);
        boolean success = false;
        int result = 0;
        try {
            result = plan.performExecuteUpdate(queryParameters, this);
            success = true;
        }
        finally {
            this.afterOperation(success);
        }
        this.temporaryPersistenceContext.clear();
        return result;
    }

    @Override
    public CacheMode getCacheMode() {
        return CacheMode.IGNORE;
    }

    @Override
    public int getDontFlushFromFind() {
        return 0;
    }

    @Override
    public Map getEnabledFilters() {
        return CollectionHelper.EMPTY_MAP;
    }

    @Override
    public Serializable getContextEntityIdentifier(Object object) {
        this.errorIfClosed();
        return null;
    }

    @Override
    public EntityMode getEntityMode() {
        return EntityMode.POJO;
    }

    @Override
    public EntityPersister getEntityPersister(String entityName, Object object) throws HibernateException {
        this.errorIfClosed();
        if (entityName == null) {
            return this.factory.getEntityPersister(this.guessEntityName(object));
        }
        return this.factory.getEntityPersister(entityName).getSubclassEntityPersister(object, this.getFactory(), EntityMode.POJO);
    }

    @Override
    public Object getEntityUsingInterceptor(EntityKey key) throws HibernateException {
        this.errorIfClosed();
        return null;
    }

    @Override
    public Type getFilterParameterType(String filterParameterName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getFilterParameterValue(String filterParameterName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public FlushMode getFlushMode() {
        return FlushMode.COMMIT;
    }

    @Override
    public Interceptor getInterceptor() {
        return EmptyInterceptor.INSTANCE;
    }

    @Override
    public PersistenceContext getPersistenceContext() {
        return this.temporaryPersistenceContext;
    }

    @Override
    public long getTimestamp() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String guessEntityName(Object entity) throws HibernateException {
        this.errorIfClosed();
        return entity.getClass().getName();
    }

    @Override
    public boolean isConnected() {
        return this.transactionCoordinator.getJdbcCoordinator().getLogicalConnection().isPhysicallyConnected();
    }

    @Override
    public boolean isTransactionInProgress() {
        return this.transactionCoordinator.isTransactionInProgress();
    }

    @Override
    public void setAutoClear(boolean enabled) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void disableTransactionAutoJoin() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setCacheMode(CacheMode cm) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setFlushMode(FlushMode fm) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Transaction getTransaction() throws HibernateException {
        this.errorIfClosed();
        return this.transactionCoordinator.getTransaction();
    }

    @Override
    public Transaction beginTransaction() throws HibernateException {
        this.errorIfClosed();
        Transaction result = this.getTransaction();
        result.begin();
        return result;
    }

    @Override
    public boolean isEventSource() {
        return false;
    }

    public boolean isDefaultReadOnly() {
        return false;
    }

    public void setDefaultReadOnly(boolean readOnly) throws HibernateException {
        if (readOnly) {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List list(String query, QueryParameters queryParameters) throws HibernateException {
        this.errorIfClosed();
        queryParameters.validateParameters();
        HQLQueryPlan plan = this.getHQLQueryPlan(query, false);
        boolean success = false;
        List results = CollectionHelper.EMPTY_LIST;
        try {
            results = plan.performList(queryParameters, this);
            success = true;
        }
        finally {
            this.afterOperation(success);
        }
        this.temporaryPersistenceContext.clear();
        return results;
    }

    public void afterOperation(boolean success) {
        if (!this.transactionCoordinator.isTransactionInProgress()) {
            this.transactionCoordinator.afterNonTransactionalQuery(success);
        }
    }

    @Override
    public Criteria createCriteria(Class persistentClass, String alias) {
        this.errorIfClosed();
        return new CriteriaImpl(persistentClass.getName(), alias, this);
    }

    @Override
    public Criteria createCriteria(String entityName, String alias) {
        this.errorIfClosed();
        return new CriteriaImpl(entityName, alias, this);
    }

    @Override
    public Criteria createCriteria(Class persistentClass) {
        this.errorIfClosed();
        return new CriteriaImpl(persistentClass.getName(), this);
    }

    @Override
    public Criteria createCriteria(String entityName) {
        this.errorIfClosed();
        return new CriteriaImpl(entityName, this);
    }

    @Override
    public ScrollableResults scroll(CriteriaImpl criteria, ScrollMode scrollMode) {
        this.errorIfClosed();
        String entityName = criteria.getEntityOrClassName();
        CriteriaLoader loader = new CriteriaLoader(this.getOuterJoinLoadable(entityName), this.factory, criteria, entityName, this.getLoadQueryInfluencers());
        return loader.scroll(this, scrollMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List list(CriteriaImpl criteria) throws HibernateException {
        this.errorIfClosed();
        String[] implementors = this.factory.getImplementors(criteria.getEntityOrClassName());
        int size = implementors.length;
        CriteriaLoader[] loaders = new CriteriaLoader[size];
        for (int i = 0; i < size; ++i) {
            loaders[i] = new CriteriaLoader(this.getOuterJoinLoadable(implementors[i]), this.factory, criteria, implementors[i], this.getLoadQueryInfluencers());
        }
        List results = Collections.EMPTY_LIST;
        boolean success = false;
        try {
            for (int i = 0; i < size; ++i) {
                List currentResults = loaders[i].list(this);
                currentResults.addAll(results);
                results = currentResults;
            }
            success = true;
        }
        finally {
            this.afterOperation(success);
        }
        this.temporaryPersistenceContext.clear();
        return results;
    }

    private OuterJoinLoadable getOuterJoinLoadable(String entityName) throws MappingException {
        EntityPersister persister = this.factory.getEntityPersister(entityName);
        if (!(persister instanceof OuterJoinLoadable)) {
            throw new MappingException("class persister is not OuterJoinLoadable: " + entityName);
        }
        return (OuterJoinLoadable)persister;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List listCustomQuery(CustomQuery customQuery, QueryParameters queryParameters) throws HibernateException {
        List results;
        this.errorIfClosed();
        CustomLoader loader = new CustomLoader(customQuery, this.getFactory());
        boolean success = false;
        try {
            results = loader.list(this, queryParameters);
            success = true;
        }
        finally {
            this.afterOperation(success);
        }
        this.temporaryPersistenceContext.clear();
        return results;
    }

    @Override
    public ScrollableResults scrollCustomQuery(CustomQuery customQuery, QueryParameters queryParameters) throws HibernateException {
        this.errorIfClosed();
        CustomLoader loader = new CustomLoader(customQuery, this.getFactory());
        return loader.scroll(queryParameters, this);
    }

    @Override
    public ScrollableResults scroll(String query, QueryParameters queryParameters) throws HibernateException {
        this.errorIfClosed();
        HQLQueryPlan plan = this.getHQLQueryPlan(query, false);
        return plan.performScroll(queryParameters, this);
    }

    @Override
    public void afterScrollOperation() {
        this.temporaryPersistenceContext.clear();
    }

    @Override
    public void flush() {
    }

    @Override
    public NonFlushedChanges getNonFlushedChanges() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void applyNonFlushedChanges(NonFlushedChanges nonFlushedChanges) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getFetchProfile() {
        return null;
    }

    @Override
    public LoadQueryInfluencers getLoadQueryInfluencers() {
        return LoadQueryInfluencers.NONE;
    }

    public void registerInsertedKey(EntityPersister persister, Serializable id) {
        this.errorIfClosed();
    }

    public boolean wasInsertedDuringTransaction(EntityPersister persister, Serializable id) {
        this.errorIfClosed();
        return false;
    }

    @Override
    public void setFetchProfile(String name) {
    }

    protected boolean autoFlushIfRequired(Set querySpaces) throws HibernateException {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeNativeUpdate(NativeSQLQuerySpecification nativeSQLQuerySpecification, QueryParameters queryParameters) throws HibernateException {
        this.errorIfClosed();
        queryParameters.validateParameters();
        NativeSQLQueryPlan plan = this.getNativeSQLQueryPlan(nativeSQLQuerySpecification);
        boolean success = false;
        int result = 0;
        try {
            result = plan.performExecuteUpdate(queryParameters, this);
            success = true;
        }
        finally {
            this.afterOperation(success);
        }
        this.temporaryPersistenceContext.clear();
        return result;
    }
}

