/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.NClob;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.CacheMode;
import org.hibernate.ConnectionReleaseMode;
import org.hibernate.Criteria;
import org.hibernate.EmptyInterceptor;
import org.hibernate.EntityMode;
import org.hibernate.EntityNameResolver;
import org.hibernate.Filter;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.Interceptor;
import org.hibernate.LobHelper;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.MappingException;
import org.hibernate.ObjectDeletedException;
import org.hibernate.Query;
import org.hibernate.QueryException;
import org.hibernate.ReplicationMode;
import org.hibernate.SQLQuery;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.Session;
import org.hibernate.SessionBuilder;
import org.hibernate.SessionException;
import org.hibernate.SharedSessionBuilder;
import org.hibernate.Transaction;
import org.hibernate.TransientObjectException;
import org.hibernate.TypeHelper;
import org.hibernate.UnknownProfileException;
import org.hibernate.UnresolvableObjectException;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.internal.StatefulPersistenceContext;
import org.hibernate.engine.jdbc.LobCreationContext;
import org.hibernate.engine.jdbc.LobCreator;
import org.hibernate.engine.query.spi.FilterQueryPlan;
import org.hibernate.engine.query.spi.HQLQueryPlan;
import org.hibernate.engine.query.spi.NativeSQLQueryPlan;
import org.hibernate.engine.query.spi.sql.NativeSQLQuerySpecification;
import org.hibernate.engine.spi.ActionQueue;
import org.hibernate.engine.spi.CollectionEntry;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.NonFlushedChanges;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.QueryParameters;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.Status;
import org.hibernate.engine.transaction.internal.TransactionCoordinatorImpl;
import org.hibernate.engine.transaction.spi.TransactionContext;
import org.hibernate.engine.transaction.spi.TransactionCoordinator;
import org.hibernate.engine.transaction.spi.TransactionImplementor;
import org.hibernate.event.service.spi.EventListenerGroup;
import org.hibernate.event.service.spi.EventListenerRegistry;
import org.hibernate.event.spi.AutoFlushEvent;
import org.hibernate.event.spi.AutoFlushEventListener;
import org.hibernate.event.spi.DeleteEvent;
import org.hibernate.event.spi.DeleteEventListener;
import org.hibernate.event.spi.DirtyCheckEvent;
import org.hibernate.event.spi.DirtyCheckEventListener;
import org.hibernate.event.spi.EventSource;
import org.hibernate.event.spi.EventType;
import org.hibernate.event.spi.EvictEvent;
import org.hibernate.event.spi.EvictEventListener;
import org.hibernate.event.spi.FlushEvent;
import org.hibernate.event.spi.FlushEventListener;
import org.hibernate.event.spi.InitializeCollectionEvent;
import org.hibernate.event.spi.InitializeCollectionEventListener;
import org.hibernate.event.spi.LoadEvent;
import org.hibernate.event.spi.LoadEventListener;
import org.hibernate.event.spi.LockEvent;
import org.hibernate.event.spi.LockEventListener;
import org.hibernate.event.spi.MergeEvent;
import org.hibernate.event.spi.MergeEventListener;
import org.hibernate.event.spi.PersistEvent;
import org.hibernate.event.spi.PersistEventListener;
import org.hibernate.event.spi.RefreshEvent;
import org.hibernate.event.spi.RefreshEventListener;
import org.hibernate.event.spi.ReplicateEvent;
import org.hibernate.event.spi.ReplicateEventListener;
import org.hibernate.event.spi.SaveOrUpdateEvent;
import org.hibernate.event.spi.SaveOrUpdateEventListener;
import org.hibernate.internal.AbstractSessionImpl;
import org.hibernate.internal.CollectionFilterImpl;
import org.hibernate.internal.ConnectionObserverStatsBridge;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.CriteriaImpl;
import org.hibernate.internal.FilterImpl;
import org.hibernate.internal.NonFlushedChangesImpl;
import org.hibernate.internal.SessionFactoryImpl;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.jdbc.ReturningWork;
import org.hibernate.jdbc.Work;
import org.hibernate.jdbc.WorkExecutor;
import org.hibernate.jdbc.WorkExecutorVisitable;
import org.hibernate.loader.criteria.CriteriaLoader;
import org.hibernate.loader.custom.CustomLoader;
import org.hibernate.loader.custom.CustomQuery;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.OuterJoinLoadable;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;
import org.hibernate.stat.SessionStatistics;
import org.hibernate.stat.internal.SessionStatisticsImpl;
import org.hibernate.type.SerializationException;
import org.hibernate.type.Type;
import org.jboss.logging.Logger;

public final class SessionImpl
extends AbstractSessionImpl
implements EventSource,
Session,
TransactionContext,
LobCreationContext {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)SessionImpl.class.getName());
    private transient long timestamp;
    private transient ActionQueue actionQueue;
    private transient StatefulPersistenceContext persistenceContext;
    private transient TransactionCoordinatorImpl transactionCoordinator;
    private transient Interceptor interceptor;
    private transient EntityNameResolver entityNameResolver = new CoordinatingEntityNameResolver();
    private transient ConnectionReleaseMode connectionReleaseMode;
    private transient FlushMode flushMode = FlushMode.AUTO;
    private transient CacheMode cacheMode = CacheMode.NORMAL;
    private transient EntityMode entityMode = EntityMode.POJO;
    private transient boolean autoClear;
    private transient boolean autoJoinTransactions = true;
    private transient boolean flushBeforeCompletionEnabled;
    private transient boolean autoCloseSessionEnabled;
    private transient int dontFlushFromFind = 0;
    private transient LoadQueryInfluencers loadQueryInfluencers;
    private transient Session rootSession;
    private transient Map childSessionsByEntityMode;
    private transient LobHelperImpl lobHelper;

    private SessionImpl(SessionImpl parent, EntityMode entityMode) {
        super(parent.factory, parent.getTenantIdentifier());
        this.rootSession = parent;
        this.timestamp = parent.timestamp;
        this.transactionCoordinator = parent.transactionCoordinator;
        this.interceptor = parent.interceptor;
        this.actionQueue = new ActionQueue(this);
        this.entityMode = entityMode;
        this.persistenceContext = new StatefulPersistenceContext(this);
        this.flushBeforeCompletionEnabled = false;
        this.autoCloseSessionEnabled = false;
        this.connectionReleaseMode = null;
        this.loadQueryInfluencers = new LoadQueryInfluencers(this.factory);
        if (this.factory.getStatistics().isStatisticsEnabled()) {
            this.factory.getStatisticsImplementor().openSession();
        }
        LOG.debugf("Opened session [%s]", entityMode);
    }

    SessionImpl(Connection connection, SessionFactoryImpl factory, TransactionCoordinatorImpl transactionCoordinator, boolean autoJoinTransactions, long timestamp, Interceptor interceptor, EntityMode entityMode, boolean flushBeforeCompletionEnabled, boolean autoCloseSessionEnabled, ConnectionReleaseMode connectionReleaseMode, String tenantIdentifier) {
        super(factory, tenantIdentifier);
        this.rootSession = null;
        this.timestamp = timestamp;
        this.entityMode = entityMode;
        this.interceptor = interceptor == null ? EmptyInterceptor.INSTANCE : interceptor;
        this.actionQueue = new ActionQueue(this);
        this.persistenceContext = new StatefulPersistenceContext(this);
        this.flushBeforeCompletionEnabled = flushBeforeCompletionEnabled;
        this.autoCloseSessionEnabled = autoCloseSessionEnabled;
        this.connectionReleaseMode = connectionReleaseMode;
        this.autoJoinTransactions = autoJoinTransactions;
        if (transactionCoordinator == null) {
            this.transactionCoordinator = new TransactionCoordinatorImpl(connection, this);
            this.transactionCoordinator.getJdbcCoordinator().getLogicalConnection().addObserver(new ConnectionObserverStatsBridge(factory));
        } else {
            if (connection != null) {
                throw new SessionException("Cannot simultaneously share transaction context and specify connection");
            }
            this.transactionCoordinator = transactionCoordinator;
        }
        this.loadQueryInfluencers = new LoadQueryInfluencers(factory);
        if (factory.getStatistics().isStatisticsEnabled()) {
            factory.getStatisticsImplementor().openSession();
        }
        LOG.debugf("Opened session at timestamp: %s", timestamp);
    }

    @Override
    public SharedSessionBuilder sessionWithOptions() {
        return new SharedSessionBuilderImpl(this);
    }

    @Override
    public Session getSession(EntityMode entityMode) {
        if (this.entityMode == entityMode) {
            return this;
        }
        if (this.rootSession != null) {
            return this.rootSession.getSession(entityMode);
        }
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        SessionImpl rtn = null;
        if (this.childSessionsByEntityMode == null) {
            this.childSessionsByEntityMode = new HashMap();
        } else {
            rtn = (SessionImpl)this.childSessionsByEntityMode.get(entityMode);
        }
        if (rtn == null) {
            rtn = new SessionImpl(this, entityMode);
            this.childSessionsByEntityMode.put(entityMode, rtn);
        }
        return rtn;
    }

    @Override
    public void clear() {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        this.persistenceContext.clear();
        this.actionQueue.clear();
    }

    @Override
    public long getTimestamp() {
        this.checkTransactionSynchStatus();
        return this.timestamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection close() throws HibernateException {
        LOG.trace("Closing session");
        if (this.isClosed()) {
            throw new SessionException("Session was already closed");
        }
        if (this.factory.getStatistics().isStatisticsEnabled()) {
            this.factory.getStatisticsImplementor().closeSession();
        }
        try {
            Connection connection;
            try {
                if (this.childSessionsByEntityMode != null) {
                    for (SessionImpl child : this.childSessionsByEntityMode.values()) {
                        child.close();
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (this.rootSession == null) {
                connection = this.transactionCoordinator.close();
                return connection;
            }
            connection = null;
            return connection;
        }
        finally {
            this.setClosed();
            this.cleanup();
        }
    }

    @Override
    public ConnectionReleaseMode getConnectionReleaseMode() {
        return this.connectionReleaseMode;
    }

    @Override
    public boolean shouldAutoJoinTransaction() {
        return this.autoJoinTransactions;
    }

    @Override
    public boolean isAutoCloseSessionEnabled() {
        return this.autoCloseSessionEnabled;
    }

    @Override
    public boolean isOpen() {
        this.checkTransactionSynchStatus();
        return !this.isClosed();
    }

    @Override
    public boolean isFlushModeNever() {
        return FlushMode.isManualFlushMode(this.getFlushMode());
    }

    @Override
    public boolean isFlushBeforeCompletionEnabled() {
        return this.flushBeforeCompletionEnabled;
    }

    @Override
    public void managedFlush() {
        if (this.isClosed()) {
            LOG.trace("Skipping auto-flush due to session closed");
            return;
        }
        LOG.trace("Automatically flushing session");
        this.flush();
        if (this.childSessionsByEntityMode != null) {
            Iterator iter = this.childSessionsByEntityMode.values().iterator();
            while (iter.hasNext()) {
                ((Session)iter.next()).flush();
            }
        }
    }

    @Override
    public NonFlushedChanges getNonFlushedChanges() throws HibernateException {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        NonFlushedChangesImpl nonFlushedChanges = new NonFlushedChangesImpl(this);
        if (this.childSessionsByEntityMode != null) {
            Iterator it = this.childSessionsByEntityMode.values().iterator();
            while (it.hasNext()) {
                nonFlushedChanges.extractFromSession((EventSource)it.next());
            }
        }
        return nonFlushedChanges;
    }

    @Override
    public void applyNonFlushedChanges(NonFlushedChanges nonFlushedChanges) throws HibernateException {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        this.replacePersistenceContext(((NonFlushedChangesImpl)nonFlushedChanges).getPersistenceContext(this.entityMode));
        this.replaceActionQueue(((NonFlushedChangesImpl)nonFlushedChanges).getActionQueue(this.entityMode));
        if (this.childSessionsByEntityMode != null) {
            Iterator it = this.childSessionsByEntityMode.values().iterator();
            while (it.hasNext()) {
                ((SessionImpl)it.next()).applyNonFlushedChanges(nonFlushedChanges);
            }
        }
    }

    private void replacePersistenceContext(StatefulPersistenceContext persistenceContextNew) {
        if (persistenceContextNew.getSession() != null) {
            throw new IllegalStateException("new persistence context is already connected to a session ");
        }
        this.persistenceContext.clear();
        ObjectInputStream ois = null;
        try {
            ois = new ObjectInputStream(new ByteArrayInputStream(SessionImpl.serializePersistenceContext(persistenceContextNew)));
            this.persistenceContext = StatefulPersistenceContext.deserialize(ois, this);
        }
        catch (IOException ex) {
            throw new SerializationException("could not deserialize the persistence context", ex);
        }
        catch (ClassNotFoundException ex) {
            throw new SerializationException("could not deserialize the persistence context", ex);
        }
        finally {
            try {
                if (ois != null) {
                    ois.close();
                }
            }
            catch (IOException ex) {}
        }
    }

    private static byte[] serializePersistenceContext(StatefulPersistenceContext pc) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(512);
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream(baos);
            pc.serialize(oos);
        }
        catch (IOException ex) {
            throw new SerializationException("could not serialize persistence context", ex);
        }
        finally {
            if (oos != null) {
                try {
                    oos.close();
                }
                catch (IOException ex) {}
            }
        }
        return baos.toByteArray();
    }

    private void replaceActionQueue(ActionQueue actionQueueNew) {
        if (this.actionQueue.hasAnyQueuedActions()) {
            throw new IllegalStateException("cannot replace an ActionQueue with queued actions ");
        }
        this.actionQueue.clear();
        ObjectInputStream ois = null;
        try {
            ois = new ObjectInputStream(new ByteArrayInputStream(SessionImpl.serializeActionQueue(actionQueueNew)));
            this.actionQueue = ActionQueue.deserialize(ois, this);
        }
        catch (IOException ex) {
            throw new SerializationException("could not deserialize the action queue", ex);
        }
        catch (ClassNotFoundException ex) {
            throw new SerializationException("could not deserialize the action queue", ex);
        }
        finally {
            try {
                if (ois != null) {
                    ois.close();
                }
            }
            catch (IOException ex) {}
        }
    }

    private static byte[] serializeActionQueue(ActionQueue actionQueue) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(512);
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream(baos);
            actionQueue.serialize(oos);
        }
        catch (IOException ex) {
            throw new SerializationException("could not serialize action queue", ex);
        }
        finally {
            if (oos != null) {
                try {
                    oos.close();
                }
                catch (IOException ex) {}
            }
        }
        return baos.toByteArray();
    }

    @Override
    public boolean shouldAutoClose() {
        return this.isAutoCloseSessionEnabled() && !this.isClosed();
    }

    @Override
    public void managedClose() {
        LOG.trace("Automatically closing session");
        this.close();
    }

    @Override
    public Connection connection() throws HibernateException {
        this.errorIfClosed();
        return this.transactionCoordinator.getJdbcCoordinator().getLogicalConnection().getDistinctConnectionProxy();
    }

    @Override
    public boolean isConnected() {
        this.checkTransactionSynchStatus();
        return !this.isClosed() && this.transactionCoordinator.getJdbcCoordinator().getLogicalConnection().isOpen();
    }

    @Override
    public boolean isTransactionInProgress() {
        this.checkTransactionSynchStatus();
        return !this.isClosed() && this.transactionCoordinator.isTransactionInProgress();
    }

    @Override
    public Connection disconnect() throws HibernateException {
        this.errorIfClosed();
        LOG.debugf("Disconnecting session", new Object[0]);
        return this.transactionCoordinator.getJdbcCoordinator().getLogicalConnection().manualDisconnect();
    }

    @Override
    public void reconnect(Connection conn) throws HibernateException {
        this.errorIfClosed();
        LOG.debugf("Reconnecting session", new Object[0]);
        this.checkTransactionSynchStatus();
        this.transactionCoordinator.getJdbcCoordinator().getLogicalConnection().manualReconnect(conn);
    }

    @Override
    public void setAutoClear(boolean enabled) {
        this.errorIfClosed();
        this.autoClear = enabled;
    }

    @Override
    public void disableTransactionAutoJoin() {
        this.errorIfClosed();
        this.autoJoinTransactions = false;
    }

    public void afterOperation(boolean success) {
        if (!this.transactionCoordinator.isTransactionInProgress()) {
            this.transactionCoordinator.afterNonTransactionalQuery(success);
        }
    }

    @Override
    public void afterTransactionBegin(TransactionImplementor hibernateTransaction) {
        this.errorIfClosed();
        this.interceptor.afterTransactionBegin(hibernateTransaction);
    }

    @Override
    public void beforeTransactionCompletion(TransactionImplementor hibernateTransaction) {
        LOG.trace("before transaction completion");
        this.actionQueue.beforeTransactionCompletion();
        if (this.rootSession == null) {
            try {
                this.interceptor.beforeTransactionCompletion(hibernateTransaction);
            }
            catch (Throwable t) {
                LOG.exceptionInBeforeTransactionCompletionInterceptor(t);
            }
        }
    }

    @Override
    public void afterTransactionCompletion(TransactionImplementor hibernateTransaction, boolean successful) {
        LOG.trace("after transaction completion");
        this.persistenceContext.afterTransactionCompletion();
        this.actionQueue.afterTransactionCompletion(successful);
        if (this.rootSession == null && hibernateTransaction != null) {
            try {
                this.interceptor.afterTransactionCompletion(hibernateTransaction);
            }
            catch (Throwable t) {
                LOG.exceptionInAfterTransactionCompletionInterceptor(t);
            }
        }
        if (this.autoClear) {
            this.clear();
        }
    }

    private void cleanup() {
        this.persistenceContext.clear();
    }

    @Override
    public LockMode getCurrentLockMode(Object object) throws HibernateException {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        if (object == null) {
            throw new NullPointerException("null object passed to getCurrentLockMode()");
        }
        if (object instanceof HibernateProxy && (object = ((HibernateProxy)object).getHibernateLazyInitializer().getImplementation(this)) == null) {
            return LockMode.NONE;
        }
        EntityEntry e = this.persistenceContext.getEntry(object);
        if (e == null) {
            throw new TransientObjectException("Given object not associated with the session");
        }
        if (e.getStatus() != Status.MANAGED) {
            throw new ObjectDeletedException("The given object was deleted", e.getId(), e.getPersister().getEntityName());
        }
        return e.getLockMode();
    }

    @Override
    public Object getEntityUsingInterceptor(EntityKey key) throws HibernateException {
        this.errorIfClosed();
        Object result = this.persistenceContext.getEntity(key);
        if (result == null) {
            Object newObject = this.interceptor.getEntity(key.getEntityName(), key.getIdentifier());
            if (newObject != null) {
                this.lock(newObject, LockMode.NONE);
            }
            return newObject;
        }
        return result;
    }

    @Override
    public void saveOrUpdate(Object object) throws HibernateException {
        this.saveOrUpdate(null, object);
    }

    @Override
    public void saveOrUpdate(String entityName, Object obj) throws HibernateException {
        this.fireSaveOrUpdate(new SaveOrUpdateEvent(entityName, obj, this));
    }

    private void fireSaveOrUpdate(SaveOrUpdateEvent event) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        for (SaveOrUpdateEventListener listener : this.listeners(EventType.SAVE_UPDATE)) {
            listener.onSaveOrUpdate(event);
        }
    }

    private <T> Iterable<T> listeners(EventType<T> type) {
        return this.eventListenerGroup(type).listeners();
    }

    private <T> EventListenerGroup<T> eventListenerGroup(EventType<T> type) {
        return this.factory.getServiceRegistry().getService(EventListenerRegistry.class).getEventListenerGroup(type);
    }

    @Override
    public Serializable save(Object obj) throws HibernateException {
        return this.save(null, obj);
    }

    @Override
    public Serializable save(String entityName, Object object) throws HibernateException {
        return this.fireSave(new SaveOrUpdateEvent(entityName, object, this));
    }

    private Serializable fireSave(SaveOrUpdateEvent event) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        for (SaveOrUpdateEventListener listener : this.listeners(EventType.SAVE)) {
            listener.onSaveOrUpdate(event);
        }
        return event.getResultId();
    }

    @Override
    public void update(Object obj) throws HibernateException {
        this.update(null, obj);
    }

    @Override
    public void update(String entityName, Object object) throws HibernateException {
        this.fireUpdate(new SaveOrUpdateEvent(entityName, object, this));
    }

    private void fireUpdate(SaveOrUpdateEvent event) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        for (SaveOrUpdateEventListener listener : this.listeners(EventType.UPDATE)) {
            listener.onSaveOrUpdate(event);
        }
    }

    @Override
    public void lock(String entityName, Object object, LockMode lockMode) throws HibernateException {
        this.fireLock(new LockEvent(entityName, object, lockMode, (EventSource)this));
    }

    @Override
    public Session.LockRequest buildLockRequest(LockOptions lockOptions) {
        return new LockRequestImpl(lockOptions);
    }

    @Override
    public void lock(Object object, LockMode lockMode) throws HibernateException {
        this.fireLock(new LockEvent(object, lockMode, (EventSource)this));
    }

    private void fireLock(String entityName, Object object, LockOptions options) {
        this.fireLock(new LockEvent(entityName, object, options, (EventSource)this));
    }

    private void fireLock(Object object, LockOptions options) {
        this.fireLock(new LockEvent(object, options, (EventSource)this));
    }

    private void fireLock(LockEvent event) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        for (LockEventListener listener : this.listeners(EventType.LOCK)) {
            listener.onLock(event);
        }
    }

    @Override
    public void persist(String entityName, Object object) throws HibernateException {
        this.firePersist(new PersistEvent(entityName, object, this));
    }

    @Override
    public void persist(Object object) throws HibernateException {
        this.persist(null, object);
    }

    @Override
    public void persist(String entityName, Object object, Map copiedAlready) throws HibernateException {
        this.firePersist(copiedAlready, new PersistEvent(entityName, object, this));
    }

    private void firePersist(Map copiedAlready, PersistEvent event) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        for (PersistEventListener listener : this.listeners(EventType.PERSIST)) {
            listener.onPersist(event, copiedAlready);
        }
    }

    private void firePersist(PersistEvent event) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        for (PersistEventListener listener : this.listeners(EventType.PERSIST)) {
            listener.onPersist(event);
        }
    }

    public void persistOnFlush(String entityName, Object object) throws HibernateException {
        this.firePersistOnFlush(new PersistEvent(entityName, object, this));
    }

    public void persistOnFlush(Object object) throws HibernateException {
        this.persist(null, object);
    }

    @Override
    public void persistOnFlush(String entityName, Object object, Map copiedAlready) throws HibernateException {
        this.firePersistOnFlush(copiedAlready, new PersistEvent(entityName, object, this));
    }

    private void firePersistOnFlush(Map copiedAlready, PersistEvent event) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        for (PersistEventListener listener : this.listeners(EventType.PERSIST_ONFLUSH)) {
            listener.onPersist(event, copiedAlready);
        }
    }

    private void firePersistOnFlush(PersistEvent event) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        for (PersistEventListener listener : this.listeners(EventType.PERSIST_ONFLUSH)) {
            listener.onPersist(event);
        }
    }

    @Override
    public Object merge(String entityName, Object object) throws HibernateException {
        return this.fireMerge(new MergeEvent(entityName, object, this));
    }

    @Override
    public Object merge(Object object) throws HibernateException {
        return this.merge(null, object);
    }

    @Override
    public void merge(String entityName, Object object, Map copiedAlready) throws HibernateException {
        this.fireMerge(copiedAlready, new MergeEvent(entityName, object, this));
    }

    private Object fireMerge(MergeEvent event) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        for (MergeEventListener listener : this.listeners(EventType.MERGE)) {
            listener.onMerge(event);
        }
        return event.getResult();
    }

    private void fireMerge(Map copiedAlready, MergeEvent event) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        for (MergeEventListener listener : this.listeners(EventType.MERGE)) {
            listener.onMerge(event, copiedAlready);
        }
    }

    @Override
    public void delete(Object object) throws HibernateException {
        this.fireDelete(new DeleteEvent(object, this));
    }

    @Override
    public void delete(String entityName, Object object) throws HibernateException {
        this.fireDelete(new DeleteEvent(entityName, object, this));
    }

    @Override
    public void delete(String entityName, Object object, boolean isCascadeDeleteEnabled, Set transientEntities) throws HibernateException {
        this.fireDelete(new DeleteEvent(entityName, object, isCascadeDeleteEnabled, this), transientEntities);
    }

    private void fireDelete(DeleteEvent event) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        for (DeleteEventListener listener : this.listeners(EventType.DELETE)) {
            listener.onDelete(event);
        }
    }

    private void fireDelete(DeleteEvent event, Set transientEntities) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        for (DeleteEventListener listener : this.listeners(EventType.DELETE)) {
            listener.onDelete(event, transientEntities);
        }
    }

    @Override
    public void load(Object object, Serializable id) throws HibernateException {
        LoadEvent event = new LoadEvent(id, object, this);
        this.fireLoad(event, LoadEventListener.RELOAD);
    }

    @Override
    public Object load(Class entityClass, Serializable id) throws HibernateException {
        return this.load(entityClass.getName(), id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object load(String entityName, Serializable id) throws HibernateException {
        LoadEvent event = new LoadEvent(id, entityName, false, (EventSource)this);
        boolean success = false;
        try {
            this.fireLoad(event, LoadEventListener.LOAD);
            if (event.getResult() == null) {
                this.getFactory().getEntityNotFoundDelegate().handleEntityNotFound(entityName, id);
            }
            success = true;
            Object object = event.getResult();
            return object;
        }
        finally {
            this.afterOperation(success);
        }
    }

    @Override
    public Object get(Class entityClass, Serializable id) throws HibernateException {
        return this.get(entityClass.getName(), id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object get(String entityName, Serializable id) throws HibernateException {
        LoadEvent event = new LoadEvent(id, entityName, false, (EventSource)this);
        boolean success = false;
        try {
            this.fireLoad(event, LoadEventListener.GET);
            success = true;
            Object object = event.getResult();
            return object;
        }
        finally {
            this.afterOperation(success);
        }
    }

    @Override
    public Object immediateLoad(String entityName, Serializable id) throws HibernateException {
        if (LOG.isDebugEnabled()) {
            EntityPersister persister = this.getFactory().getEntityPersister(entityName);
            LOG.debugf("Initializing proxy: %s", MessageHelper.infoString(persister, id, this.getFactory()));
        }
        LoadEvent event = new LoadEvent(id, entityName, true, (EventSource)this);
        this.fireLoad(event, LoadEventListener.IMMEDIATE_LOAD);
        return event.getResult();
    }

    @Override
    public Object internalLoad(String entityName, Serializable id, boolean eager, boolean nullable) throws HibernateException {
        LoadEventListener.LoadType type = nullable ? LoadEventListener.INTERNAL_LOAD_NULLABLE : (eager ? LoadEventListener.INTERNAL_LOAD_EAGER : LoadEventListener.INTERNAL_LOAD_LAZY);
        LoadEvent event = new LoadEvent(id, entityName, true, (EventSource)this);
        this.fireLoad(event, type);
        if (!nullable) {
            UnresolvableObjectException.throwIfNull(event.getResult(), id, entityName);
        }
        return event.getResult();
    }

    @Override
    public Object load(Class entityClass, Serializable id, LockMode lockMode) throws HibernateException {
        return this.load(entityClass.getName(), id, lockMode);
    }

    @Override
    public Object load(Class entityClass, Serializable id, LockOptions lockOptions) throws HibernateException {
        return this.load(entityClass.getName(), id, lockOptions);
    }

    @Override
    public Object load(String entityName, Serializable id, LockMode lockMode) throws HibernateException {
        LoadEvent event = new LoadEvent(id, entityName, lockMode, (EventSource)this);
        this.fireLoad(event, LoadEventListener.LOAD);
        return event.getResult();
    }

    @Override
    public Object load(String entityName, Serializable id, LockOptions lockOptions) throws HibernateException {
        LoadEvent event = new LoadEvent(id, entityName, lockOptions, (EventSource)this);
        this.fireLoad(event, LoadEventListener.LOAD);
        return event.getResult();
    }

    @Override
    public Object get(Class entityClass, Serializable id, LockMode lockMode) throws HibernateException {
        return this.get(entityClass.getName(), id, lockMode);
    }

    @Override
    public Object get(Class entityClass, Serializable id, LockOptions lockOptions) throws HibernateException {
        return this.get(entityClass.getName(), id, lockOptions);
    }

    @Override
    public Object get(String entityName, Serializable id, LockMode lockMode) throws HibernateException {
        LoadEvent event = new LoadEvent(id, entityName, lockMode, (EventSource)this);
        this.fireLoad(event, LoadEventListener.GET);
        return event.getResult();
    }

    @Override
    public Object get(String entityName, Serializable id, LockOptions lockOptions) throws HibernateException {
        LoadEvent event = new LoadEvent(id, entityName, lockOptions, (EventSource)this);
        this.fireLoad(event, LoadEventListener.GET);
        return event.getResult();
    }

    private void fireLoad(LoadEvent event, LoadEventListener.LoadType loadType) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        for (LoadEventListener listener : this.listeners(EventType.LOAD)) {
            listener.onLoad(event, loadType);
        }
    }

    @Override
    public void refresh(Object object) throws HibernateException {
        this.fireRefresh(new RefreshEvent(object, this));
    }

    @Override
    public void refresh(Object object, LockMode lockMode) throws HibernateException {
        this.fireRefresh(new RefreshEvent(object, lockMode, (EventSource)this));
    }

    @Override
    public void refresh(Object object, LockOptions lockOptions) throws HibernateException {
        this.fireRefresh(new RefreshEvent(object, lockOptions, (EventSource)this));
    }

    @Override
    public void refresh(Object object, Map refreshedAlready) throws HibernateException {
        this.fireRefresh(refreshedAlready, new RefreshEvent(object, this));
    }

    private void fireRefresh(RefreshEvent event) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        for (RefreshEventListener listener : this.listeners(EventType.REFRESH)) {
            listener.onRefresh(event);
        }
    }

    private void fireRefresh(Map refreshedAlready, RefreshEvent event) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        for (RefreshEventListener listener : this.listeners(EventType.REFRESH)) {
            listener.onRefresh(event, refreshedAlready);
        }
    }

    @Override
    public void replicate(Object obj, ReplicationMode replicationMode) throws HibernateException {
        this.fireReplicate(new ReplicateEvent(obj, replicationMode, this));
    }

    @Override
    public void replicate(String entityName, Object obj, ReplicationMode replicationMode) throws HibernateException {
        this.fireReplicate(new ReplicateEvent(entityName, obj, replicationMode, this));
    }

    private void fireReplicate(ReplicateEvent event) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        for (ReplicateEventListener listener : this.listeners(EventType.REPLICATE)) {
            listener.onReplicate(event);
        }
    }

    @Override
    public void evict(Object object) throws HibernateException {
        this.fireEvict(new EvictEvent(object, this));
    }

    private void fireEvict(EvictEvent event) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        for (EvictEventListener listener : this.listeners(EventType.EVICT)) {
            listener.onEvict(event);
        }
    }

    protected boolean autoFlushIfRequired(Set querySpaces) throws HibernateException {
        this.errorIfClosed();
        if (!this.isTransactionInProgress()) {
            return false;
        }
        AutoFlushEvent event = new AutoFlushEvent(querySpaces, this);
        for (AutoFlushEventListener listener : this.listeners(EventType.AUTO_FLUSH)) {
            listener.onAutoFlush(event);
        }
        return event.isFlushRequired();
    }

    @Override
    public boolean isDirty() throws HibernateException {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        LOG.debugf("Checking session dirtiness", new Object[0]);
        if (this.actionQueue.areInsertionsOrDeletionsQueued()) {
            LOG.debugf("Session dirty (scheduled updates and insertions)", new Object[0]);
            return true;
        }
        DirtyCheckEvent event = new DirtyCheckEvent(this);
        for (DirtyCheckEventListener listener : this.listeners(EventType.DIRTY_CHECK)) {
            listener.onDirtyCheck(event);
        }
        return event.isDirty();
    }

    @Override
    public void flush() throws HibernateException {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        if (this.persistenceContext.getCascadeLevel() > 0) {
            throw new HibernateException("Flush during cascade is dangerous");
        }
        for (FlushEventListener listener : this.listeners(EventType.FLUSH)) {
            listener.onFlush(new FlushEvent(this));
        }
    }

    @Override
    public void forceFlush(EntityEntry entityEntry) throws HibernateException {
        this.errorIfClosed();
        if (LOG.isDebugEnabled()) {
            LOG.debugf("Flushing to force deletion of re-saved object: %s", MessageHelper.infoString(entityEntry.getPersister(), entityEntry.getId(), this.getFactory()));
        }
        if (this.persistenceContext.getCascadeLevel() > 0) {
            throw new ObjectDeletedException("deleted object would be re-saved by cascade (remove deleted object from associations)", entityEntry.getId(), entityEntry.getPersister().getEntityName());
        }
        this.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List list(String query, QueryParameters queryParameters) throws HibernateException {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        queryParameters.validateParameters();
        HQLQueryPlan plan = this.getHQLQueryPlan(query, false);
        this.autoFlushIfRequired(plan.getQuerySpaces());
        List results = CollectionHelper.EMPTY_LIST;
        boolean success = false;
        ++this.dontFlushFromFind;
        try {
            results = plan.performList(queryParameters, this);
            success = true;
        }
        finally {
            --this.dontFlushFromFind;
            this.afterOperation(success);
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate(String query, QueryParameters queryParameters) throws HibernateException {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        queryParameters.validateParameters();
        HQLQueryPlan plan = this.getHQLQueryPlan(query, false);
        this.autoFlushIfRequired(plan.getQuerySpaces());
        boolean success = false;
        int result = 0;
        try {
            result = plan.performExecuteUpdate(queryParameters, this);
            success = true;
        }
        finally {
            this.afterOperation(success);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeNativeUpdate(NativeSQLQuerySpecification nativeQuerySpecification, QueryParameters queryParameters) throws HibernateException {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        queryParameters.validateParameters();
        NativeSQLQueryPlan plan = this.getNativeSQLQueryPlan(nativeQuerySpecification);
        this.autoFlushIfRequired(plan.getCustomQuery().getQuerySpaces());
        boolean success = false;
        int result = 0;
        try {
            result = plan.performExecuteUpdate(queryParameters, this);
            success = true;
        }
        finally {
            this.afterOperation(success);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator iterate(String query, QueryParameters queryParameters) throws HibernateException {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        queryParameters.validateParameters();
        HQLQueryPlan plan = this.getHQLQueryPlan(query, true);
        this.autoFlushIfRequired(plan.getQuerySpaces());
        ++this.dontFlushFromFind;
        try {
            Iterator iterator = plan.performIterate(queryParameters, this);
            return iterator;
        }
        finally {
            --this.dontFlushFromFind;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScrollableResults scroll(String query, QueryParameters queryParameters) throws HibernateException {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        HQLQueryPlan plan = this.getHQLQueryPlan(query, false);
        this.autoFlushIfRequired(plan.getQuerySpaces());
        ++this.dontFlushFromFind;
        try {
            ScrollableResults scrollableResults = plan.performScroll(queryParameters, this);
            return scrollableResults;
        }
        finally {
            --this.dontFlushFromFind;
        }
    }

    @Override
    public Query createFilter(Object collection, String queryString) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        CollectionFilterImpl filter = new CollectionFilterImpl(queryString, collection, (SessionImplementor)this, this.getFilterQueryPlan(collection, queryString, null, false).getParameterMetadata());
        filter.setComment(queryString);
        return filter;
    }

    @Override
    public Query getNamedQuery(String queryName) throws MappingException {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        return super.getNamedQuery(queryName);
    }

    @Override
    public Object instantiate(String entityName, Serializable id) throws HibernateException {
        return this.instantiate(this.factory.getEntityPersister(entityName), id);
    }

    @Override
    public Object instantiate(EntityPersister persister, Serializable id) throws HibernateException {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        Object result = this.interceptor.instantiate(persister.getEntityName(), this.entityMode, id);
        if (result == null) {
            result = persister.instantiate(id, this);
        }
        return result;
    }

    @Override
    public EntityMode getEntityMode() {
        this.checkTransactionSynchStatus();
        return this.entityMode;
    }

    @Override
    public void setFlushMode(FlushMode flushMode) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        LOG.trace("Setting flush mode to: " + flushMode);
        this.flushMode = flushMode;
    }

    @Override
    public FlushMode getFlushMode() {
        this.checkTransactionSynchStatus();
        return this.flushMode;
    }

    @Override
    public CacheMode getCacheMode() {
        this.checkTransactionSynchStatus();
        return this.cacheMode;
    }

    @Override
    public void setCacheMode(CacheMode cacheMode) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        LOG.trace("Setting cache mode to: " + cacheMode);
        this.cacheMode = cacheMode;
    }

    @Override
    public Transaction getTransaction() throws HibernateException {
        this.errorIfClosed();
        return this.transactionCoordinator.getTransaction();
    }

    @Override
    public Transaction beginTransaction() throws HibernateException {
        this.errorIfClosed();
        if (this.rootSession != null) {
            LOG.transactionStartedOnNonRootSession();
        }
        Transaction result = this.getTransaction();
        result.begin();
        return result;
    }

    @Override
    public EntityPersister getEntityPersister(String entityName, Object object) {
        this.errorIfClosed();
        if (entityName == null) {
            return this.factory.getEntityPersister(this.guessEntityName(object));
        }
        try {
            return this.factory.getEntityPersister(entityName).getSubclassEntityPersister(object, this.getFactory(), this.entityMode);
        }
        catch (HibernateException e) {
            try {
                return this.getEntityPersister(null, object);
            }
            catch (HibernateException e2) {
                throw e;
            }
        }
    }

    @Override
    public Serializable getIdentifier(Object object) throws HibernateException {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        if (object instanceof HibernateProxy) {
            LazyInitializer li = ((HibernateProxy)object).getHibernateLazyInitializer();
            if (li.getSession() != this) {
                throw new TransientObjectException("The proxy was not associated with this session");
            }
            return li.getIdentifier();
        }
        EntityEntry entry = this.persistenceContext.getEntry(object);
        if (entry == null) {
            throw new TransientObjectException("The instance was not associated with this session");
        }
        return entry.getId();
    }

    @Override
    public Serializable getContextEntityIdentifier(Object object) {
        this.errorIfClosed();
        if (object instanceof HibernateProxy) {
            return this.getProxyIdentifier(object);
        }
        EntityEntry entry = this.persistenceContext.getEntry(object);
        return entry != null ? entry.getId() : null;
    }

    private Serializable getProxyIdentifier(Object proxy) {
        return ((HibernateProxy)proxy).getHibernateLazyInitializer().getIdentifier();
    }

    private FilterQueryPlan getFilterQueryPlan(Object collection, String filter, QueryParameters parameters, boolean shallow) throws HibernateException {
        if (collection == null) {
            throw new NullPointerException("null collection passed to filter");
        }
        CollectionEntry entry = this.persistenceContext.getCollectionEntryOrNull(collection);
        CollectionPersister roleBeforeFlush = entry == null ? null : entry.getLoadedPersister();
        FilterQueryPlan plan = null;
        if (roleBeforeFlush == null) {
            CollectionPersister roleAfterFlush;
            this.flush();
            entry = this.persistenceContext.getCollectionEntryOrNull(collection);
            CollectionPersister collectionPersister = roleAfterFlush = entry == null ? null : entry.getLoadedPersister();
            if (roleAfterFlush == null) {
                throw new QueryException("The collection was unreferenced");
            }
            plan = this.factory.getQueryPlanCache().getFilterQueryPlan(filter, roleAfterFlush.getRole(), shallow, this.getEnabledFilters());
        } else {
            plan = this.factory.getQueryPlanCache().getFilterQueryPlan(filter, roleBeforeFlush.getRole(), shallow, this.getEnabledFilters());
            if (this.autoFlushIfRequired(plan.getQuerySpaces())) {
                CollectionPersister roleAfterFlush;
                entry = this.persistenceContext.getCollectionEntryOrNull(collection);
                CollectionPersister collectionPersister = roleAfterFlush = entry == null ? null : entry.getLoadedPersister();
                if (roleBeforeFlush != roleAfterFlush) {
                    if (roleAfterFlush == null) {
                        throw new QueryException("The collection was dereferenced");
                    }
                    plan = this.factory.getQueryPlanCache().getFilterQueryPlan(filter, roleAfterFlush.getRole(), shallow, this.getEnabledFilters());
                }
            }
        }
        if (parameters != null) {
            parameters.getPositionalParameterValues()[0] = entry.getLoadedKey();
            parameters.getPositionalParameterTypes()[0] = entry.getLoadedPersister().getKeyType();
        }
        return plan;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List listFilter(Object collection, String filter, QueryParameters queryParameters) throws HibernateException {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        FilterQueryPlan plan = this.getFilterQueryPlan(collection, filter, queryParameters, false);
        List results = CollectionHelper.EMPTY_LIST;
        boolean success = false;
        ++this.dontFlushFromFind;
        try {
            results = plan.performList(queryParameters, this);
            success = true;
        }
        finally {
            --this.dontFlushFromFind;
            this.afterOperation(success);
        }
        return results;
    }

    @Override
    public Iterator iterateFilter(Object collection, String filter, QueryParameters queryParameters) throws HibernateException {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        FilterQueryPlan plan = this.getFilterQueryPlan(collection, filter, queryParameters, true);
        return plan.performIterate(queryParameters, this);
    }

    @Override
    public Criteria createCriteria(Class persistentClass, String alias) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        return new CriteriaImpl(persistentClass.getName(), alias, this);
    }

    @Override
    public Criteria createCriteria(String entityName, String alias) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        return new CriteriaImpl(entityName, alias, this);
    }

    @Override
    public Criteria createCriteria(Class persistentClass) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        return new CriteriaImpl(persistentClass.getName(), this);
    }

    @Override
    public Criteria createCriteria(String entityName) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        return new CriteriaImpl(entityName, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScrollableResults scroll(CriteriaImpl criteria, ScrollMode scrollMode) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        String entityName = criteria.getEntityOrClassName();
        CriteriaLoader loader = new CriteriaLoader(this.getOuterJoinLoadable(entityName), this.factory, criteria, entityName, this.getLoadQueryInfluencers());
        this.autoFlushIfRequired(loader.getQuerySpaces());
        ++this.dontFlushFromFind;
        try {
            ScrollableResults scrollableResults = loader.scroll(this, scrollMode);
            return scrollableResults;
        }
        finally {
            --this.dontFlushFromFind;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List list(CriteriaImpl criteria) throws HibernateException {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        String[] implementors = this.factory.getImplementors(criteria.getEntityOrClassName());
        int size = implementors.length;
        CriteriaLoader[] loaders = new CriteriaLoader[size];
        HashSet spaces = new HashSet();
        for (int i = 0; i < size; ++i) {
            loaders[i] = new CriteriaLoader(this.getOuterJoinLoadable(implementors[i]), this.factory, criteria, implementors[i], this.getLoadQueryInfluencers());
            spaces.addAll(loaders[i].getQuerySpaces());
        }
        this.autoFlushIfRequired(spaces);
        List results = Collections.EMPTY_LIST;
        ++this.dontFlushFromFind;
        boolean success = false;
        try {
            for (int i = 0; i < size; ++i) {
                List currentResults = loaders[i].list(this);
                currentResults.addAll(results);
                results = currentResults;
            }
            success = true;
        }
        finally {
            --this.dontFlushFromFind;
            this.afterOperation(success);
        }
        return results;
    }

    private OuterJoinLoadable getOuterJoinLoadable(String entityName) throws MappingException {
        EntityPersister persister = this.factory.getEntityPersister(entityName);
        if (!(persister instanceof OuterJoinLoadable)) {
            throw new MappingException("class persister is not OuterJoinLoadable: " + entityName);
        }
        return (OuterJoinLoadable)persister;
    }

    @Override
    public boolean contains(Object object) {
        EntityEntry entry;
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        if (object instanceof HibernateProxy) {
            LazyInitializer li = ((HibernateProxy)object).getHibernateLazyInitializer();
            if (li.isUninitialized()) {
                return li.getSession() == this;
            }
            object = li.getImplementation();
        }
        return (entry = this.persistenceContext.getEntry(object)) != null && entry.getStatus() != Status.DELETED && entry.getStatus() != Status.GONE;
    }

    @Override
    public Query createQuery(String queryString) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        return super.createQuery(queryString);
    }

    @Override
    public SQLQuery createSQLQuery(String sql) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        return super.createSQLQuery(sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScrollableResults scrollCustomQuery(CustomQuery customQuery, QueryParameters queryParameters) throws HibernateException {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        LOG.trace("Scroll SQL query: " + customQuery.getSQL());
        CustomLoader loader = new CustomLoader(customQuery, this.getFactory());
        this.autoFlushIfRequired(loader.getQuerySpaces());
        ++this.dontFlushFromFind;
        try {
            ScrollableResults scrollableResults = loader.scroll(queryParameters, this);
            return scrollableResults;
        }
        finally {
            --this.dontFlushFromFind;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List listCustomQuery(CustomQuery customQuery, QueryParameters queryParameters) throws HibernateException {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        LOG.trace("SQL query: " + customQuery.getSQL());
        CustomLoader loader = new CustomLoader(customQuery, this.getFactory());
        this.autoFlushIfRequired(loader.getQuerySpaces());
        ++this.dontFlushFromFind;
        boolean success = false;
        try {
            List results = loader.list(this, queryParameters);
            success = true;
            List list = results;
            return list;
        }
        finally {
            --this.dontFlushFromFind;
            this.afterOperation(success);
        }
    }

    @Override
    public SessionFactoryImplementor getSessionFactory() {
        this.checkTransactionSynchStatus();
        return this.factory;
    }

    @Override
    public void initializeCollection(PersistentCollection collection, boolean writing) throws HibernateException {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        InitializeCollectionEvent event = new InitializeCollectionEvent(collection, this);
        for (InitializeCollectionEventListener listener : this.listeners(EventType.INIT_COLLECTION)) {
            listener.onInitializeCollection(event);
        }
    }

    @Override
    public String bestGuessEntityName(Object object) {
        EntityEntry entry;
        if (object instanceof HibernateProxy) {
            LazyInitializer initializer = ((HibernateProxy)object).getHibernateLazyInitializer();
            if (initializer.isUninitialized()) {
                return initializer.getEntityName();
            }
            object = initializer.getImplementation();
        }
        if ((entry = this.persistenceContext.getEntry(object)) == null) {
            return this.guessEntityName(object);
        }
        return entry.getPersister().getEntityName();
    }

    @Override
    public String getEntityName(Object object) {
        EntityEntry entry;
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        if (object instanceof HibernateProxy) {
            if (!this.persistenceContext.containsProxy(object)) {
                throw new TransientObjectException("proxy was not associated with the session");
            }
            object = ((HibernateProxy)object).getHibernateLazyInitializer().getImplementation();
        }
        if ((entry = this.persistenceContext.getEntry(object)) == null) {
            this.throwTransientObjectException(object);
        }
        return entry.getPersister().getEntityName();
    }

    private void throwTransientObjectException(Object object) throws HibernateException {
        throw new TransientObjectException("object references an unsaved transient instance - save the transient instance before flushing: " + this.guessEntityName(object));
    }

    @Override
    public String guessEntityName(Object object) throws HibernateException {
        this.errorIfClosed();
        return this.entityNameResolver.resolveEntityName(object);
    }

    @Override
    public void cancelQuery() throws HibernateException {
        this.errorIfClosed();
        this.getTransactionCoordinator().getJdbcCoordinator().cancelLastQuery();
    }

    @Override
    public Interceptor getInterceptor() {
        this.checkTransactionSynchStatus();
        return this.interceptor;
    }

    @Override
    public int getDontFlushFromFind() {
        return this.dontFlushFromFind;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(500).append("SessionImpl(");
        if (!this.isClosed()) {
            buf.append(this.persistenceContext).append(";").append(this.actionQueue);
        } else {
            buf.append("<closed>");
        }
        return buf.append(')').toString();
    }

    @Override
    public ActionQueue getActionQueue() {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        return this.actionQueue;
    }

    @Override
    public PersistenceContext getPersistenceContext() {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        return this.persistenceContext;
    }

    @Override
    public SessionStatistics getStatistics() {
        this.checkTransactionSynchStatus();
        return new SessionStatisticsImpl(this);
    }

    @Override
    public boolean isEventSource() {
        this.checkTransactionSynchStatus();
        return true;
    }

    @Override
    public boolean isDefaultReadOnly() {
        return this.persistenceContext.isDefaultReadOnly();
    }

    @Override
    public void setDefaultReadOnly(boolean defaultReadOnly) {
        this.persistenceContext.setDefaultReadOnly(defaultReadOnly);
    }

    @Override
    public boolean isReadOnly(Object entityOrProxy) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        return this.persistenceContext.isReadOnly(entityOrProxy);
    }

    @Override
    public void setReadOnly(Object entity, boolean readOnly) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        this.persistenceContext.setReadOnly(entity, readOnly);
    }

    @Override
    public void doWork(final Work work) throws HibernateException {
        WorkExecutorVisitable<Void> realWork = new WorkExecutorVisitable<Void>(){

            @Override
            public Void accept(WorkExecutor<Void> workExecutor, Connection connection) throws SQLException {
                workExecutor.executeWork(work, connection);
                return null;
            }
        };
        this.doWork(realWork);
    }

    @Override
    public <T> T doReturningWork(final ReturningWork<T> work) throws HibernateException {
        WorkExecutorVisitable realWork = new WorkExecutorVisitable<T>(){

            @Override
            public T accept(WorkExecutor<T> workExecutor, Connection connection) throws SQLException {
                return workExecutor.executeReturningWork(work, connection);
            }
        };
        return this.doWork(realWork);
    }

    private <T> T doWork(WorkExecutorVisitable<T> work) throws HibernateException {
        return this.transactionCoordinator.getJdbcCoordinator().coordinateWork(work);
    }

    @Override
    public void afterScrollOperation() {
    }

    @Override
    public TransactionCoordinator getTransactionCoordinator() {
        this.errorIfClosed();
        return this.transactionCoordinator;
    }

    @Override
    public LoadQueryInfluencers getLoadQueryInfluencers() {
        return this.loadQueryInfluencers;
    }

    @Override
    public Filter getEnabledFilter(String filterName) {
        this.checkTransactionSynchStatus();
        return this.loadQueryInfluencers.getEnabledFilter(filterName);
    }

    @Override
    public Filter enableFilter(String filterName) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        return this.loadQueryInfluencers.enableFilter(filterName);
    }

    @Override
    public void disableFilter(String filterName) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        this.loadQueryInfluencers.disableFilter(filterName);
    }

    @Override
    public Object getFilterParameterValue(String filterParameterName) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        return this.loadQueryInfluencers.getFilterParameterValue(filterParameterName);
    }

    @Override
    public Type getFilterParameterType(String filterParameterName) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        return this.loadQueryInfluencers.getFilterParameterType(filterParameterName);
    }

    @Override
    public Map getEnabledFilters() {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        return this.loadQueryInfluencers.getEnabledFilters();
    }

    @Override
    public String getFetchProfile() {
        this.checkTransactionSynchStatus();
        return this.loadQueryInfluencers.getInternalFetchProfile();
    }

    @Override
    public void setFetchProfile(String fetchProfile) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        this.loadQueryInfluencers.setInternalFetchProfile(fetchProfile);
    }

    @Override
    public boolean isFetchProfileEnabled(String name) throws UnknownProfileException {
        return this.loadQueryInfluencers.isFetchProfileEnabled(name);
    }

    @Override
    public void enableFetchProfile(String name) throws UnknownProfileException {
        this.loadQueryInfluencers.enableFetchProfile(name);
    }

    @Override
    public void disableFetchProfile(String name) throws UnknownProfileException {
        this.loadQueryInfluencers.disableFetchProfile(name);
    }

    private void checkTransactionSynchStatus() {
        if (!this.isClosed()) {
            this.transactionCoordinator.pulse();
        }
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        LOG.trace("Deserializing session");
        ois.defaultReadObject();
        this.entityNameResolver = new CoordinatingEntityNameResolver();
        boolean isRootSession = ois.readBoolean();
        this.connectionReleaseMode = ConnectionReleaseMode.parse((String)ois.readObject());
        this.entityMode = EntityMode.parse((String)ois.readObject());
        this.autoClear = ois.readBoolean();
        this.autoJoinTransactions = ois.readBoolean();
        this.flushMode = FlushMode.parse((String)ois.readObject());
        this.cacheMode = CacheMode.parse((String)ois.readObject());
        this.flushBeforeCompletionEnabled = ois.readBoolean();
        this.autoCloseSessionEnabled = ois.readBoolean();
        this.interceptor = (Interceptor)ois.readObject();
        this.factory = SessionFactoryImpl.deserialize(ois);
        if (isRootSession) {
            this.transactionCoordinator = TransactionCoordinatorImpl.deserialize(ois, this);
        }
        this.persistenceContext = StatefulPersistenceContext.deserialize(ois, this);
        this.actionQueue = ActionQueue.deserialize(ois, this);
        this.loadQueryInfluencers = (LoadQueryInfluencers)ois.readObject();
        this.childSessionsByEntityMode = (Map)ois.readObject();
        for (String filterName : this.loadQueryInfluencers.getEnabledFilterNames()) {
            ((FilterImpl)this.loadQueryInfluencers.getEnabledFilter(filterName)).afterDeserialize(this.factory);
        }
        if (isRootSession && this.childSessionsByEntityMode != null) {
            for (SessionImpl child : this.childSessionsByEntityMode.values()) {
                child.rootSession = this;
                child.transactionCoordinator = this.transactionCoordinator;
            }
        }
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        if (!this.transactionCoordinator.getJdbcCoordinator().getLogicalConnection().isReadyForSerialization()) {
            throw new IllegalStateException("Cannot serialize a session while connected");
        }
        LOG.trace("Serializing session");
        oos.defaultWriteObject();
        oos.writeBoolean(this.rootSession == null);
        oos.writeObject(this.connectionReleaseMode.toString());
        oos.writeObject(this.entityMode.toString());
        oos.writeBoolean(this.autoClear);
        oos.writeBoolean(this.autoJoinTransactions);
        oos.writeObject(this.flushMode.toString());
        oos.writeObject(this.cacheMode.toString());
        oos.writeBoolean(this.flushBeforeCompletionEnabled);
        oos.writeBoolean(this.autoCloseSessionEnabled);
        oos.writeObject(this.interceptor);
        this.factory.serialize(oos);
        if (this.rootSession == null) {
            this.transactionCoordinator.serialize(oos);
        }
        this.persistenceContext.serialize(oos);
        this.actionQueue.serialize(oos);
        oos.writeObject(this.loadQueryInfluencers);
        oos.writeObject(this.childSessionsByEntityMode);
    }

    @Override
    public TypeHelper getTypeHelper() {
        return this.getSessionFactory().getTypeHelper();
    }

    @Override
    public LobHelper getLobHelper() {
        if (this.lobHelper == null) {
            this.lobHelper = new LobHelperImpl(this);
        }
        return this.lobHelper;
    }

    private class LockRequestImpl
    implements Session.LockRequest {
        private final LockOptions lockOptions = new LockOptions();

        private LockRequestImpl(LockOptions lo) {
            LockOptions.copy(lo, this.lockOptions);
        }

        @Override
        public LockMode getLockMode() {
            return this.lockOptions.getLockMode();
        }

        @Override
        public Session.LockRequest setLockMode(LockMode lockMode) {
            this.lockOptions.setLockMode(lockMode);
            return this;
        }

        @Override
        public int getTimeOut() {
            return this.lockOptions.getTimeOut();
        }

        @Override
        public Session.LockRequest setTimeOut(int timeout) {
            this.lockOptions.setTimeOut(timeout);
            return this;
        }

        @Override
        public boolean getScope() {
            return this.lockOptions.getScope();
        }

        @Override
        public Session.LockRequest setScope(boolean scope) {
            this.lockOptions.setScope(scope);
            return this;
        }

        @Override
        public void lock(String entityName, Object object) throws HibernateException {
            SessionImpl.this.fireLock(entityName, object, this.lockOptions);
        }

        @Override
        public void lock(Object object) throws HibernateException {
            SessionImpl.this.fireLock(object, this.lockOptions);
        }
    }

    private class CoordinatingEntityNameResolver
    implements EntityNameResolver {
        private CoordinatingEntityNameResolver() {
        }

        @Override
        public String resolveEntityName(Object entity) {
            EntityNameResolver resolver;
            String entityName = SessionImpl.this.interceptor.getEntityName(entity);
            if (entityName != null) {
                return entityName;
            }
            Iterator itr = SessionImpl.this.factory.iterateEntityNameResolvers(SessionImpl.this.entityMode);
            while (itr.hasNext() && (entityName = (resolver = (EntityNameResolver)itr.next()).resolveEntityName(entity)) == null) {
            }
            if (entityName != null) {
                return entityName;
            }
            return entity.getClass().getName();
        }
    }

    private static class SharedSessionBuilderImpl
    extends SessionFactoryImpl.SessionBuilderImpl
    implements SharedSessionBuilder {
        private final SessionImpl session;
        private boolean shareTransactionContext;

        private SharedSessionBuilderImpl(SessionImpl session) {
            super(session.factory);
            this.session = session;
            super.tenantIdentifier(session.getTenantIdentifier());
        }

        @Override
        public SessionBuilder tenantIdentifier(String tenantIdentifier) {
            throw new SessionException("Cannot redefine tenant identifier on child session");
        }

        @Override
        protected TransactionCoordinatorImpl getTransactionCoordinator() {
            return this.shareTransactionContext ? this.session.transactionCoordinator : super.getTransactionCoordinator();
        }

        @Override
        public SharedSessionBuilder interceptor() {
            return this.interceptor(this.session.interceptor);
        }

        @Override
        public SharedSessionBuilder connection() {
            return this.connection(this.session.transactionCoordinator.getJdbcCoordinator().getLogicalConnection().getDistinctConnectionProxy());
        }

        @Override
        public SharedSessionBuilder connectionReleaseMode() {
            return this.connectionReleaseMode(this.session.connectionReleaseMode);
        }

        @Override
        public SharedSessionBuilder entityMode() {
            return this.entityMode(this.session.entityMode);
        }

        @Override
        public SharedSessionBuilder autoJoinTransactions() {
            return this.autoJoinTransactions(this.session.autoJoinTransactions);
        }

        @Override
        public SharedSessionBuilder autoClose() {
            return this.autoClose(this.session.autoCloseSessionEnabled);
        }

        @Override
        public SharedSessionBuilder flushBeforeCompletion() {
            return this.flushBeforeCompletion(this.session.flushBeforeCompletionEnabled);
        }

        @Override
        public SharedSessionBuilder transactionContext() {
            this.shareTransactionContext = true;
            return this;
        }

        @Override
        public SharedSessionBuilder interceptor(Interceptor interceptor) {
            return (SharedSessionBuilder)super.interceptor(interceptor);
        }

        @Override
        public SharedSessionBuilder noInterceptor() {
            return (SharedSessionBuilder)super.noInterceptor();
        }

        @Override
        public SharedSessionBuilder connection(Connection connection) {
            return (SharedSessionBuilder)super.connection(connection);
        }

        @Override
        public SharedSessionBuilder connectionReleaseMode(ConnectionReleaseMode connectionReleaseMode) {
            return (SharedSessionBuilder)super.connectionReleaseMode(connectionReleaseMode);
        }

        @Override
        public SharedSessionBuilder entityMode(EntityMode entityMode) {
            return (SharedSessionBuilder)super.entityMode(entityMode);
        }

        @Override
        public SharedSessionBuilder autoJoinTransactions(boolean autoJoinTransactions) {
            return (SharedSessionBuilder)super.autoJoinTransactions(autoJoinTransactions);
        }

        @Override
        public SharedSessionBuilder autoClose(boolean autoClose) {
            return (SharedSessionBuilder)super.autoClose(autoClose);
        }

        @Override
        public SharedSessionBuilder flushBeforeCompletion(boolean flushBeforeCompletion) {
            return (SharedSessionBuilder)super.flushBeforeCompletion(flushBeforeCompletion);
        }
    }

    private static class LobHelperImpl
    implements LobHelper {
        private final SessionImpl session;

        private LobHelperImpl(SessionImpl session) {
            this.session = session;
        }

        @Override
        public Blob createBlob(byte[] bytes) {
            return this.lobCreator().createBlob(bytes);
        }

        private LobCreator lobCreator() {
            return this.session.getFactory().getJdbcServices().getLobCreator(this.session);
        }

        @Override
        public Blob createBlob(InputStream stream, long length) {
            return this.lobCreator().createBlob(stream, length);
        }

        @Override
        public Clob createClob(String string) {
            return this.lobCreator().createClob(string);
        }

        @Override
        public Clob createClob(Reader reader, long length) {
            return this.lobCreator().createClob(reader, length);
        }

        @Override
        public NClob createNClob(String string) {
            return this.lobCreator().createNClob(string);
        }

        @Override
        public NClob createNClob(Reader reader, long length) {
            return this.lobCreator().createNClob(reader, length);
        }
    }
}

