/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.id.factory;

import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.hibernate.MappingException;
import org.hibernate.dialect.Dialect;
import org.hibernate.id.Assigned;
import org.hibernate.id.Configurable;
import org.hibernate.id.ForeignGenerator;
import org.hibernate.id.GUIDGenerator;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.id.IdentityGenerator;
import org.hibernate.id.IncrementGenerator;
import org.hibernate.id.SelectGenerator;
import org.hibernate.id.SequenceGenerator;
import org.hibernate.id.SequenceHiLoGenerator;
import org.hibernate.id.SequenceIdentityGenerator;
import org.hibernate.id.TableHiLoGenerator;
import org.hibernate.id.UUIDGenerator;
import org.hibernate.id.UUIDHexGenerator;
import org.hibernate.id.enhanced.SequenceStyleGenerator;
import org.hibernate.id.enhanced.TableGenerator;
import org.hibernate.id.factory.IdentifierGeneratorFactory;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.type.Type;
import org.jboss.logging.Logger;

public class DefaultIdentifierGeneratorFactory
implements IdentifierGeneratorFactory,
Serializable {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)DefaultIdentifierGeneratorFactory.class.getName());
    private transient Dialect dialect;
    private ConcurrentHashMap<String, Class> generatorStrategyToClassNameMap = new ConcurrentHashMap();

    public DefaultIdentifierGeneratorFactory() {
        this.register("uuid2", UUIDGenerator.class);
        this.register("guid", GUIDGenerator.class);
        this.register("uuid", UUIDHexGenerator.class);
        this.register("uuid.hex", UUIDHexGenerator.class);
        this.register("hilo", TableHiLoGenerator.class);
        this.register("assigned", Assigned.class);
        this.register("identity", IdentityGenerator.class);
        this.register("select", SelectGenerator.class);
        this.register("sequence", SequenceGenerator.class);
        this.register("seqhilo", SequenceHiLoGenerator.class);
        this.register("increment", IncrementGenerator.class);
        this.register("foreign", ForeignGenerator.class);
        this.register("sequence-identity", SequenceIdentityGenerator.class);
        this.register("enhanced-sequence", SequenceStyleGenerator.class);
        this.register("enhanced-table", TableGenerator.class);
    }

    @Override
    public void setDialect(Dialect dialect) {
        LOG.debugf("Setting dialect [%s]", dialect);
        this.dialect = dialect;
    }

    public void register(String strategy, Class generatorClass) {
        Class old = this.generatorStrategyToClassNameMap.put(strategy, generatorClass);
        String msg = "Registering IdentifierGenerator strategy [" + strategy + "] -> [" + generatorClass + "]";
        if (old != null) {
            msg = msg + ", overriding [" + old + "]";
        }
        LOG.debugf(msg, new Object[0]);
    }

    @Override
    public IdentifierGenerator createIdentifierGenerator(String strategy, Type type, Properties config) {
        try {
            Class clazz = this.getIdentifierGeneratorClass(strategy);
            IdentifierGenerator idgen = (IdentifierGenerator)clazz.newInstance();
            if (idgen instanceof Configurable) {
                ((Configurable)((Object)idgen)).configure(type, config, this.dialect);
            }
            return idgen;
        }
        catch (Exception e) {
            String msg = "Could not instantiate id generator [entity-name=" + config.get("entity_name") + "]";
            throw new MappingException(msg, e);
        }
    }

    @Override
    public Class getIdentifierGeneratorClass(String strategy) {
        if ("native".equals(strategy)) {
            return this.dialect.getNativeIdentifierGeneratorClass();
        }
        Class generatorClass = this.generatorStrategyToClassNameMap.get(strategy);
        try {
            if (generatorClass == null) {
                generatorClass = ReflectHelper.classForName(strategy);
            }
        }
        catch (ClassNotFoundException e) {
            throw new MappingException("Could not interpret id generator strategy [" + strategy + "]");
        }
        return generatorClass;
    }
}

