/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.internal;

import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.ObjectDeletedException;
import org.hibernate.cache.spi.CacheKey;
import org.hibernate.cache.spi.access.SoftLock;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.Status;
import org.hibernate.event.internal.AbstractReassociateEventListener;
import org.hibernate.event.spi.EventSource;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.pretty.MessageHelper;
import org.jboss.logging.Logger;

public class AbstractLockUpgradeEventListener
extends AbstractReassociateEventListener {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)AbstractLockUpgradeEventListener.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void upgradeLock(Object object, EntityEntry entry, LockOptions lockOptions, EventSource source) {
        SoftLock lock;
        CacheKey ck;
        LockMode requestedLockMode = lockOptions.getLockMode();
        if (!requestedLockMode.greaterThan(entry.getLockMode())) return;
        if (entry.getStatus() != Status.MANAGED) {
            throw new ObjectDeletedException("attempted to lock a deleted instance", entry.getId(), entry.getPersister().getEntityName());
        }
        EntityPersister persister = entry.getPersister();
        if (LOG.isTraceEnabled()) {
            LOG.trace("Locking " + MessageHelper.infoString(persister, entry.getId(), source.getFactory()) + " in mode: " + requestedLockMode);
        }
        if (persister.hasCache()) {
            ck = source.generateCacheKey(entry.getId(), persister.getIdentifierType(), persister.getRootEntityName());
            lock = persister.getCacheAccessStrategy().lockItem(ck, entry.getVersion());
        } else {
            ck = null;
            lock = null;
        }
        try {
            if (persister.isVersioned() && requestedLockMode == LockMode.FORCE) {
                Object nextVersion = persister.forceVersionIncrement(entry.getId(), entry.getVersion(), source);
                entry.forceLocked(object, nextVersion);
            } else {
                persister.lock(entry.getId(), entry.getVersion(), object, lockOptions, (SessionImplementor)source);
            }
            entry.setLockMode(requestedLockMode);
            if (!persister.hasCache()) return;
        }
        catch (Throwable throwable) {
            if (!persister.hasCache()) throw throwable;
            persister.getCacheAccessStrategy().unlockItem(ck, lock);
            throw throwable;
        }
        persister.getCacheAccessStrategy().unlockItem(ck, lock);
    }
}

