/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.query.spi.sql;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.engine.query.spi.sql.NativeSQLQueryReturn;

public abstract class NativeSQLQueryNonScalarReturn
implements NativeSQLQueryReturn,
Serializable {
    private final String alias;
    private final LockMode lockMode;
    private final Map propertyResults = new HashMap();
    private final int hashCode;

    protected NativeSQLQueryNonScalarReturn(String alias, Map propertyResults, LockMode lockMode) {
        this.alias = alias;
        if (alias == null) {
            throw new HibernateException("alias must be specified");
        }
        this.lockMode = lockMode;
        if (propertyResults != null) {
            this.propertyResults.putAll(propertyResults);
        }
        this.hashCode = this.determineHashCode();
    }

    public String getAlias() {
        return this.alias;
    }

    public LockMode getLockMode() {
        return this.lockMode;
    }

    public Map getPropertyResultsMap() {
        return Collections.unmodifiableMap(this.propertyResults);
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int determineHashCode() {
        int result = this.alias != null ? this.alias.hashCode() : 0;
        result = 31 * result + this.getClass().getName().hashCode();
        result = 31 * result + (this.lockMode != null ? this.lockMode.hashCode() : 0);
        result = 31 * result + (this.propertyResults != null ? ((Object)this.propertyResults).hashCode() : 0);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NativeSQLQueryNonScalarReturn that = (NativeSQLQueryNonScalarReturn)o;
        if (this.alias != null ? !this.alias.equals(that.alias) : that.alias != null) {
            return false;
        }
        if (this.lockMode != null ? !this.lockMode.equals(that.lockMode) : that.lockMode != null) {
            return false;
        }
        return !(this.propertyResults != null ? !((Object)this.propertyResults).equals(that.propertyResults) : that.propertyResults != null);
    }
}

