/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg;

import org.hibernate.cfg.NamingStrategy;
import org.hibernate.internal.util.StringHelper;

public abstract class ObjectNameNormalizer {
    public String normalizeDatabaseIdentifier(String explicitName, NamingStrategyHelper helper) {
        if (StringHelper.isEmpty(explicitName)) {
            String objectName = helper.determineImplicitName(this.getNamingStrategy());
            return this.normalizeIdentifierQuoting(objectName);
        }
        String objectName = this.normalizeIdentifierQuoting(explicitName);
        objectName = helper.handleExplicitName(this.getNamingStrategy(), objectName);
        return this.normalizeIdentifierQuoting(objectName);
    }

    public String normalizeIdentifierQuoting(String identifier) {
        if (StringHelper.isEmpty(identifier)) {
            return null;
        }
        if (identifier.startsWith("\"") && identifier.endsWith("\"")) {
            return '`' + identifier.substring(1, identifier.length() - 1) + '`';
        }
        if (!(!this.isUseQuotedIdentifiersGlobally() || identifier.startsWith("`") && identifier.endsWith("`"))) {
            return '`' + identifier + '`';
        }
        return identifier;
    }

    protected abstract boolean isUseQuotedIdentifiersGlobally();

    protected abstract NamingStrategy getNamingStrategy();

    public static interface NamingStrategyHelper {
        public String determineImplicitName(NamingStrategy var1);

        public String handleExplicitName(NamingStrategy var1, String var2);
    }
}

