/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.hibernate.HibernateLogger;
import org.hibernate.MappingException;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.type.BasicType;
import org.hibernate.type.BasicTypeRegistry;
import org.hibernate.type.Type;
import org.hibernate.type.TypeFactory;
import org.hibernate.type.descriptor.sql.SqlTypeDescriptor;
import org.hibernate.usertype.CompositeUserType;
import org.hibernate.usertype.UserType;
import org.jboss.logging.Logger;

public class TypeResolver
implements Serializable {
    private static final HibernateLogger LOG = (HibernateLogger)Logger.getMessageLogger(HibernateLogger.class, (String)TypeResolver.class.getName());
    private final BasicTypeRegistry basicTypeRegistry;
    private final TypeFactory typeFactory;
    private final Map<SqlTypeDescriptor, SqlTypeDescriptor> resolvedSqlTypeDescriptors;

    public TypeResolver() {
        this(new BasicTypeRegistry(), new TypeFactory(), null);
    }

    public TypeResolver(BasicTypeRegistry basicTypeRegistry, TypeFactory typeFactory, Map<SqlTypeDescriptor, SqlTypeDescriptor> resolvedSqlTypeDescriptors) {
        this.basicTypeRegistry = basicTypeRegistry;
        this.typeFactory = typeFactory;
        this.resolvedSqlTypeDescriptors = resolvedSqlTypeDescriptors;
    }

    public TypeResolver scope(SessionFactoryImplementor factory) {
        this.typeFactory.injectSessionFactory(factory);
        return new TypeResolver(this.basicTypeRegistry.shallowCopy(), this.typeFactory, new HashMap<SqlTypeDescriptor, SqlTypeDescriptor>(25));
    }

    public void registerTypeOverride(BasicType type) {
        this.basicTypeRegistry.register(type);
    }

    public void registerTypeOverride(UserType type, String[] keys) {
        this.basicTypeRegistry.register(type, keys);
    }

    public void registerTypeOverride(CompositeUserType type, String[] keys) {
        this.basicTypeRegistry.register(type, keys);
    }

    public TypeFactory getTypeFactory() {
        return this.typeFactory;
    }

    public BasicType basic(String name) {
        return this.basicTypeRegistry.getRegisteredType(name);
    }

    public Type heuristicType(String typeName) throws MappingException {
        return this.heuristicType(typeName, null);
    }

    public Type heuristicType(String typeName, Properties parameters) throws MappingException {
        BasicType type = this.basic(typeName);
        if (type != null) {
            return type;
        }
        try {
            Class typeClass = ReflectHelper.classForName(typeName);
            if (typeClass != null) {
                return this.typeFactory.byClass(typeClass, parameters);
            }
        }
        catch (ClassNotFoundException ignore) {
            // empty catch block
        }
        return null;
    }

    public SqlTypeDescriptor resolveSqlTypeDescriptor(SqlTypeDescriptor sqlTypeDescriptor) {
        if (this.resolvedSqlTypeDescriptors == null) {
            throw new IllegalStateException("cannot resolve a SqlTypeDescriptor until the TypeResolver is scoped.");
        }
        SqlTypeDescriptor resolvedDescriptor = this.resolvedSqlTypeDescriptors.get(sqlTypeDescriptor);
        if (resolvedDescriptor == null) {
            resolvedDescriptor = this.typeFactory.resolveSessionFactory().getDialect().resolveSqlTypeDescriptor(sqlTypeDescriptor);
            if (resolvedDescriptor == null) {
                throw new IllegalStateException("dialect returned a resolved SqlTypeDescriptor that was null.");
            }
            if (sqlTypeDescriptor != resolvedDescriptor) {
                LOG.addingOverrideFor(sqlTypeDescriptor.getClass().getName(), resolvedDescriptor.getClass().getName());
                if (sqlTypeDescriptor.getSqlType() != resolvedDescriptor.getSqlType()) {
                    LOG.resolvedSqlTypeDescriptorForDifferentSqlCode(sqlTypeDescriptor.getClass().getName(), String.valueOf(sqlTypeDescriptor.getSqlType()), resolvedDescriptor.getClass().getName(), String.valueOf(resolvedDescriptor.getSqlType()));
                }
            }
            this.resolvedSqlTypeDescriptors.put(sqlTypeDescriptor, resolvedDescriptor);
        }
        return resolvedDescriptor;
    }
}

