/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.util.HashSet;
import java.util.Set;
import org.hibernate.type.AbstractSingleColumnStandardBasicType;
import org.hibernate.type.BigDecimalType;
import org.hibernate.type.BigIntegerType;
import org.hibernate.type.BinaryType;
import org.hibernate.type.BlobType;
import org.hibernate.type.BooleanType;
import org.hibernate.type.ByteType;
import org.hibernate.type.CalendarDateType;
import org.hibernate.type.CalendarType;
import org.hibernate.type.CharArrayType;
import org.hibernate.type.CharacterArrayType;
import org.hibernate.type.CharacterType;
import org.hibernate.type.ClassType;
import org.hibernate.type.ClobType;
import org.hibernate.type.CurrencyType;
import org.hibernate.type.DateType;
import org.hibernate.type.DoubleType;
import org.hibernate.type.FloatType;
import org.hibernate.type.ImageType;
import org.hibernate.type.IntegerType;
import org.hibernate.type.LocaleType;
import org.hibernate.type.LongType;
import org.hibernate.type.MaterializedBlobType;
import org.hibernate.type.MaterializedClobType;
import org.hibernate.type.NumericBooleanType;
import org.hibernate.type.SerializableType;
import org.hibernate.type.ShortType;
import org.hibernate.type.StringType;
import org.hibernate.type.TextType;
import org.hibernate.type.TimeType;
import org.hibernate.type.TimeZoneType;
import org.hibernate.type.TimestampType;
import org.hibernate.type.TrueFalseType;
import org.hibernate.type.UUIDBinaryType;
import org.hibernate.type.UUIDCharType;
import org.hibernate.type.UrlType;
import org.hibernate.type.WrapperBinaryType;
import org.hibernate.type.YesNoType;
import org.hibernate.type.descriptor.sql.SqlTypeDescriptor;

public class StandardBasicTypes {
    private static final Set<SqlTypeDescriptor> sqlTypeDescriptors = new HashSet<SqlTypeDescriptor>();
    public static final BooleanType BOOLEAN = StandardBasicTypes.register(BooleanType.INSTANCE);
    public static final NumericBooleanType NUMERIC_BOOLEAN = StandardBasicTypes.register(NumericBooleanType.INSTANCE);
    public static final TrueFalseType TRUE_FALSE = StandardBasicTypes.register(TrueFalseType.INSTANCE);
    public static final YesNoType YES_NO = StandardBasicTypes.register(YesNoType.INSTANCE);
    public static final ByteType BYTE = StandardBasicTypes.register(ByteType.INSTANCE);
    public static final ShortType SHORT = StandardBasicTypes.register(ShortType.INSTANCE);
    public static final IntegerType INTEGER = StandardBasicTypes.register(IntegerType.INSTANCE);
    public static final LongType LONG = StandardBasicTypes.register(LongType.INSTANCE);
    public static final FloatType FLOAT = StandardBasicTypes.register(FloatType.INSTANCE);
    public static final DoubleType DOUBLE = StandardBasicTypes.register(DoubleType.INSTANCE);
    public static final BigIntegerType BIG_INTEGER = StandardBasicTypes.register(BigIntegerType.INSTANCE);
    public static final BigDecimalType BIG_DECIMAL = StandardBasicTypes.register(BigDecimalType.INSTANCE);
    public static final CharacterType CHARACTER = StandardBasicTypes.register(CharacterType.INSTANCE);
    public static final StringType STRING = StandardBasicTypes.register(StringType.INSTANCE);
    public static final UrlType URL = StandardBasicTypes.register(UrlType.INSTANCE);
    public static final TimeType TIME = StandardBasicTypes.register(TimeType.INSTANCE);
    public static final DateType DATE = StandardBasicTypes.register(DateType.INSTANCE);
    public static final TimestampType TIMESTAMP = StandardBasicTypes.register(TimestampType.INSTANCE);
    public static final CalendarType CALENDAR = StandardBasicTypes.register(CalendarType.INSTANCE);
    public static final CalendarDateType CALENDAR_DATE = StandardBasicTypes.register(CalendarDateType.INSTANCE);
    public static final ClassType CLASS = StandardBasicTypes.register(ClassType.INSTANCE);
    public static final LocaleType LOCALE = StandardBasicTypes.register(LocaleType.INSTANCE);
    public static final CurrencyType CURRENCY = StandardBasicTypes.register(CurrencyType.INSTANCE);
    public static final TimeZoneType TIMEZONE = StandardBasicTypes.register(TimeZoneType.INSTANCE);
    public static final UUIDBinaryType UUID_BINARY = StandardBasicTypes.register(UUIDBinaryType.INSTANCE);
    public static final UUIDCharType UUID_CHAR = StandardBasicTypes.register(UUIDCharType.INSTANCE);
    public static final BinaryType BINARY = StandardBasicTypes.register(BinaryType.INSTANCE);
    public static final WrapperBinaryType WRAPPER_BINARY = StandardBasicTypes.register(WrapperBinaryType.INSTANCE);
    public static final ImageType IMAGE = StandardBasicTypes.register(ImageType.INSTANCE);
    public static final BlobType BLOB = StandardBasicTypes.register(BlobType.INSTANCE);
    public static final MaterializedBlobType MATERIALIZED_BLOB = StandardBasicTypes.register(MaterializedBlobType.INSTANCE);
    public static final CharArrayType CHAR_ARRAY = StandardBasicTypes.register(CharArrayType.INSTANCE);
    public static final CharacterArrayType CHARACTER_ARRAY = StandardBasicTypes.register(CharacterArrayType.INSTANCE);
    public static final TextType TEXT = StandardBasicTypes.register(TextType.INSTANCE);
    public static final ClobType CLOB = StandardBasicTypes.register(ClobType.INSTANCE);
    public static final MaterializedClobType MATERIALIZED_CLOB = StandardBasicTypes.register(MaterializedClobType.INSTANCE);
    public static final SerializableType SERIALIZABLE = StandardBasicTypes.register(SerializableType.INSTANCE);

    private static <T extends AbstractSingleColumnStandardBasicType> T register(T type) {
        sqlTypeDescriptors.add(type.getSqlTypeDescriptor());
        return type;
    }

    public static final boolean isStandardBasicSqlTypeDescriptor(SqlTypeDescriptor sqlTypeDescriptor) {
        return sqlTypeDescriptors.contains(sqlTypeDescriptor);
    }
}

