/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tuple;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import org.hibernate.HibernateLogger;
import org.hibernate.InstantiationException;
import org.hibernate.PropertyNotFoundException;
import org.hibernate.bytecode.ReflectionOptimizer;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.tuple.Instantiator;
import org.jboss.logging.Logger;

public class PojoInstantiator
implements Instantiator,
Serializable {
    private static final HibernateLogger LOG = (HibernateLogger)Logger.getMessageLogger(HibernateLogger.class, (String)PojoInstantiator.class.getName());
    private transient Constructor constructor;
    private final Class mappedClass;
    private final transient ReflectionOptimizer.InstantiationOptimizer optimizer;
    private final boolean embeddedIdentifier;
    private final Class proxyInterface;

    public PojoInstantiator(Component component, ReflectionOptimizer.InstantiationOptimizer optimizer) {
        this.mappedClass = component.getComponentClass();
        this.optimizer = optimizer;
        this.proxyInterface = null;
        this.embeddedIdentifier = false;
        try {
            this.constructor = ReflectHelper.getDefaultConstructor(this.mappedClass);
        }
        catch (PropertyNotFoundException pnfe) {
            LOG.noDefaultConstructor(this.mappedClass.getName());
            this.constructor = null;
        }
    }

    public PojoInstantiator(PersistentClass persistentClass, ReflectionOptimizer.InstantiationOptimizer optimizer) {
        this.mappedClass = persistentClass.getMappedClass();
        this.proxyInterface = persistentClass.getProxyInterface();
        this.embeddedIdentifier = persistentClass.hasEmbeddedIdentifier();
        this.optimizer = optimizer;
        try {
            this.constructor = ReflectHelper.getDefaultConstructor(this.mappedClass);
        }
        catch (PropertyNotFoundException pnfe) {
            LOG.noDefaultConstructor(this.mappedClass.getName());
            this.constructor = null;
        }
    }

    private void readObject(ObjectInputStream stream) throws ClassNotFoundException, IOException {
        stream.defaultReadObject();
        this.constructor = ReflectHelper.getDefaultConstructor(this.mappedClass);
    }

    @Override
    public Object instantiate() {
        if (ReflectHelper.isAbstractClass(this.mappedClass)) {
            throw new InstantiationException("Cannot instantiate abstract class or interface: ", this.mappedClass);
        }
        if (this.optimizer != null) {
            return this.optimizer.newInstance();
        }
        if (this.constructor == null) {
            throw new InstantiationException("No default constructor for entity: ", this.mappedClass);
        }
        try {
            return this.constructor.newInstance(null);
        }
        catch (Exception e) {
            throw new InstantiationException("Could not instantiate entity: ", this.mappedClass, e);
        }
    }

    @Override
    public Object instantiate(Serializable id) {
        boolean useEmbeddedIdentifierInstanceAsEntity = this.embeddedIdentifier && id != null && id.getClass().equals(this.mappedClass);
        return useEmbeddedIdentifierInstanceAsEntity ? id : this.instantiate();
    }

    @Override
    public boolean isInstance(Object object) {
        return this.mappedClass.isInstance(object) || this.proxyInterface != null && this.proxyInterface.isInstance(object);
    }
}

