/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.hbm2ddl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.HibernateLogger;
import org.hibernate.JDBCException;
import org.hibernate.cfg.Configuration;
import org.hibernate.cfg.Environment;
import org.hibernate.cfg.NamingStrategy;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.internal.FormatStyle;
import org.hibernate.engine.jdbc.internal.Formatter;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.jdbc.spi.SqlExceptionHelper;
import org.hibernate.engine.jdbc.spi.SqlStatementLogger;
import org.hibernate.internal.util.ConfigHelper;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.service.internal.ServiceRegistryImpl;
import org.hibernate.tool.hbm2ddl.ConnectionHelper;
import org.hibernate.tool.hbm2ddl.ManagedProviderConnectionHelper;
import org.hibernate.tool.hbm2ddl.SuppliedConnectionHelper;
import org.hibernate.tool.hbm2ddl.SuppliedConnectionProviderConnectionHelper;
import org.jboss.logging.Logger;

public class SchemaExport {
    private static final HibernateLogger LOG = (HibernateLogger)Logger.getMessageLogger(HibernateLogger.class, (String)SchemaExport.class.getName());
    private ConnectionHelper connectionHelper;
    private String[] dropSQL;
    private String[] createSQL;
    private String outputFile = null;
    private String importFiles;
    private Dialect dialect;
    private String delimiter;
    private final List exceptions = new ArrayList();
    private boolean haltOnError = false;
    private Formatter formatter;
    private SqlStatementLogger sqlStatementLogger;
    private static final String DEFAULT_IMPORT_FILE = "/import.sql";

    public SchemaExport(Configuration cfg) throws HibernateException {
        this(cfg, cfg.getProperties());
    }

    public SchemaExport(JdbcServices jdbcServices, Configuration cfg) throws HibernateException {
        this.dialect = jdbcServices.getDialect();
        this.connectionHelper = new SuppliedConnectionProviderConnectionHelper(jdbcServices.getConnectionProvider());
        this.dropSQL = cfg.generateDropSchemaScript(this.dialect);
        this.createSQL = cfg.generateSchemaCreationScript(this.dialect);
        this.sqlStatementLogger = jdbcServices.getSqlStatementLogger();
        this.formatter = (this.sqlStatementLogger.isFormat() ? FormatStyle.DDL : FormatStyle.NONE).getFormatter();
        this.importFiles = ConfigurationHelper.getString("hibernate.hbm2ddl.import_files", cfg.getProperties(), DEFAULT_IMPORT_FILE);
    }

    @Deprecated
    public SchemaExport(Configuration cfg, Properties properties) throws HibernateException {
        this.dialect = Dialect.getDialect(properties);
        Properties props = new Properties();
        props.putAll((Map<?, ?>)this.dialect.getDefaultProperties());
        props.putAll((Map<?, ?>)properties);
        this.connectionHelper = new ManagedProviderConnectionHelper(props);
        this.dropSQL = cfg.generateDropSchemaScript(this.dialect);
        this.createSQL = cfg.generateSchemaCreationScript(this.dialect);
        this.formatter = (ConfigurationHelper.getBoolean("hibernate.format_sql", props) ? FormatStyle.DDL : FormatStyle.NONE).getFormatter();
        this.importFiles = ConfigurationHelper.getString("hibernate.hbm2ddl.import_files", props, DEFAULT_IMPORT_FILE);
    }

    public SchemaExport(Configuration cfg, Connection connection) throws HibernateException {
        this.connectionHelper = new SuppliedConnectionHelper(connection);
        this.dialect = Dialect.getDialect(cfg.getProperties());
        this.dropSQL = cfg.generateDropSchemaScript(this.dialect);
        this.createSQL = cfg.generateSchemaCreationScript(this.dialect);
        this.formatter = (ConfigurationHelper.getBoolean("hibernate.format_sql", cfg.getProperties()) ? FormatStyle.DDL : FormatStyle.NONE).getFormatter();
        this.importFiles = ConfigurationHelper.getString("hibernate.hbm2ddl.import_files", cfg.getProperties(), DEFAULT_IMPORT_FILE);
    }

    public SchemaExport setOutputFile(String filename) {
        this.outputFile = filename;
        return this;
    }

    @Deprecated
    public SchemaExport setImportFile(String filename) {
        this.importFiles = filename;
        return this;
    }

    public SchemaExport setDelimiter(String delimiter) {
        this.delimiter = delimiter;
        return this;
    }

    public SchemaExport setFormat(boolean format) {
        this.formatter = (format ? FormatStyle.DDL : FormatStyle.NONE).getFormatter();
        return this;
    }

    public SchemaExport setHaltOnError(boolean haltOnError) {
        this.haltOnError = haltOnError;
        return this;
    }

    public void create(boolean script, boolean export) {
        this.execute(script, export, false, false);
    }

    public void drop(boolean script, boolean export) {
        this.execute(script, export, true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(boolean script, boolean export, boolean justDrop, boolean justCreate) {
        LOG.runningHbm2ddlSchemaExport();
        Connection connection = null;
        Writer outputFileWriter = null;
        ArrayList<NamedReader> importFileReaders = new ArrayList<NamedReader>();
        Statement statement = null;
        this.exceptions.clear();
        try {
            for (String currentFile : this.importFiles.split(",")) {
                try {
                    String resourceName = currentFile.trim();
                    InputStream stream = ConfigHelper.getResourceAsStream(resourceName);
                    importFileReaders.add(new NamedReader(resourceName, stream));
                }
                catch (HibernateException e) {
                    LOG.debugf("Import file not found: %s", currentFile);
                }
            }
            if (this.outputFile != null) {
                LOG.writingGeneratedSchemaToFile(this.outputFile);
                outputFileWriter = new FileWriter(this.outputFile);
            }
            if (export) {
                LOG.exportingGeneratedSchemaToDatabase();
                this.connectionHelper.prepare(true);
                connection = this.connectionHelper.getConnection();
                statement = connection.createStatement();
            }
            if (!justCreate) {
                this.drop(script, export, outputFileWriter, statement);
            }
            if (!justDrop) {
                this.create(script, export, outputFileWriter, statement);
                if (export && importFileReaders.size() > 0) {
                    for (NamedReader reader : importFileReaders) {
                        this.importScript(reader, statement);
                    }
                }
            }
            LOG.schemaExportComplete();
        }
        catch (Exception e) {
            this.exceptions.add(e);
            LOG.schemaExportUnsuccessful(e);
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
                if (connection != null) {
                    this.connectionHelper.release();
                }
            }
            catch (Exception e) {
                this.exceptions.add(e);
                LOG.unableToCloseConnection(e);
            }
            try {
                if (outputFileWriter != null) {
                    outputFileWriter.close();
                }
            }
            catch (IOException ioe) {
                this.exceptions.add(ioe);
                LOG.unableToCloseOutputFile(this.outputFile, ioe);
            }
            for (NamedReader reader : importFileReaders) {
                try {
                    reader.getReader().close();
                }
                catch (IOException ioe) {
                    this.exceptions.add(ioe);
                    LOG.unableToCloseInputFiles(reader.getName(), ioe);
                }
            }
        }
    }

    private void importScript(NamedReader importFileReader, Statement statement) throws IOException {
        LOG.executingImportScript(importFileReader.getName());
        BufferedReader reader = new BufferedReader(importFileReader.getReader());
        long lineNo = 0L;
        String sql = reader.readLine();
        while (sql != null) {
            try {
                ++lineNo;
                String trimmedSql = sql.trim();
                if (!(trimmedSql.length() == 0 || trimmedSql.startsWith("--") || trimmedSql.startsWith("//") || trimmedSql.startsWith("/*"))) {
                    if (trimmedSql.endsWith(";")) {
                        trimmedSql = trimmedSql.substring(0, trimmedSql.length() - 1);
                    }
                    LOG.debugf(trimmedSql, new Object[0]);
                    statement.execute(trimmedSql);
                }
            }
            catch (SQLException e) {
                throw new JDBCException("Error during import script execution at line " + lineNo, e);
            }
            sql = reader.readLine();
        }
    }

    private void create(boolean script, boolean export, Writer fileOutput, Statement statement) throws IOException {
        for (int j = 0; j < this.createSQL.length; ++j) {
            try {
                this.execute(script, export, fileOutput, statement, this.createSQL[j]);
                continue;
            }
            catch (SQLException e) {
                if (this.haltOnError) {
                    throw new JDBCException("Error during DDL export", e);
                }
                this.exceptions.add(e);
                LOG.unsuccessfulCreate(this.createSQL[j]);
                LOG.error(e.getMessage());
            }
        }
    }

    private void drop(boolean script, boolean export, Writer fileOutput, Statement statement) throws IOException {
        for (int i = 0; i < this.dropSQL.length; ++i) {
            try {
                this.execute(script, export, fileOutput, statement, this.dropSQL[i]);
                continue;
            }
            catch (SQLException e) {
                this.exceptions.add(e);
                LOG.debugf("Unsuccessful: %s", this.dropSQL[i]);
                LOG.debugf(e.getMessage(), new Object[0]);
            }
        }
    }

    private void execute(boolean script, boolean export, Writer fileOutput, Statement statement, String sql) throws IOException, SQLException {
        SqlExceptionHelper sqlExceptionHelper = new SqlExceptionHelper();
        String formatted = this.formatter.format(sql);
        if (this.delimiter != null) {
            formatted = formatted + this.delimiter;
        }
        if (script) {
            System.out.println(formatted);
        }
        LOG.debugf(formatted, new Object[0]);
        if (this.outputFile != null) {
            fileOutput.write(formatted + "\n");
        }
        if (export) {
            statement.executeUpdate(sql);
            try {
                SQLWarning warnings = statement.getWarnings();
                if (warnings != null) {
                    sqlExceptionHelper.logAndClearWarnings(this.connectionHelper.getConnection());
                }
            }
            catch (SQLException sqle) {
                LOG.unableToLogSqlWarnings(sqle);
            }
        }
    }

    private static ServiceRegistryImpl createServiceRegistry(Properties properties) {
        Environment.verifyProperties(properties);
        ConfigurationHelper.resolvePlaceHolders(properties);
        return new ServiceRegistryImpl(properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        try {
            Configuration cfg = new Configuration();
            boolean script = true;
            boolean drop = false;
            boolean create = false;
            boolean halt = false;
            boolean export = true;
            String outFile = null;
            String importFile = DEFAULT_IMPORT_FILE;
            String propFile = null;
            boolean format = false;
            String delim = null;
            for (int i = 0; i < args.length; ++i) {
                if (args[i].startsWith("--")) {
                    if (args[i].equals("--quiet")) {
                        script = false;
                        continue;
                    }
                    if (args[i].equals("--drop")) {
                        drop = true;
                        continue;
                    }
                    if (args[i].equals("--create")) {
                        create = true;
                        continue;
                    }
                    if (args[i].equals("--haltonerror")) {
                        halt = true;
                        continue;
                    }
                    if (args[i].equals("--text")) {
                        export = false;
                        continue;
                    }
                    if (args[i].startsWith("--output=")) {
                        outFile = args[i].substring(9);
                        continue;
                    }
                    if (args[i].startsWith("--import=")) {
                        importFile = args[i].substring(9);
                        continue;
                    }
                    if (args[i].startsWith("--properties=")) {
                        propFile = args[i].substring(13);
                        continue;
                    }
                    if (args[i].equals("--format")) {
                        format = true;
                        continue;
                    }
                    if (args[i].startsWith("--delimiter=")) {
                        delim = args[i].substring(12);
                        continue;
                    }
                    if (args[i].startsWith("--config=")) {
                        cfg.configure(args[i].substring(9));
                        continue;
                    }
                    if (!args[i].startsWith("--naming=")) continue;
                    cfg.setNamingStrategy((NamingStrategy)ReflectHelper.classForName(args[i].substring(9)).newInstance());
                    continue;
                }
                String filename = args[i];
                if (filename.endsWith(".jar")) {
                    cfg.addJar(new File(filename));
                    continue;
                }
                cfg.addFile(filename);
            }
            if (propFile != null) {
                Properties props = new Properties();
                props.putAll((Map<?, ?>)cfg.getProperties());
                props.load(new FileInputStream(propFile));
                cfg.setProperties(props);
            }
            if (importFile != null) {
                cfg.setProperty("hibernate.hbm2ddl.import_files", importFile);
            }
            ServiceRegistryImpl serviceRegistry = SchemaExport.createServiceRegistry(cfg.getProperties());
            try {
                SchemaExport se = new SchemaExport(serviceRegistry.getService(JdbcServices.class), cfg).setHaltOnError(halt).setOutputFile(outFile).setDelimiter(delim);
                if (format) {
                    se.setFormat(true);
                }
                se.execute(script, export, drop, create);
            }
            finally {
                serviceRegistry.destroy();
            }
        }
        catch (Exception e) {
            LOG.unableToCreateSchema(e);
            e.printStackTrace();
        }
    }

    public List getExceptions() {
        return this.exceptions;
    }

    private class NamedReader {
        private final Reader reader;
        private final String name;

        public NamedReader(String name, InputStream stream) {
            this.name = name;
            this.reader = new InputStreamReader(stream);
        }

        public Reader getReader() {
            return this.reader;
        }

        public String getName() {
            return this.name;
        }
    }
}

