/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.stat;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.hibernate.cache.CacheKey;
import org.hibernate.cache.Region;
import org.hibernate.stat.CategorizedStatistics;
import org.hibernate.stat.SecondLevelCacheStatistics;

public class ConcurrentSecondLevelCacheStatisticsImpl
extends CategorizedStatistics
implements SecondLevelCacheStatistics {
    private final transient Region region;
    private AtomicLong hitCount = new AtomicLong();
    private AtomicLong missCount = new AtomicLong();
    private AtomicLong putCount = new AtomicLong();

    ConcurrentSecondLevelCacheStatisticsImpl(Region region) {
        super(region.getName());
        this.region = region;
    }

    @Override
    public long getHitCount() {
        return this.hitCount.get();
    }

    @Override
    public long getMissCount() {
        return this.missCount.get();
    }

    @Override
    public long getPutCount() {
        return this.putCount.get();
    }

    @Override
    public long getElementCountInMemory() {
        return this.region.getElementCountInMemory();
    }

    @Override
    public long getElementCountOnDisk() {
        return this.region.getElementCountOnDisk();
    }

    @Override
    public long getSizeInMemory() {
        return this.region.getSizeInMemory();
    }

    @Override
    public Map getEntries() {
        HashMap map = new HashMap();
        for (Map.Entry me : this.region.toMap().entrySet()) {
            map.put(((CacheKey)me.getKey()).getKey(), me.getValue());
        }
        return map;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder().append("SecondLevelCacheStatistics").append("[hitCount=").append(this.hitCount).append(",missCount=").append(this.missCount).append(",putCount=").append(this.putCount);
        if (this.region != null) {
            buf.append(",elementCountInMemory=").append(this.getElementCountInMemory()).append(",elementCountOnDisk=").append(this.getElementCountOnDisk()).append(",sizeInMemory=").append(this.getSizeInMemory());
        }
        buf.append(']');
        return buf.toString();
    }

    void incrementHitCount() {
        this.hitCount.getAndIncrement();
    }

    void incrementMissCount() {
        this.missCount.getAndIncrement();
    }

    void incrementPutCount() {
        this.putCount.getAndIncrement();
    }
}

