/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.service.jta.platform.internal;

import java.util.Properties;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.hibernate.service.jndi.spi.JndiService;
import org.hibernate.service.jta.platform.internal.AbstractJtaPlatform;
import org.hibernate.service.jta.platform.internal.JtaSynchronizationStrategy;
import org.hibernate.service.jta.platform.internal.TransactionManagerBasedSynchronizationStrategy;
import org.hibernate.transaction.TransactionManagerLookup;

public class TransactionManagerLookupBridge
extends AbstractJtaPlatform {
    private final TransactionManagerLookup lookup;
    private final Properties jndiProperties;
    private final JtaSynchronizationStrategy synchronizationStrategy = new TransactionManagerBasedSynchronizationStrategy(this);

    public TransactionManagerLookupBridge(TransactionManagerLookup lookup, Properties jndiProperties) {
        this.lookup = lookup;
        this.jndiProperties = jndiProperties;
    }

    @Override
    protected TransactionManager locateTransactionManager() {
        return this.lookup.getTransactionManager(this.jndiProperties);
    }

    @Override
    protected UserTransaction locateUserTransaction() {
        return (UserTransaction)this.serviceRegistry().getService(JndiService.class).locate(this.lookup.getUserTransactionName());
    }

    @Override
    protected JtaSynchronizationStrategy getSynchronizationStrategy() {
        return this.synchronizationStrategy;
    }

    @Override
    public Object getTransactionIdentifier(Transaction transaction) {
        return this.lookup.getTransactionIdentifier(transaction);
    }
}

