/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.service.jndi.internal;

import java.util.Hashtable;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.hibernate.HibernateLogger;
import org.hibernate.internal.util.jndi.JndiException;
import org.hibernate.internal.util.jndi.JndiHelper;
import org.hibernate.service.jndi.spi.JndiService;
import org.jboss.logging.Logger;

public class JndiServiceImpl
implements JndiService {
    private static final HibernateLogger LOG = (HibernateLogger)Logger.getMessageLogger(HibernateLogger.class, (String)JndiServiceImpl.class.getName());
    private final Hashtable initialContextSettings;

    public JndiServiceImpl(Map configurationValues) {
        this.initialContextSettings = JndiHelper.extractJndiProperties(configurationValues);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object locate(String jndiName) {
        InitialContext initialContext = this.buildInitialContext();
        try {
            Object object = JndiHelper.locate(jndiName, initialContext);
            return object;
        }
        finally {
            try {
                initialContext.close();
            }
            catch (NamingException e) {
                LOG.unableToCloseInitialContext(e.toString());
            }
        }
    }

    private InitialContext buildInitialContext() {
        try {
            return this.initialContextSettings.size() == 0 ? new InitialContext() : new InitialContext(this.initialContextSettings);
        }
        catch (NamingException e) {
            throw new JndiException("Unable to open InitialContext", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bind(String jndiName, Object value) {
        InitialContext initialContext = this.buildInitialContext();
        try {
            JndiHelper.bind(jndiName, value, initialContext);
        }
        finally {
            try {
                initialContext.close();
            }
            catch (NamingException e) {
                LOG.unableToCloseInitialContext(e.toString());
            }
        }
    }
}

