/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.service.jmx.internal;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.hibernate.HibernateException;
import org.hibernate.HibernateLogger;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.service.jmx.spi.JmxService;
import org.hibernate.service.spi.Manageable;
import org.hibernate.service.spi.Service;
import org.hibernate.service.spi.Stoppable;
import org.jboss.logging.Logger;

public class JmxServiceImpl
implements JmxService,
Stoppable {
    private static final HibernateLogger LOG = (HibernateLogger)Logger.getMessageLogger(HibernateLogger.class, (String)JmxServiceImpl.class.getName());
    public static final String JMX_PLATFORM_SERVER = "hibernate.jmx.usePlatformServer";
    public static final String JMX_AGENT_ID = "hibernate.jmx.agentId";
    public static final String JMX_DOMAIN_NAME = "hibernate.jmx.defaultDomain";
    public static final String JMX_SF_NAME = "hibernate.jmx.sessionFactoryName";
    private final boolean usePlatformServer;
    private final String agentId;
    private final String defaultDomain;
    private final String sessionFactoryName;
    private boolean startedServer;
    private ArrayList<ObjectName> registeredMBeans;
    public static final String DEFAULT_OBJ_NAME_DOMAIN = "org.hibernate.core";
    public static final String OBJ_NAME_TEMPLATE = "%s:sessionFactory=%s,serviceRole=%s,serviceType=%s";

    public JmxServiceImpl(Map configValues) {
        this.usePlatformServer = ConfigurationHelper.getBoolean(JMX_PLATFORM_SERVER, configValues);
        this.agentId = (String)configValues.get(JMX_AGENT_ID);
        this.defaultDomain = (String)configValues.get(JMX_DOMAIN_NAME);
        this.sessionFactoryName = ConfigurationHelper.getString(JMX_SF_NAME, configValues, ConfigurationHelper.getString("hibernate.session_factory_name", configValues));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        try {
            if (this.startedServer || this.registeredMBeans != null) {
                MBeanServer mBeanServer = this.findServer();
                if (mBeanServer == null) {
                    LOG.unableToLocateMBeanServer();
                    return;
                }
                if (this.registeredMBeans != null) {
                    for (ObjectName objectName : this.registeredMBeans) {
                        try {
                            LOG.trace("Unregistering registered MBean [ON=" + objectName + "]");
                            mBeanServer.unregisterMBean(objectName);
                        }
                        catch (Exception e) {
                            LOG.debugf("Unable to unregsiter registered MBean [ON=%s] : %s", objectName, e.toString());
                        }
                    }
                }
                if (this.startedServer) {
                    LOG.trace("Attempting to release created MBeanServer");
                    try {
                        MBeanServerFactory.releaseMBeanServer(mBeanServer);
                    }
                    catch (Exception e) {
                        LOG.unableToReleaseCreatedMBeanServer(e.toString());
                    }
                }
            }
        }
        finally {
            this.startedServer = false;
            if (this.registeredMBeans != null) {
                this.registeredMBeans.clear();
                this.registeredMBeans = null;
            }
        }
    }

    @Override
    public void registerService(Manageable service, Class<? extends Service> serviceRole) {
        String domain = service.getManagementDomain() == null ? DEFAULT_OBJ_NAME_DOMAIN : service.getManagementDomain();
        String serviceType = service.getManagementServiceType() == null ? service.getClass().getName() : service.getManagementServiceType();
        try {
            ObjectName objectName = new ObjectName(String.format(OBJ_NAME_TEMPLATE, domain, this.sessionFactoryName, serviceRole.getName(), serviceType));
            this.registerMBean(objectName, service.getManagementBean());
        }
        catch (HibernateException e) {
            throw e;
        }
        catch (MalformedObjectNameException e) {
            throw new HibernateException("Unable to generate service IbjectName", e);
        }
    }

    @Override
    public void registerMBean(ObjectName objectName, Object mBean) {
        MBeanServer mBeanServer = this.findServer();
        if (mBeanServer == null) {
            if (this.startedServer) {
                throw new HibernateException("Could not locate previously started MBeanServer");
            }
            mBeanServer = this.startMBeanServer();
            this.startedServer = true;
        }
        try {
            mBeanServer.registerMBean(mBean, objectName);
            if (this.registeredMBeans == null) {
                this.registeredMBeans = new ArrayList();
            }
            this.registeredMBeans.add(objectName);
        }
        catch (Exception e) {
            throw new HibernateException("Unable to register MBean [ON=" + objectName + "]", e);
        }
    }

    private MBeanServer findServer() {
        if (this.usePlatformServer) {
            return ManagementFactory.getPlatformMBeanServer();
        }
        ArrayList<MBeanServer> mbeanServers = MBeanServerFactory.findMBeanServer(this.agentId);
        if (this.defaultDomain == null) {
            return mbeanServers.get(0);
        }
        for (MBeanServer mbeanServer : mbeanServers) {
            if (!this.defaultDomain.equals(mbeanServer.getDefaultDomain())) continue;
            return mbeanServer;
        }
        return null;
    }

    private MBeanServer startMBeanServer() {
        try {
            MBeanServer mbeanServer = MBeanServerFactory.createMBeanServer(this.defaultDomain);
            return mbeanServer;
        }
        catch (Exception e) {
            throw new HibernateException("Unable to start MBeanServer", e);
        }
    }
}

