/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.service.jdbc.connections.internal;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.HibernateLogger;
import org.hibernate.cfg.Environment;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.service.jdbc.connections.internal.ConnectionProviderInitiator;
import org.hibernate.service.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.service.spi.Configurable;
import org.hibernate.service.spi.Stoppable;
import org.hibernate.service.spi.UnknownUnwrapTypeException;
import org.jboss.logging.Logger;

public class DriverManagerConnectionProviderImpl
implements ConnectionProvider,
Configurable,
Stoppable {
    private static final HibernateLogger LOG = (HibernateLogger)Logger.getMessageLogger(HibernateLogger.class, (String)DriverManagerConnectionProviderImpl.class.getName());
    private String url;
    private Properties connectionProps;
    private Integer isolation;
    private int poolSize;
    private boolean autocommit;
    private final ArrayList<Connection> pool = new ArrayList();
    private int checkedOut = 0;
    private boolean stopped;

    @Override
    public boolean isUnwrappableAs(Class unwrapType) {
        return ConnectionProvider.class.equals((Object)unwrapType) || DriverManagerConnectionProviderImpl.class.isAssignableFrom(unwrapType);
    }

    @Override
    public <T> T unwrap(Class<T> unwrapType) {
        if (ConnectionProvider.class.equals(unwrapType) || DriverManagerConnectionProviderImpl.class.isAssignableFrom(unwrapType)) {
            return (T)this;
        }
        throw new UnknownUnwrapTypeException(unwrapType);
    }

    @Override
    public void configure(Map configurationValues) {
        LOG.usingHibernateBuiltInConnectionPool();
        String driverClassName = (String)configurationValues.get("hibernate.connection.driver_class");
        if (driverClassName == null) {
            LOG.jdbcDriverNotSpecified("hibernate.connection.driver_class");
        } else {
            try {
                Class.forName(driverClassName);
            }
            catch (ClassNotFoundException cnfe) {
                try {
                    ReflectHelper.classForName(driverClassName);
                }
                catch (ClassNotFoundException e) {
                    throw new HibernateException("Specified JDBC Driver " + driverClassName + " class not found", e);
                }
            }
        }
        this.poolSize = ConfigurationHelper.getInt("hibernate.connection.pool_size", configurationValues, 20);
        LOG.hibernateConnectionPoolSize(this.poolSize);
        this.autocommit = ConfigurationHelper.getBoolean("hibernate.connection.autocommit", configurationValues);
        LOG.autoCommitMode(this.autocommit);
        this.isolation = ConfigurationHelper.getInteger("hibernate.connection.isolation", configurationValues);
        if (this.isolation != null) {
            LOG.jdbcIsolationLevel(Environment.isolationLevelToString(this.isolation));
        }
        this.url = (String)configurationValues.get("hibernate.connection.url");
        if (this.url == null) {
            String msg = LOG.jdbcUrlNotSpecified("hibernate.connection.url");
            LOG.error(msg);
            throw new HibernateException(msg);
        }
        this.connectionProps = ConnectionProviderInitiator.getConnectionProperties(configurationValues);
        LOG.usingDriver(driverClassName, this.url);
        if (LOG.isDebugEnabled()) {
            LOG.connectionProperties(this.connectionProps);
        } else {
            LOG.connectionProperties(ConfigurationHelper.maskOut(this.connectionProps, "password"));
        }
    }

    @Override
    public void stop() {
        LOG.cleaningUpConnectionPool(this.url);
        for (Connection connection : this.pool) {
            try {
                connection.close();
            }
            catch (SQLException sqle) {
                LOG.unableToClosePooledConnection(sqle);
            }
        }
        this.pool.clear();
        this.stopped = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection getConnection() throws SQLException {
        LOG.trace("Total checked-out connections: " + this.checkedOut);
        ArrayList<Connection> arrayList = this.pool;
        synchronized (arrayList) {
            if (!this.pool.isEmpty()) {
                int last = this.pool.size() - 1;
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Using pooled JDBC connection, pool size: " + last);
                    ++this.checkedOut;
                }
                Connection pooled = this.pool.remove(last);
                if (this.isolation != null) {
                    pooled.setTransactionIsolation(this.isolation);
                }
                if (pooled.getAutoCommit() != this.autocommit) {
                    pooled.setAutoCommit(this.autocommit);
                }
                return pooled;
            }
        }
        LOG.debugf("Opening new JDBC connection", new Object[0]);
        Connection conn = DriverManager.getConnection(this.url, this.connectionProps);
        if (this.isolation != null) {
            conn.setTransactionIsolation(this.isolation);
        }
        if (conn.getAutoCommit() != this.autocommit) {
            conn.setAutoCommit(this.autocommit);
        }
        LOG.debugf("Created connection to: %s, Isolation Level: %s", this.url, conn.getTransactionIsolation());
        ++this.checkedOut;
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeConnection(Connection conn) throws SQLException {
        --this.checkedOut;
        ArrayList<Connection> arrayList = this.pool;
        synchronized (arrayList) {
            int currentSize = this.pool.size();
            if (currentSize < this.poolSize) {
                LOG.trace("Returning connection to pool, pool size: " + (currentSize + 1));
                this.pool.add(conn);
                return;
            }
        }
        LOG.debugf("Closing JDBC connection", new Object[0]);
        conn.close();
    }

    protected void finalize() throws Throwable {
        if (!this.stopped) {
            this.stop();
        }
        super.finalize();
    }

    @Override
    public boolean supportsAggressiveRelease() {
        return false;
    }
}

