/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.service.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.hibernate.HibernateException;
import org.hibernate.HibernateLogger;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.service.internal.ServiceInitializer;
import org.hibernate.service.internal.proxy.javassist.ServiceProxyFactoryFactoryImpl;
import org.hibernate.service.spi.Service;
import org.hibernate.service.spi.ServiceInitiator;
import org.hibernate.service.spi.StandardServiceInitiators;
import org.hibernate.service.spi.Stoppable;
import org.hibernate.service.spi.UnknownServiceException;
import org.hibernate.service.spi.proxy.ServiceProxyFactory;
import org.hibernate.service.spi.proxy.ServiceProxyTargetSource;
import org.jboss.logging.Logger;

public class ServiceRegistryImpl
implements ServiceProxyTargetSource {
    private static final HibernateLogger LOG = (HibernateLogger)Logger.getMessageLogger(HibernateLogger.class, (String)ServiceRegistryImpl.class.getName());
    private final ServiceInitializer initializer;
    private ServiceProxyFactory serviceProxyFactory = new ServiceProxyFactoryFactoryImpl().makeServiceProxyFactory(this);
    private ConcurrentHashMap<Class, ServiceBinding> serviceBindingMap;
    private List<Service> serviceList = new ArrayList<Service>();

    public ServiceRegistryImpl(Map configurationValues) {
        this(StandardServiceInitiators.LIST, configurationValues);
    }

    public ServiceRegistryImpl(List<ServiceInitiator> serviceInitiators, Map configurationValues) {
        this.initializer = new ServiceInitializer(this, serviceInitiators, ConfigurationHelper.clone(configurationValues));
        int anticipatedSize = serviceInitiators.size() + 5;
        this.serviceBindingMap = CollectionHelper.concurrentMap(anticipatedSize);
        this.serviceList = CollectionHelper.arrayList(anticipatedSize);
    }

    public void destroy() {
        ListIterator<Service> serviceIterator = this.serviceList.listIterator(this.serviceList.size());
        while (serviceIterator.hasPrevious()) {
            Service service = serviceIterator.previous();
            if (!Stoppable.class.isInstance(service)) continue;
            try {
                ((Stoppable)((Object)service)).stop();
            }
            catch (Exception e) {
                LOG.unableToStopService(service.getClass(), e.toString());
            }
        }
        this.serviceList.clear();
        this.serviceList = null;
        this.serviceBindingMap.clear();
        this.serviceBindingMap = null;
    }

    @Override
    public <T extends Service> T getService(Class<T> serviceRole) {
        return (T)((Service)this.locateOrCreateServiceBinding(serviceRole).getProxy());
    }

    private <T extends Service> ServiceBinding<T> locateOrCreateServiceBinding(Class<T> serviceRole) {
        ServiceBinding serviceBinding = this.serviceBindingMap.get(serviceRole);
        if (serviceBinding == null) {
            T proxy = this.serviceProxyFactory.makeProxy(serviceRole);
            serviceBinding = new ServiceBinding(proxy);
            this.serviceBindingMap.put(serviceRole, serviceBinding);
        }
        return serviceBinding;
    }

    @Override
    public <T extends Service> T getServiceInternal(Class<T> serviceRole) {
        ServiceBinding serviceBinding = this.serviceBindingMap.get(serviceRole);
        if (serviceBinding == null) {
            throw new HibernateException("Only proxies should invoke #getServiceInternal");
        }
        Service service = (Service)serviceBinding.getTarget();
        if (service == null) {
            service = this.initializer.initializeService(serviceRole);
            serviceBinding.setTarget(service);
        }
        if (service == null) {
            throw new UnknownServiceException(serviceRole);
        }
        return (T)service;
    }

    @Override
    public <T extends Service> void registerService(Class<T> serviceRole, T service) {
        ServiceBinding<T> serviceBinding = this.locateOrCreateServiceBinding(serviceRole);
        Service priorServiceInstance = (Service)serviceBinding.getTarget();
        serviceBinding.setTarget(service);
        if (priorServiceInstance != null) {
            this.serviceList.remove(priorServiceInstance);
        }
        this.serviceList.add(service);
    }

    @Override
    public void registerServiceInitiator(ServiceInitiator initiator) {
        ServiceBinding serviceBinding = this.serviceBindingMap.get(initiator.getServiceInitiated());
        if (serviceBinding != null) {
            serviceBinding.setTarget(null);
        }
        this.initializer.registerServiceInitiator(initiator);
    }

    private static final class ServiceBinding<T> {
        private final T proxy;
        private T target;

        private ServiceBinding(T proxy) {
            this.proxy = proxy;
        }

        public T getProxy() {
            return this.proxy;
        }

        public T getTarget() {
            return this.target;
        }

        public void setTarget(T target) {
            this.target = target;
        }
    }
}

