/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.service.internal;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.HibernateLogger;
import org.hibernate.service.internal.ServiceDependencyException;
import org.hibernate.service.internal.ServiceRegistryImpl;
import org.hibernate.service.jmx.spi.JmxService;
import org.hibernate.service.spi.Configurable;
import org.hibernate.service.spi.InjectService;
import org.hibernate.service.spi.Manageable;
import org.hibernate.service.spi.Service;
import org.hibernate.service.spi.ServiceException;
import org.hibernate.service.spi.ServiceInitiator;
import org.hibernate.service.spi.ServiceRegistryAwareService;
import org.hibernate.service.spi.Startable;
import org.hibernate.service.spi.UnknownServiceException;
import org.jboss.logging.Logger;

public class ServiceInitializer {
    private static final HibernateLogger LOG = (HibernateLogger)Logger.getMessageLogger(HibernateLogger.class, (String)ServiceInitializer.class.getName());
    private final ServiceRegistryImpl servicesRegistry;
    private final Map<Class, ServiceInitiator> serviceInitiatorMap;
    private final Map configurationValues;

    public ServiceInitializer(ServiceRegistryImpl servicesRegistry, List<ServiceInitiator> serviceInitiators, Map configurationValues) {
        this.servicesRegistry = servicesRegistry;
        this.serviceInitiatorMap = ServiceInitializer.toMap(serviceInitiators);
        this.configurationValues = configurationValues;
    }

    private static Map<Class, ServiceInitiator> toMap(List<ServiceInitiator> serviceInitiators) {
        HashMap<Class, ServiceInitiator> result = new HashMap<Class, ServiceInitiator>();
        for (ServiceInitiator initiator : serviceInitiators) {
            result.put(initiator.getServiceInitiated(), initiator);
        }
        return result;
    }

    void registerServiceInitiator(ServiceInitiator serviceInitiator) {
        boolean overwritten;
        ServiceInitiator previous = this.serviceInitiatorMap.put(serviceInitiator.getServiceInitiated(), serviceInitiator);
        boolean bl = overwritten = previous != null;
        if (overwritten) {
            LOG.debugf("Over-wrote existing service initiator [role=%s]", serviceInitiator.getServiceInitiated().getName());
        }
    }

    public <T extends Service> T initializeService(Class<T> serviceRole) {
        LOG.trace("Initializing service [role=" + serviceRole.getName() + "]");
        T service = this.createService(serviceRole);
        if (service == null) {
            return null;
        }
        this.configureService(service);
        this.startService(service, serviceRole);
        return service;
    }

    private <T extends Service> T createService(Class<T> serviceRole) {
        ServiceInitiator initiator = this.serviceInitiatorMap.get(serviceRole);
        if (initiator == null) {
            throw new UnknownServiceException(serviceRole);
        }
        try {
            Object service = initiator.initiateService(this.configurationValues, this.servicesRegistry);
            this.servicesRegistry.registerService(serviceRole, service);
            return service;
        }
        catch (ServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServiceException("Unable to create requested service [" + serviceRole.getName() + "]", e);
        }
    }

    private <T extends Service> void configureService(T service) {
        this.applyInjections(service);
        if (Configurable.class.isInstance(service)) {
            ((Configurable)((Object)service)).configure(this.configurationValues);
        }
        if (ServiceRegistryAwareService.class.isInstance(service)) {
            ((ServiceRegistryAwareService)((Object)service)).injectServices(this.servicesRegistry);
        }
    }

    private <T extends Service> void applyInjections(T service) {
        try {
            for (Method method : service.getClass().getMethods()) {
                InjectService injectService = method.getAnnotation(InjectService.class);
                if (injectService == null) continue;
                this.applyInjection(service, method, injectService);
            }
        }
        catch (NullPointerException e) {
            LOG.error("NPE injecting service deps : " + service.getClass().getName());
        }
    }

    private <T extends Service> void applyInjection(T service, Method injectionMethod, InjectService injectService) {
        Object dependantService;
        if (injectionMethod.getParameterTypes() == null || injectionMethod.getParameterTypes().length != 1) {
            throw new ServiceDependencyException("Encountered @InjectService on method with unexpected number of parameters");
        }
        Class<?> dependentServiceRole = injectService.serviceRole();
        if (dependentServiceRole == null || dependentServiceRole.equals(Void.class)) {
            dependentServiceRole = injectionMethod.getParameterTypes()[0];
        }
        if ((dependantService = this.servicesRegistry.getService(dependentServiceRole)) == null) {
            if (injectService.required()) {
                throw new ServiceDependencyException("Dependency [" + dependentServiceRole + "] declared by service [" + service + "] not found");
            }
        } else {
            try {
                injectionMethod.invoke(service, dependantService);
            }
            catch (Exception e) {
                throw new ServiceDependencyException("Cannot inject dependency service", e);
            }
        }
    }

    private <T extends Service> void startService(T service, Class serviceRole) {
        if (Startable.class.isInstance(service)) {
            ((Startable)((Object)service)).start();
        }
        if (Manageable.class.isInstance(service)) {
            this.servicesRegistry.getService(JmxService.class).registerService((Manageable)((Object)service), serviceRole);
        }
    }
}

