/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.persister.internal;

import java.util.Map;
import org.hibernate.persister.internal.PersisterFactoryImpl;
import org.hibernate.persister.spi.PersisterFactory;
import org.hibernate.service.classloading.spi.ClassLoaderService;
import org.hibernate.service.spi.ServiceException;
import org.hibernate.service.spi.ServiceInitiator;
import org.hibernate.service.spi.ServiceRegistry;

public class PersisterFactoryInitiator
implements ServiceInitiator<PersisterFactory> {
    public static final PersisterFactoryInitiator INSTANCE = new PersisterFactoryInitiator();
    public static final String IMPL_NAME = "hibernate.persister.factory";

    @Override
    public Class<PersisterFactory> getServiceInitiated() {
        return PersisterFactory.class;
    }

    @Override
    public PersisterFactory initiateService(Map configurationValues, ServiceRegistry registry) {
        Object customImpl = configurationValues.get(IMPL_NAME);
        if (customImpl == null) {
            return new PersisterFactoryImpl();
        }
        if (PersisterFactory.class.isInstance(customImpl)) {
            return (PersisterFactory)customImpl;
        }
        Class customImplClass = Class.class.isInstance(customImpl) ? (Class)customImpl : registry.getService(ClassLoaderService.class).classForName(customImpl.toString());
        try {
            return (PersisterFactory)customImplClass.newInstance();
        }
        catch (Exception e) {
            throw new ServiceException("Could not initialize custom PersisterFactory impl [" + customImplClass.getName() + "]", e);
        }
    }
}

